/*
 * Decompiled with CFR 0.152.
 */
package net.java.mavenincrementalbuild.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePersistence<T> {
    private final Log LOGGER;
    private File dataFile;
    private String directory;
    private String path;
    protected T data;

    public FilePersistence(Log LOGGER, String directory, String fileName) {
        this.LOGGER = LOGGER;
        this.directory = directory;
        this.path = directory + File.separator + fileName;
        this.dataFile = new File(this.path);
        LOGGER.debug((CharSequence)("Using file : " + this.dataFile.getAbsolutePath()));
    }

    public void load() throws IOException {
        if (this.dataFile.exists()) {
            this.LOGGER.debug((CharSequence)("Loading previous data in " + this.path + " ..."));
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(this.dataFile));
            try {
                this.data = input.readObject();
            }
            catch (ClassNotFoundException e) {
                this.LOGGER.error((CharSequence)"Error deserializing file : ", (Throwable)e);
                throw new RuntimeException("Error deserializing file.", e);
            }
            input.close();
        } else {
            this.LOGGER.debug((CharSequence)("Previous file " + this.path + " not found."));
        }
    }

    public void save() throws IOException {
        this.LOGGER.debug((CharSequence)("Saving file " + this.path + " ..."));
        File dir = new File(this.directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.dataFile));
        output.writeObject(this.data);
        output.flush();
        output.close();
    }
}

