/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Mapping;
import net.hasor.web.MimeType;

public interface Invoker
extends MimeType {
    public static final String RETURN_DATA_KEY = "resultData";
    public static final String ROOT_DATA_KEY = "rootData";
    public static final String REQUEST_KEY = "request";
    public static final String RESPONSE_KEY = "response";

    public AppContext getAppContext();

    public HttpServletRequest getHttpRequest();

    public HttpServletResponse getHttpResponse();

    public String contentType();

    public void contentType(String var1);

    public Mapping ownerMapping();

    public String getJsonBodyString();

    default public Set<String> keySet() {
        Enumeration names = this.getHttpRequest().getAttributeNames();
        HashSet<String> nameSet = new HashSet<String>();
        while (names.hasMoreElements()) {
            nameSet.add((String)names.nextElement());
        }
        return nameSet;
    }

    default public <T> T fillForm(Class<? extends T> formType) {
        try {
            return (T)this.fillForm(formType, this.getAppContext().justInject(formType.newInstance()));
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    public <T> T fillForm(Class<? extends T> var1, T var2);

    default public Object get(String key) {
        return this.getHttpRequest().getAttribute(key);
    }

    default public void remove(String key) {
        if (StringUtils.isBlank((String)key) || this.isLockKey(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.getHttpRequest().removeAttribute(key);
    }

    default public void put(String key, Object value) {
        if (StringUtils.isBlank((String)key) || this.isLockKey(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.getHttpRequest().setAttribute(key, value);
    }

    public boolean isLockKey(String var1);

    public void lockKey(String var1);

    default public String getRequestPath() {
        String contextPath = this.getHttpRequest().getContextPath();
        String requestPath = this.getHttpRequest().getRequestURI();
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }

    default public void forEach(BiConsumer<String, Object> action) {
        Objects.requireNonNull(action);
        for (String key : this.keySet()) {
            Object optionValue = this.get(key);
            action.accept(key, optionValue);
        }
    }

    default public void putIfAbsent(String key, Object value) {
        if (this.get(key) == null) {
            this.put(key, value);
        }
    }

    default public Object getOrDefault(String key, Object defaultValue) {
        Object v = null;
        v = this.get(key);
        return v != null ? v : defaultValue;
    }

    default public <V> V getOrMap(String key, Function<Object, V> defaultValue) {
        return defaultValue.apply(this.get(key));
    }

    default public void computeIfAbsent(String key, Function<String, Object> mappingFunction) {
        Object newValue;
        Objects.requireNonNull(mappingFunction);
        if (this.get(key) == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
        }
    }
}

