/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import net.hasor.db.datasource.ConnectionManager;
import net.hasor.db.datasource.SavepointManager;

public class ConnectionHolder
implements SavepointManager,
ConnectionManager {
    private int referenceCount;
    private DataSource dataSource;
    private Connection connection;
    private static final String SAVEPOINT_NAME_PREFIX = "SAVEPOINT_";
    private int savepointCounter = 0;
    private Boolean savepointSupported;

    ConnectionHolder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public synchronized void requested() {
        ++this.referenceCount;
    }

    @Override
    public synchronized void released() throws SQLException {
        --this.referenceCount;
        if (!this.isOpen() && this.connection != null) {
            try {
                this.savepointCounter = 0;
                this.savepointSupported = null;
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (!this.isOpen()) {
            return null;
        }
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    @Override
    public boolean isOpen() {
        return this.referenceCount != 0;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean hasTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        return !conn.getAutoCommit();
    }

    public void setTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null && conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
    }

    public void cancelTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null && !conn.getAutoCommit()) {
            conn.setAutoCommit(true);
        }
    }

    private Connection checkConn(Connection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("Connection is null.");
        }
        return conn;
    }

    @Override
    public Savepoint createSavepoint() throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        ++this.savepointCounter;
        return conn.setSavepoint(SAVEPOINT_NAME_PREFIX + this.savepointCounter);
    }

    @Override
    public void rollbackToSavepoint(Savepoint savepoint) throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        conn.releaseSavepoint(savepoint);
    }

    @Override
    public boolean supportSavepoint() throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        if (this.savepointSupported == null) {
            this.savepointSupported = conn.getMetaData().supportsSavepoints();
        }
        return this.savepointSupported;
    }
}

