/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import java.math.RoundingMode;
import net.hasor.utils.StringUtils;

public enum RoundingEnum {
    UP(RoundingMode.UP),
    DOWN(RoundingMode.DOWN),
    CEILING(RoundingMode.CEILING),
    FLOOR(RoundingMode.FLOOR),
    HALF_UP(RoundingMode.HALF_UP),
    HALF_DOWN(RoundingMode.HALF_DOWN),
    HALF_EVEN(RoundingMode.HALF_EVEN),
    UNNECESSARY(RoundingMode.UNNECESSARY);

    private RoundingMode modeNum;

    private RoundingEnum(RoundingMode modeNum) {
        this.modeNum = modeNum;
    }

    public RoundingMode getModeNum() {
        return this.modeNum;
    }

    public static RoundingEnum find(String modeType) {
        if (StringUtils.isBlank((String)modeType)) {
            return HALF_UP;
        }
        for (RoundingEnum pre : RoundingEnum.values()) {
            if (!pre.name().equalsIgnoreCase(modeType)) continue;
            return pre;
        }
        return HALF_UP;
    }
}

