/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import net.hasor.dataql.Hints;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.dataql.runtime.operator.ops.AbstractDOP;

public class BinaryDOP
extends AbstractDOP {
    private static final Integer BOOL_FASLE = 0;
    private static final Integer BOOL_TRUE = 1;

    @Override
    public Object doDyadicProcess(String operator, Object fstObject, Object secObject, Hints option) throws InstructRuntimeException {
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FASLE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FASLE;
        }
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isNumber(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FASLE;
            Object object = secObject = OperatorUtils.eq((Number)secObject, 0) ? BOOL_FASLE : BOOL_TRUE;
        }
        if (OperatorUtils.isNumber(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = OperatorUtils.eq((Number)fstObject, 0) ? BOOL_FASLE : BOOL_TRUE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FASLE;
        }
        if ("&".equals(operator)) {
            return OperatorUtils.and((Number)fstObject, (Number)secObject);
        }
        if ("|".equals(operator)) {
            return OperatorUtils.or((Number)fstObject, (Number)secObject);
        }
        if ("^".equals(operator)) {
            return OperatorUtils.xor((Number)fstObject, (Number)secObject);
        }
        if ("<<".equals(operator)) {
            return OperatorUtils.shiftLeft((Number)fstObject, (Number)secObject);
        }
        if (">>".equals(operator)) {
            return OperatorUtils.shiftRight((Number)fstObject, (Number)secObject);
        }
        if (">>>".equals(operator)) {
            return OperatorUtils.shiftRightWithUnsigned((Number)fstObject, (Number)secObject);
        }
        throw BinaryDOP.throwError(operator, fstObject, secObject, "this operator nonsupport.");
    }
}

