/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.hasor.dataql.runtime.operator.ops.RoundingEnum;

public class OperatorUtils {
    private static final int BOOL = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int CHAR = 4;
    private static final int INT = 5;
    private static final int LONG = 6;
    private static final int FLOAT = 7;
    private static final int DOUBLE = 8;
    private static final int BIGINT = 9;
    private static final int BIGDEC = 10;
    private static final int NONE = 0;

    public static boolean isNumber(Object object) {
        return object instanceof Number;
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isByteNumber(Object number) {
        return number instanceof Byte;
    }

    public static boolean isShortNumber(Object number) {
        return number instanceof Short;
    }

    public static boolean isIntegerNumber(Object number) {
        return number instanceof Integer;
    }

    public static boolean isCharacter(Object number) {
        return number instanceof Character;
    }

    public static boolean isLongNumber(Object number) {
        return number instanceof Long;
    }

    public static boolean isFloatNumber(Object number) {
        return number instanceof Float;
    }

    public static boolean isDoubleNumber(Object number) {
        return number instanceof Double;
    }

    public static Number fixNumberWidth(Number valNumber, String decimalWidth, String integerWidth) {
        if (OperatorUtils.isDecimal(valNumber)) {
            if (!"float".equalsIgnoreCase(decimalWidth)) {
                if ("double".equalsIgnoreCase(decimalWidth)) {
                    if (OperatorUtils.isFloatNumber(valNumber)) {
                        valNumber = valNumber.doubleValue();
                    }
                } else if ("big".equalsIgnoreCase(decimalWidth) && (OperatorUtils.isFloatNumber(valNumber) || OperatorUtils.isDoubleNumber(valNumber))) {
                    valNumber = new BigDecimal(valNumber.toString());
                }
            }
        } else if (!"byte".equalsIgnoreCase(integerWidth)) {
            if ("short".equalsIgnoreCase(integerWidth)) {
                if (OperatorUtils.isByteNumber(valNumber)) {
                    valNumber = valNumber.shortValue();
                }
            } else if ("int".equalsIgnoreCase(integerWidth)) {
                if (OperatorUtils.isByteNumber(valNumber) || OperatorUtils.isShortNumber(valNumber)) {
                    valNumber = valNumber.intValue();
                }
            } else if ("long".equalsIgnoreCase(integerWidth)) {
                if (OperatorUtils.isByteNumber(valNumber) || OperatorUtils.isShortNumber(valNumber) || OperatorUtils.isIntegerNumber(valNumber)) {
                    valNumber = valNumber.longValue();
                }
            } else if ("big".equalsIgnoreCase(integerWidth) && (OperatorUtils.isByteNumber(valNumber) || OperatorUtils.isShortNumber(valNumber) || OperatorUtils.isIntegerNumber(valNumber) || OperatorUtils.isLongNumber(valNumber))) {
                valNumber = new BigInteger(valNumber.toString());
            }
        }
        return valNumber;
    }

    private static int getNumericType(Number v1, Number v2) {
        int v2Type;
        int v1Type = OperatorUtils.getNumericType(v1);
        if (v1Type == (v2Type = OperatorUtils.getNumericType(v2))) {
            return v1Type;
        }
        if (v1Type == 0 || v2Type == 0) {
            return 0;
        }
        if (v1Type <= 6 && v2Type <= 6) {
            return v1Type == 6 || v2Type == 6 ? 6 : 5;
        }
        if (v1Type <= 8 && v2Type <= 8) {
            boolean useFloat = v1Type <= 3 || v2Type <= 3 && (v1Type == 7 || v2Type == 7);
            return useFloat ? 7 : 8;
        }
        boolean useDec = v1Type == 7 || v1Type == 8 || v2Type == 7 || v2Type == 8;
        return useDec ? 10 : 9;
    }

    public static int getNumericType(Object value) {
        if (OperatorUtils.isBoolean(value)) {
            return 1;
        }
        if (OperatorUtils.isByteNumber(value)) {
            return 2;
        }
        if (OperatorUtils.isShortNumber(value)) {
            return 3;
        }
        if (OperatorUtils.isCharacter(value)) {
            return 4;
        }
        if (OperatorUtils.isIntegerNumber(value)) {
            return 5;
        }
        if (OperatorUtils.isLongNumber(value)) {
            return 6;
        }
        if (value instanceof BigInteger) {
            return 9;
        }
        if (OperatorUtils.isFloatNumber(value)) {
            return 7;
        }
        if (OperatorUtils.isDoubleNumber(value)) {
            return 8;
        }
        if (value instanceof BigDecimal) {
            return 10;
        }
        return 0;
    }

    private static int intValue(Object value) {
        if (value == null) {
            return 0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).intValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        return Integer.parseInt(value.toString().trim());
    }

    private static long longValue(Object value) {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).longValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        return Long.parseLong(value.toString().trim());
    }

    private static BigInteger bigIntValue(Object value) {
        if (value == null) {
            return BigInteger.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigInteger.class) {
            return (BigInteger)value;
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (c.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (c == Boolean.class) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        return new BigInteger(value.toString().trim());
    }

    private static float floatValue(Object value) {
        if (value == null) {
            return 0.0f;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).floatValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        String s = value.toString().trim();
        return s.length() == 0 ? 0.0f : Float.parseFloat(s);
    }

    private static double doubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).doubleValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        String s = value.toString().trim();
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    private static BigDecimal bigDecimalValue(Object value) {
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigDecimal.class) {
            return (BigDecimal)value;
        }
        if (c == BigInteger.class) {
            return new BigDecimal((BigInteger)value);
        }
        if (c.getSuperclass() == Number.class) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (c == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        return new BigDecimal(value.toString().trim());
    }

    public static Number add(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            return OperatorUtils.decimalAdd(obj1, obj2);
        }
        return OperatorUtils.integerAdd(obj1, obj2);
    }

    public static Number subtract(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            return OperatorUtils.decimalSubtract(obj1, obj2);
        }
        return OperatorUtils.integerSubtract(obj1, obj2);
    }

    public static Number multiply(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            return OperatorUtils.decimalMultiply(obj1, obj2);
        }
        return OperatorUtils.integerMultiply(obj1, obj2);
    }

    public static Number divide(Number obj1, Number obj2, int precision, RoundingEnum roundingEnum) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            if (roundingEnum == null) {
                roundingEnum = RoundingEnum.HALF_UP;
            }
            if (precision <= 0) {
                precision = 23;
            }
            return OperatorUtils.decimalDivide(obj1, obj2, precision, roundingEnum);
        }
        return OperatorUtils.integerDivide(obj1, obj2);
    }

    public static Number aliquot(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            return OperatorUtils.decimalAliquot(obj1, obj2);
        }
        return OperatorUtils.integerDivide(obj1, obj2);
    }

    public static Number mod(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            return OperatorUtils.decimalMod(obj1, obj2);
        }
        return OperatorUtils.integerMod(obj1, obj2);
    }

    public static Number negate(Number obj) {
        if (OperatorUtils.isDecimal(obj)) {
            return OperatorUtils.decimalNegate(obj);
        }
        return OperatorUtils.integerNegate(obj);
    }

    public static boolean isDecimal(Number tester) {
        if (tester instanceof BigDecimal) {
            return true;
        }
        if (OperatorUtils.isFloatNumber(tester)) {
            return true;
        }
        return OperatorUtils.isDoubleNumber(tester);
    }

    private static Number newReal(int realType, long value) {
        switch (realType) {
            case 1: {
                return value == 0L ? 0 : 1;
            }
            case 2: {
                return (byte)value;
            }
            case 3: {
                return (short)value;
            }
            case 4: 
            case 5: {
                return (int)value;
            }
        }
        return value;
    }

    private static Number newReal(int realType, BigInteger value) {
        switch (realType) {
            case 1: {
                return BigInteger.ZERO.compareTo(value) == 0 ? 0 : 1;
            }
            case 2: {
                return value.byteValue();
            }
            case 3: {
                return value.shortValue();
            }
            case 4: 
            case 5: {
                return value.intValue();
            }
            case 6: {
                return value.longValue();
            }
        }
        return value;
    }

    private static Number newReal(int realType, double value) {
        if (realType == 7) {
            return Float.valueOf((float)value);
        }
        return value;
    }

    private static Number newReal(int realType, BigDecimal value) {
        if (realType == 7) {
            return Float.valueOf(value.floatValue());
        }
        if (realType == 8) {
            return value.doubleValue();
        }
        return value;
    }

    private static Number integerAdd(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, OperatorUtils.intValue(obj1) + OperatorUtils.intValue(obj2));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, OperatorUtils.longValue(obj1) + OperatorUtils.longValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj1).add(OperatorUtils.bigIntValue(obj2)));
    }

    private static Number integerSubtract(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, OperatorUtils.intValue(obj1) - OperatorUtils.intValue(obj2));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, OperatorUtils.longValue(obj1) - OperatorUtils.longValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj1).subtract(OperatorUtils.bigIntValue(obj2)));
    }

    private static Number integerMultiply(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, OperatorUtils.intValue(obj1) * OperatorUtils.intValue(obj2));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, OperatorUtils.longValue(obj1) * OperatorUtils.longValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj1).multiply(OperatorUtils.bigIntValue(obj2)));
    }

    private static Number integerDivide(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, OperatorUtils.intValue(obj1) / OperatorUtils.intValue(obj2));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, OperatorUtils.longValue(obj1) / OperatorUtils.longValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj1).divide(OperatorUtils.bigIntValue(obj2)));
    }

    private static Number integerMod(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, OperatorUtils.intValue(obj1) % OperatorUtils.intValue(obj2));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, OperatorUtils.longValue(obj1) % OperatorUtils.longValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj1).mod(OperatorUtils.bigIntValue(obj2)));
    }

    private static Number integerNegate(Number obj) {
        int maxType = OperatorUtils.getNumericType(obj);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return OperatorUtils.newReal(maxType, -OperatorUtils.intValue(obj));
            }
            case 6: {
                return OperatorUtils.newReal(maxType, -OperatorUtils.longValue(obj));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigIntValue(obj).negate());
    }

    private static Number decimalAdd(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, OperatorUtils.floatValue(obj1) + OperatorUtils.floatValue(obj2));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, OperatorUtils.doubleValue(obj1) + OperatorUtils.doubleValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).add(OperatorUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalSubtract(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, OperatorUtils.floatValue(obj1) - OperatorUtils.floatValue(obj2));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, OperatorUtils.doubleValue(obj1) - OperatorUtils.doubleValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).subtract(OperatorUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalMultiply(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, OperatorUtils.floatValue(obj1) * OperatorUtils.floatValue(obj2));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, OperatorUtils.doubleValue(obj1) * OperatorUtils.doubleValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).multiply(OperatorUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalDivide(Number obj1, Number obj2, int precision, RoundingEnum roundingEnum) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, OperatorUtils.floatValue(obj1) / OperatorUtils.floatValue(obj2));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, OperatorUtils.doubleValue(obj1) / OperatorUtils.doubleValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).divide(OperatorUtils.bigDecimalValue(obj2), precision, roundingEnum.getModeNum()));
    }

    private static Number decimalAliquot(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, (int)(OperatorUtils.floatValue(obj1) / OperatorUtils.floatValue(obj2)));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, (long)(OperatorUtils.doubleValue(obj1) / OperatorUtils.doubleValue(obj2)));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).divideToIntegralValue(OperatorUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalMod(Number obj1, Number obj2) {
        int maxType = OperatorUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, OperatorUtils.floatValue(obj1) % OperatorUtils.floatValue(obj2));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, OperatorUtils.doubleValue(obj1) % OperatorUtils.doubleValue(obj2));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj1).remainder(OperatorUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalNegate(Number obj) {
        int maxType = OperatorUtils.getNumericType(obj);
        switch (maxType) {
            case 7: {
                return OperatorUtils.newReal(maxType, -OperatorUtils.floatValue(obj));
            }
            case 8: {
                return OperatorUtils.newReal(maxType, -OperatorUtils.doubleValue(obj));
            }
        }
        return OperatorUtils.newReal(maxType, OperatorUtils.bigDecimalValue(obj).negate());
    }

    private static int getNumericTypeWithCompare(Number v1, Number v2) {
        int numericType = OperatorUtils.getNumericType(v1, v2);
        if (numericType == 0) {
            numericType = OperatorUtils.isDecimal(v1) || OperatorUtils.isDecimal(v2) ? 10 : 9;
        }
        return numericType;
    }

    public static boolean eq(Number obj1, Number obj2) {
        int numericType = OperatorUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) == OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) == OperatorUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return OperatorUtils.doubleValue(obj1) == OperatorUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return OperatorUtils.bigIntValue(obj1).compareTo(OperatorUtils.bigIntValue(obj2)) == 0;
        }
        if (numericType == 10) {
            return OperatorUtils.bigDecimalValue(obj1).compareTo(OperatorUtils.bigDecimalValue(obj2)) == 0;
        }
        return obj1.doubleValue() == obj2.doubleValue();
    }

    public static boolean gt(Number obj1, Number obj2) {
        int numericType = OperatorUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) > OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) > OperatorUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return OperatorUtils.doubleValue(obj1) > OperatorUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return OperatorUtils.bigIntValue(obj1).compareTo(OperatorUtils.bigIntValue(obj2)) > 0;
        }
        if (numericType == 10) {
            return OperatorUtils.bigDecimalValue(obj1).compareTo(OperatorUtils.bigDecimalValue(obj2)) > 0;
        }
        return obj1.doubleValue() > obj2.doubleValue();
    }

    public static boolean gteq(Number obj1, Number obj2) {
        int numericType = OperatorUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) >= OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) >= OperatorUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return OperatorUtils.doubleValue(obj1) >= OperatorUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return OperatorUtils.bigIntValue(obj1).compareTo(OperatorUtils.bigIntValue(obj2)) >= 0;
        }
        if (numericType == 10) {
            return OperatorUtils.bigDecimalValue(obj1).compareTo(OperatorUtils.bigDecimalValue(obj2)) >= 0;
        }
        return obj1.doubleValue() >= obj2.doubleValue();
    }

    public static boolean lt(Number obj1, Number obj2) {
        int numericType = OperatorUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) < OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) < OperatorUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return OperatorUtils.doubleValue(obj1) < OperatorUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return OperatorUtils.bigIntValue(obj1).compareTo(OperatorUtils.bigIntValue(obj2)) < 0;
        }
        if (numericType == 10) {
            return OperatorUtils.bigDecimalValue(obj1).compareTo(OperatorUtils.bigDecimalValue(obj2)) < 0;
        }
        return obj1.doubleValue() < obj2.doubleValue();
    }

    public static boolean lteq(Number obj1, Number obj2) {
        int numericType = OperatorUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) <= OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) <= OperatorUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return OperatorUtils.doubleValue(obj1) <= OperatorUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return OperatorUtils.bigIntValue(obj1).compareTo(OperatorUtils.bigIntValue(obj2)) <= 0;
        }
        if (numericType == 10) {
            return OperatorUtils.bigDecimalValue(obj1).compareTo(OperatorUtils.bigDecimalValue(obj2)) <= 0;
        }
        return obj1.doubleValue() <= obj2.doubleValue();
    }

    private static void checkDecimal(Number obj1, Number obj2) {
        if (OperatorUtils.isDecimal(obj1) || OperatorUtils.isDecimal(obj2)) {
            throw new NumberFormatException("value mast not be Decimal.");
        }
    }

    public static Number and(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) & OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) & OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).and(OperatorUtils.bigIntValue(obj2));
    }

    public static Number or(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) | OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) | OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).or(OperatorUtils.bigIntValue(obj2));
    }

    public static Number xor(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) ^ OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) ^ OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).xor(OperatorUtils.bigIntValue(obj2));
    }

    public static Number shiftLeft(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) << OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) << (int)OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).shiftLeft(OperatorUtils.intValue(obj2));
    }

    public static Number shiftRight(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) >> OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) >> (int)OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).shiftRight(OperatorUtils.intValue(obj2));
    }

    public static Number shiftRightWithUnsigned(Number obj1, Number obj2) {
        OperatorUtils.checkDecimal(obj1, obj2);
        int numericType = OperatorUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return OperatorUtils.intValue(obj1) >>> OperatorUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return OperatorUtils.longValue(obj1) >>> (int)OperatorUtils.longValue(obj2);
        }
        return OperatorUtils.bigIntValue(obj1).shiftRight(OperatorUtils.intValue(obj2));
    }
}

