/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.inset;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.hasor.dataql.HintNames;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataql.runtime.InsetProcess;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;

class PULL
implements InsetProcess {
    PULL() {
    }

    @Override
    public int getOpcode() {
        return 25;
    }

    @Override
    public void doWork(InstSequence sequence, DataHeap dataHeap, DataStack dataStack, EnvStack envStack, InsetProcessContext context) throws InstructRuntimeException {
        int point = 0;
        point = sequence.currentInst().getArrays().length > 0 ? sequence.currentInst().getInt(0) : ((Integer)dataStack.pop()).intValue();
        Object data = dataStack.pop();
        if (data == null) {
            dataStack.push(null);
            return;
        }
        if (data instanceof ListModel) {
            data = ((ListModel)data).asOri();
        } else if (data.getClass().isArray()) {
            data = Arrays.asList((Object[])data);
        }
        String indexOverflow = context.getOrMap(HintNames.INDEX_OVERFLOW.name(), val -> val == null ? "near" : val.toString());
        if (!(data instanceof Collection)) {
            throw new InstructRuntimeException("output data error, target type must be Collection.");
        }
        int size = ((Collection)data).size();
        if (point < 0) {
            if ((point = size + point) <= 0) {
                if ("throw".equalsIgnoreCase(indexOverflow)) {
                    throw new ArrayIndexOutOfBoundsException(point + " out of " + size);
                }
                if ("null".equalsIgnoreCase(indexOverflow)) {
                    dataStack.push(null);
                    return;
                }
                point = 0;
            }
        } else if (point >= size) {
            if ("throw".equalsIgnoreCase(indexOverflow)) {
                throw new ArrayIndexOutOfBoundsException(point + " out of " + size);
            }
            if ("null".equalsIgnoreCase(indexOverflow)) {
                dataStack.push(null);
                return;
            }
            point = size - 1;
        }
        Object pullData = null;
        pullData = data instanceof List ? (Object)((List)data).get(point) : ((Collection)data).toArray()[point];
        dataStack.push(pullData);
    }
}

