/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.hasor.dataql.CustomizeScope;
import net.hasor.dataql.Finder;
import net.hasor.dataql.HintNames;
import net.hasor.dataql.Query;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.ValueModel;
import net.hasor.dataql.runtime.CompilerVarQuery;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.QueryResultImpl;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataql.runtime.inset.OpcodesPool;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;
import net.hasor.dataql.runtime.mem.ExitType;
import net.hasor.dataql.runtime.mem.RefLambdaCallException;

class QueryImpl
extends HintsSet
implements CompilerVarQuery {
    private QIL qil;
    private Finder finder;
    private Map<String, Object> compilerVar;

    QueryImpl(QIL qil, Finder finder) {
        this.qil = qil;
        this.finder = finder;
        this.compilerVar = new HashMap<String, Object>();
    }

    @Override
    public Query clone() {
        QueryImpl query = new QueryImpl(this.qil, this.finder);
        query.compilerVar = new HashMap<String, Object>(this.compilerVar);
        return query;
    }

    @Override
    public void setCompilerVar(String compilerVar, Object object) {
        this.compilerVar.put(compilerVar, object);
    }

    private static long executionTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public QueryResultImpl execute(CustomizeScope customize) throws InstructRuntimeException {
        long startTime = System.currentTimeMillis();
        InstSequence instSequence = new InstSequence(0, this.qil);
        if (customize == null) {
            customize = symbol -> Collections.emptyMap();
        }
        InsetProcessContext processContext = new InsetProcessContext(customize, this.finder);
        processContext.setHints(this);
        for (HintNames optionKey : HintNames.values()) {
            processContext.putIfAbsent(optionKey.name(), optionKey.getDefaultVal());
        }
        DataStack dataStack = new DataStack();
        DataHeap dataHeap = new DataHeap();
        EnvStack envStack = new EnvStack();
        this.qil.getCompilerVar().forEach((? super K varName, ? super V varLocalIdx) -> {
            Object varVal = this.compilerVar.get(varName);
            dataHeap.saveData((int)varLocalIdx, varVal);
        });
        try {
            OpcodesPool opcodesPool = OpcodesPool.defaultOpcodesPool();
            while (instSequence.hasNext()) {
                opcodesPool.doWork(instSequence, dataHeap, dataStack, envStack, processContext);
                instSequence.doNext(1);
            }
        }
        catch (RefLambdaCallException e) {
            dataStack.setExitType(ExitType.Throw);
            dataStack.setResultCode(e.getResultCode());
            dataStack.setResult(e.getResult());
        }
        ExitType exitType = dataStack.getExitType();
        long executionTime = QueryImpl.executionTime(startTime);
        int resultCode = dataStack.getResultCode();
        DataModel result = dataStack.getResult();
        if (ExitType.Exit == exitType) {
            return new QueryResultImpl(true, resultCode, result, executionTime);
        }
        if (ExitType.Throw == exitType) {
            String message = "udf or lambda failed.";
            if (result instanceof ValueModel) {
                message = resultCode + " : " + ((ValueModel)result).asString();
            }
            throw new ThrowRuntimeException(message, resultCode, executionTime, result);
        }
        if (ExitType.Return == exitType) {
            return new QueryResultImpl(false, resultCode, result, executionTime);
        }
        throw new InstructRuntimeException((Object)((Object)exitType) + " ExitType undefined.");
    }
}

