/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.runtime.InstFilter;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.utils.StringUtils;

public class InstSequence {
    private final int address;
    private final QIL queueSet;
    private final int startPosition;
    private final int endPosition;
    private final AtomicInteger sequenceIndex;
    private boolean jumpMark = false;

    InstSequence(int address, QIL queueSet) {
        this.address = address;
        this.queueSet = queueSet;
        this.startPosition = 0;
        this.endPosition = this.queueSet.iqlSize(address);
        this.sequenceIndex = new AtomicInteger(this.startPosition);
    }

    InstSequence(int address, QIL queueSet, int startPosition, int endPosition) {
        this.address = address;
        this.queueSet = queueSet;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.sequenceIndex = new AtomicInteger(this.startPosition);
    }

    public int getAddress() {
        return this.address;
    }

    public InstSequence clone() {
        return new InstSequence(this.address, this.queueSet);
    }

    public Instruction currentInst() {
        if (this.queueSet == null) {
            return null;
        }
        return this.queueSet.instOf(this.address, this.sequenceIndex.get());
    }

    public InstSequence methodSet(int address) {
        if (address < 0 || address > this.queueSet.iqlPoolSize()) {
            return null;
        }
        return new InstSequence(address, this.queueSet);
    }

    public InstSequence findSubSequence(InstFilter instFilter) {
        Instruction[] curInstSet = this.queueSet.iqlArrays(this.address);
        int startIndex = this.sequenceIndex.get();
        int endIndex = curInstSet.length - 1;
        for (int i = startIndex; i < endIndex; ++i) {
            if (!instFilter.isExit(curInstSet[i])) continue;
            endIndex = i;
            break;
        }
        return new InstSequence(this.address, this.queueSet, startIndex + 1, endIndex);
    }

    public boolean hasNext() {
        return this.sequenceIndex.get() < this.endPosition;
    }

    public boolean doNext(int nextSkip) throws InstructRuntimeException {
        if (this.jumpMark) {
            this.jumpMark = false;
            return true;
        }
        if (nextSkip < 0) {
            throw new InstructRuntimeException("nextSkip must be > 0");
        }
        int newPosition = this.sequenceIndex.get() + nextSkip;
        if (newPosition > this.endPosition) {
            return false;
        }
        if (nextSkip > 0) {
            this.sequenceIndex.addAndGet(nextSkip);
        } else {
            this.sequenceIndex.incrementAndGet();
        }
        return true;
    }

    public int exitPosition() {
        return this.endPosition;
    }

    public void jumpTo(int position) {
        this.sequenceIndex.set(position);
        this.jumpMark = true;
    }

    public void reset() {
        this.sequenceIndex.set(this.startPosition);
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("[");
        strBuffer.append(this.address);
        strBuffer.append("]\n");
        Instruction[] instList = this.queueSet.iqlArrays(this.address);
        int length = String.valueOf(instList.length).length();
        for (int i = this.startPosition; i < this.endPosition; ++i) {
            if (i == this.sequenceIndex.get()) {
                strBuffer.append("> #");
            } else {
                strBuffer.append("  #");
            }
            strBuffer.append(StringUtils.leftPad((String)String.valueOf(i), (int)length, (char)'0'));
            strBuffer.append("  ");
            strBuffer.append(instList[i].toString());
            strBuffer.append("\n");
        }
        strBuffer.append("\n");
        return strBuffer.toString();
    }
}

