/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.Map;
import net.hasor.dataql.CustomizeScope;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Query;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.operator.OperatorManager;
import net.hasor.dataql.runtime.operator.OperatorProcess;

public class InsetProcessContext
extends HintsSet
implements CustomizeScope {
    private static final OperatorManager opeManager = OperatorManager.defaultManager();
    private final CustomizeScope customizeScope;
    private final Finder finder;

    InsetProcessContext(CustomizeScope customizeScope, Finder finder) {
        if (finder == null) {
            finder = new Finder(){};
        }
        this.customizeScope = customizeScope;
        this.finder = finder;
    }

    public Finder getFinder() {
        return this.finder;
    }

    public OperatorProcess findUnaryOperator(String unarySymbol, Class<?> fstType) {
        return opeManager.findUnaryProcess(unarySymbol, fstType);
    }

    public OperatorProcess findDyadicOperator(String dyadicSymbol, Class<?> fstType, Class<?> secType) {
        return opeManager.findDyadicProcess(dyadicSymbol, fstType, secType);
    }

    @Override
    public Map<String, ?> findCustomizeEnvironment(String symbol) {
        if (this.customizeScope == null) {
            return null;
        }
        return this.customizeScope.findCustomizeEnvironment(symbol);
    }

    public Object loadObject(String udfType) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> c = classLoader.loadClass(Query.class.getName());
        if (c != Query.class) {
            classLoader = Query.class.getClassLoader();
        }
        Class<?> loadClass = classLoader.loadClass(udfType);
        return this.finder.findBean(loadClass);
    }

    public FragmentProcess findFragmentProcess(String fragmentType) {
        return this.finder.findFragmentProcess(fragmentType);
    }
}

