/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.extend.jsr223;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.QueryModel;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.extend.jsr223.DataQLCompiledScript;
import net.hasor.dataql.extend.jsr223.DataQLScriptEngineFactory;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.QueryHelper;

public class DataQLScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable,
Hints {
    private HintsSet optionSet = new HintsSet();
    private DataQLScriptEngineFactory engineFactory;
    private Finder finder = Finder.DEFAULT;

    DataQLScriptEngine(DataQLScriptEngineFactory engineFactory) {
        this.engineFactory = engineFactory;
    }

    @Override
    public String[] getHints() {
        return this.optionSet.getHints();
    }

    @Override
    public Object getHint(String optionKey) {
        return this.optionSet.getHint(optionKey);
    }

    @Override
    public void removeHint(String optionKey) {
        this.optionSet.removeHint(optionKey);
    }

    @Override
    public void setHint(String hintName, String value) {
        this.optionSet.setHint(hintName, value);
    }

    @Override
    public void setHint(String hintName, Number value) {
        this.optionSet.setHint(hintName, value);
    }

    @Override
    public void setHint(String hintName, boolean value) {
        this.optionSet.setHint(hintName, value);
    }

    public Finder getFinder() {
        return this.finder;
    }

    public void setFinder(Finder finder) {
        this.finder = Objects.requireNonNull(finder, "finder is null.");
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.engineFactory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public CompiledScript compile(Reader queryString) throws ScriptException {
        try {
            Bindings global = this.getBindings(200);
            if (global == null) {
                global = this.createBindings();
                this.setBindings(this.createBindings(), 200);
            }
            QueryModel queryModel = QueryHelper.queryParser(queryString);
            QIL compilerQIL = QueryHelper.queryCompiler(queryModel, global.keySet(), this.getFinder());
            return new DataQLCompiledScript(compilerQIL, this);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public CompiledScript compile(String queryString) throws ScriptException {
        return this.compile(new StringReader(queryString));
    }

    @Override
    public Object eval(Reader queryString, ScriptContext context) throws ScriptException {
        this.setContext(context);
        return this.compile(queryString).eval();
    }

    @Override
    public Object eval(String queryString, ScriptContext context) throws ScriptException {
        this.setContext(context);
        return this.compile(queryString).eval();
    }
}

