/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.domain.UdfModel;
import net.hasor.dataql.domain.ValueModel;

public class ListModel
implements DataModel {
    private List<DataModel> dataModel = new ArrayList<DataModel>();

    public ListModel() {
    }

    public ListModel(Collection<?> dataItem) {
        if (dataItem != null) {
            for (Object object : dataItem) {
                this.add(DomainHelper.convertTo(object));
            }
        }
    }

    public void add(Object object) {
        this.dataModel.add(DomainHelper.convertTo(object));
    }

    public int size() {
        return this.dataModel.size();
    }

    @Override
    public List<DataModel> asOri() {
        return this.dataModel;
    }

    @Override
    public List<Object> unwrap() {
        ArrayList<Object> unwrap = new ArrayList<Object>(this.dataModel.size());
        this.dataModel.forEach(dataModel -> unwrap.add(dataModel.unwrap()));
        return unwrap;
    }

    @Override
    public boolean isList() {
        return true;
    }

    public boolean isValue(int index) {
        return this.dataModel.get(index) instanceof ValueModel;
    }

    public boolean isList(int index) {
        return this.dataModel.get(index) instanceof ListModel;
    }

    public boolean isObject(int index) {
        return this.dataModel.get(index) instanceof ObjectModel;
    }

    public boolean isUdf(int index) {
        return this.dataModel.get(index) instanceof UdfModel;
    }

    public DataModel get(int index) {
        return this.dataModel.get(index);
    }

    public ValueModel getValue(int index) {
        DataModel dataItem = this.dataModel.get(index);
        if (dataItem instanceof ValueModel) {
            return (ValueModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ValueModel.");
    }

    public ListModel getList(int index) {
        DataModel dataItem = this.dataModel.get(index);
        if (dataItem instanceof ListModel) {
            return (ListModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ListModel.");
    }

    public ObjectModel getObject(int index) {
        DataModel dataItem = this.dataModel.get(index);
        if (dataItem instanceof ObjectModel) {
            return (ObjectModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ObjectModel.");
    }

    public UdfModel getUdf(int index) {
        DataModel dataItem = this.dataModel.get(index);
        if (dataItem instanceof UdfModel) {
            return (UdfModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to UdfModel.");
    }
}

