/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil.cc;

import java.util.Stack;
import net.hasor.dataql.compiler.ast.Expression;
import net.hasor.dataql.compiler.ast.expr.DyadicExpression;
import net.hasor.dataql.compiler.qil.CompilerContext;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.compiler.qil.InstQueue;

public class DyadicExprInstCompiler
implements InstCompiler<DyadicExpression> {
    private static final String[][] ComparePriorityKeys = new String[][]{{"*", "/", "\\", "%"}, {"+", "-"}, {"&", "|", "^", "<<", ">>", ">>>"}, {">", ">=", "!=", "==", "<=", "<"}, {"&&", "||"}};

    @Override
    public void doCompiler(DyadicExpression astInst, InstQueue queue, CompilerContext compilerContext) {
        this.doCompiler(astInst, queue, compilerContext, new Stack<String>());
    }

    protected void doCompiler(DyadicExpression astInst, InstQueue queue, CompilerContext compilerContext, Stack<String> last) {
        Expression fstExpression = astInst.getFstExpression();
        String dyadicSymbol = astInst.getDyadicSymbol();
        Expression secExpression = astInst.getSecExpression();
        compilerContext.findInstCompilerByInst(fstExpression).doCompiler(queue);
        int selfPriority = DyadicExprInstCompiler.priorityAt(dyadicSymbol);
        if (!last.isEmpty()) {
            int lastPriority;
            while (!last.isEmpty() && selfPriority >= (lastPriority = DyadicExprInstCompiler.priorityAt(last.peek()))) {
                queue.inst((byte)42, last.pop());
            }
        }
        last.push(dyadicSymbol);
        if (secExpression instanceof DyadicExpression) {
            this.doCompiler((DyadicExpression)secExpression, queue, compilerContext, last);
        } else {
            compilerContext.findInstCompilerByInst(secExpression).doCompiler(queue);
            while (!last.isEmpty()) {
                queue.inst((byte)42, last.pop());
            }
        }
    }

    private static int priorityAt(String dyadicSymbol) {
        for (int symbolArraysIndex = 0; symbolArraysIndex < ComparePriorityKeys.length; ++symbolArraysIndex) {
            String[] symbolArrays;
            for (String symbol : symbolArrays = ComparePriorityKeys[symbolArraysIndex]) {
                if (!symbol.equalsIgnoreCase(dyadicSymbol)) continue;
                return symbolArraysIndex;
            }
        }
        throw new UnsupportedOperationException("symbol " + dyadicSymbol + " undefined priority.");
    }
}

