/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.dataql.compiler.CompilerException;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.dataql.compiler.qil.InstructionInfo;
import net.hasor.dataql.compiler.qil.Label;
import net.hasor.utils.StringUtils;

public class InstQueue {
    private final int name;
    private final AtomicInteger labelIndex;
    private final AtomicInteger methodName;
    private final List<LinkedList<InstructionInfo>> instSet;

    public InstQueue() {
        this.name = 0;
        this.labelIndex = new AtomicInteger(0);
        this.methodName = new AtomicInteger(0);
        this.instSet = new ArrayList<LinkedList<InstructionInfo>>();
        this.instSet.add(new LinkedList());
    }

    private InstQueue(int methodName, InstQueue dataPool) {
        this.name = methodName;
        this.labelIndex = dataPool.labelIndex;
        this.methodName = dataPool.methodName;
        this.instSet = dataPool.instSet;
    }

    public int getName() {
        return this.name;
    }

    public int inst(byte inst, Object ... param) {
        LinkedList<InstructionInfo> instList = this.instSet.get(this.name);
        InstructionInfo instObj = new InstructionInfo(inst, param);
        instList.addLast(instObj);
        int index = instList.size() - 1;
        if (inst == 72) {
            for (Object obj : param) {
                if (!(obj instanceof Label)) continue;
                ((Label)obj).updateIndex(index);
            }
        }
        return index;
    }

    public InstructionInfo lastInst() {
        LinkedList<InstructionInfo> instList = this.instSet.get(this.name);
        return instList.isEmpty() ? null : instList.getLast();
    }

    public InstQueue newMethodInst() {
        LinkedList instList = new LinkedList();
        this.instSet.add(instList);
        int name = -1;
        for (int i = 0; i < this.instSet.size(); ++i) {
            if (this.instSet.get(i) != instList) continue;
            name = i;
            break;
        }
        return new InstQueue(name, this);
    }

    public Label labelDef() {
        return new Label(this.labelIndex.incrementAndGet());
    }

    public Instruction[][] buildArrays() throws CompilerException {
        for (LinkedList<InstructionInfo> instList : this.instSet) {
            for (InstructionInfo inst : instList) {
                if (inst.replaceLabel()) continue;
                throw new CompilerException("compiler error -> inst(" + inst.getInstCode() + ") encounter not insert Label.");
            }
        }
        Instruction[][] buildDatas = new InstructionInfo[this.instSet.size()][];
        for (int i = 0; i < this.instSet.size(); ++i) {
            LinkedList<InstructionInfo> instList = this.instSet.get(i);
            InstructionInfo[] instSet = instList.toArray(new InstructionInfo[0]);
            buildDatas[i] = instSet;
        }
        return buildDatas;
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < this.instSet.size(); ++i) {
            LinkedList<InstructionInfo> instList = this.instSet.get(i);
            InstQueue.printInstList(i, instList, strBuffer);
        }
        return strBuffer.toString();
    }

    private static void printInstList(int name, LinkedList<InstructionInfo> instList, StringBuilder strBuffer) {
        strBuffer.append("[");
        strBuffer.append(name);
        strBuffer.append("]\n");
        int length = String.valueOf(instList.size()).length();
        for (int i = 0; i < instList.size(); ++i) {
            InstructionInfo inst = instList.get(i);
            strBuffer.append("  #");
            strBuffer.append(StringUtils.leftPad((String)String.valueOf(i), (int)length, (char)'0'));
            strBuffer.append("  ");
            strBuffer.append(inst.toString());
            strBuffer.append("\n");
        }
        strBuffer.append("\n");
    }
}

