/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.hasor.dataql.Finder;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.expr.AtomExpression;
import net.hasor.dataql.compiler.ast.expr.DyadicExpression;
import net.hasor.dataql.compiler.ast.expr.PrivilegeExpression;
import net.hasor.dataql.compiler.ast.expr.TernaryExpression;
import net.hasor.dataql.compiler.ast.expr.UnaryExpression;
import net.hasor.dataql.compiler.ast.fmt.ListFormat;
import net.hasor.dataql.compiler.ast.fmt.ObjectFormat;
import net.hasor.dataql.compiler.ast.inst.ExitInst;
import net.hasor.dataql.compiler.ast.inst.HintInst;
import net.hasor.dataql.compiler.ast.inst.ImportInst;
import net.hasor.dataql.compiler.ast.inst.InstSet;
import net.hasor.dataql.compiler.ast.inst.ReturnInst;
import net.hasor.dataql.compiler.ast.inst.RootBlockSet;
import net.hasor.dataql.compiler.ast.inst.RunInst;
import net.hasor.dataql.compiler.ast.inst.SwitchInst;
import net.hasor.dataql.compiler.ast.inst.ThrowInst;
import net.hasor.dataql.compiler.ast.inst.VarInst;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;
import net.hasor.dataql.compiler.ast.value.FragmentVariable;
import net.hasor.dataql.compiler.ast.value.FunCallRouteVariable;
import net.hasor.dataql.compiler.ast.value.LambdaVariable;
import net.hasor.dataql.compiler.ast.value.ListVariable;
import net.hasor.dataql.compiler.ast.value.NameRouteVariable;
import net.hasor.dataql.compiler.ast.value.ObjectVariable;
import net.hasor.dataql.compiler.ast.value.PrimitiveVariable;
import net.hasor.dataql.compiler.ast.value.SubscriptRouteVariable;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.compiler.qil.cc.AtomExprInstCompiler;
import net.hasor.dataql.compiler.qil.cc.DyadicExprInstCompiler;
import net.hasor.dataql.compiler.qil.cc.EnterRouteVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ExitInstCompiler;
import net.hasor.dataql.compiler.qil.cc.FragmentVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.FunCallRouteVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.HintInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ImportInstCompiler;
import net.hasor.dataql.compiler.qil.cc.InstSetInstCompiler;
import net.hasor.dataql.compiler.qil.cc.LambdaVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ListFormatInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ListVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.NameRouteVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ObjectFormatInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ObjectVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.PrimitiveVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.PrivilegeExprInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ReturnInstCompiler;
import net.hasor.dataql.compiler.qil.cc.RootBlockSetInstCompiler;
import net.hasor.dataql.compiler.qil.cc.RunInstCompiler;
import net.hasor.dataql.compiler.qil.cc.SubscriptRouteVariableInstCompiler;
import net.hasor.dataql.compiler.qil.cc.SwitchInstCompiler;
import net.hasor.dataql.compiler.qil.cc.TernaryExprInstCompiler;
import net.hasor.dataql.compiler.qil.cc.ThrowInstCompiler;
import net.hasor.dataql.compiler.qil.cc.UnaryExprInstCompiler;
import net.hasor.dataql.compiler.qil.cc.VarInstCompiler;

public class CompilerEnvironment
implements Finder {
    private Finder finder;
    private static Map<Class<?>, InstCompiler<?>> typeMappingToInstCompiler = new HashMap<Class<?>, InstCompiler<?>>(){
        {
            this.put(RootBlockSet.class, new RootBlockSetInstCompiler());
            this.put(InstSet.class, new InstSetInstCompiler());
            this.put(HintInst.class, new HintInstCompiler());
            this.put(ImportInst.class, new ImportInstCompiler());
            this.put(ExitInst.class, new ExitInstCompiler());
            this.put(ReturnInst.class, new ReturnInstCompiler());
            this.put(ThrowInst.class, new ThrowInstCompiler());
            this.put(VarInst.class, new VarInstCompiler());
            this.put(RunInst.class, new RunInstCompiler());
            this.put(SwitchInst.class, new SwitchInstCompiler());
            this.put(AtomExpression.class, new AtomExprInstCompiler());
            this.put(UnaryExpression.class, new UnaryExprInstCompiler());
            this.put(DyadicExpression.class, new DyadicExprInstCompiler());
            this.put(TernaryExpression.class, new TernaryExprInstCompiler());
            this.put(PrivilegeExpression.class, new PrivilegeExprInstCompiler());
            this.put(PrimitiveVariable.class, new PrimitiveVariableInstCompiler());
            this.put(LambdaVariable.class, new LambdaVariableInstCompiler());
            this.put(ListVariable.class, new ListVariableInstCompiler());
            this.put(ObjectVariable.class, new ObjectVariableInstCompiler());
            this.put(ObjectFormat.class, new ObjectFormatInstCompiler());
            this.put(ListFormat.class, new ListFormatInstCompiler());
            this.put(FragmentVariable.class, new FragmentVariableInstCompiler());
            this.put(SubscriptRouteVariable.class, new SubscriptRouteVariableInstCompiler());
            this.put(NameRouteVariable.class, new NameRouteVariableInstCompiler());
            this.put(EnterRouteVariable.class, new EnterRouteVariableInstCompiler());
            this.put(FunCallRouteVariable.class, new FunCallRouteVariableInstCompiler());
        }
    };

    public CompilerEnvironment(Finder finder) {
        this.finder = Objects.requireNonNull(finder, "finder is null.");
    }

    @Override
    public InputStream findResource(String resourceName) throws IOException {
        return this.finder.findResource(resourceName);
    }

    public <T extends Inst> InstCompiler<T> findInstCompilerByType(Class<T> instType) {
        return Objects.requireNonNull(typeMappingToInstCompiler.get(instType), "not found " + instType.getName() + " InstCompiler.");
    }
}

