/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Stack;
import net.hasor.dataql.compiler.ParseException;
import net.hasor.dataql.compiler.ast.Expression;
import net.hasor.dataql.compiler.ast.RouteVariable;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.expr.AtomExpression;
import net.hasor.dataql.compiler.ast.expr.DyadicExpression;
import net.hasor.dataql.compiler.ast.expr.PrivilegeExpression;
import net.hasor.dataql.compiler.ast.expr.TernaryExpression;
import net.hasor.dataql.compiler.ast.expr.UnaryExpression;
import net.hasor.dataql.compiler.ast.fmt.ListFormat;
import net.hasor.dataql.compiler.ast.fmt.ObjectFormat;
import net.hasor.dataql.compiler.ast.inst.ExitInst;
import net.hasor.dataql.compiler.ast.inst.HintInst;
import net.hasor.dataql.compiler.ast.inst.ImportInst;
import net.hasor.dataql.compiler.ast.inst.InstSet;
import net.hasor.dataql.compiler.ast.inst.ReturnInst;
import net.hasor.dataql.compiler.ast.inst.RootBlockSet;
import net.hasor.dataql.compiler.ast.inst.RunInst;
import net.hasor.dataql.compiler.ast.inst.SwitchInst;
import net.hasor.dataql.compiler.ast.inst.ThrowInst;
import net.hasor.dataql.compiler.ast.inst.VarInst;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;
import net.hasor.dataql.compiler.ast.value.FragmentVariable;
import net.hasor.dataql.compiler.ast.value.FunCallRouteVariable;
import net.hasor.dataql.compiler.ast.value.LambdaVariable;
import net.hasor.dataql.compiler.ast.value.ListVariable;
import net.hasor.dataql.compiler.ast.value.NameRouteVariable;
import net.hasor.dataql.compiler.ast.value.ObjectVariable;
import net.hasor.dataql.compiler.ast.value.PrimitiveVariable;
import net.hasor.dataql.compiler.ast.value.SubscriptRouteVariable;
import net.hasor.dataql.compiler.parser.DataQLParser;
import net.hasor.dataql.compiler.parser.DataQLParserVisitor;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DefaultDataQLVisitor<T>
extends AbstractParseTreeVisitor<T>
implements DataQLParserVisitor<T> {
    private Stack<Object> instStack = new Stack();

    @Override
    public T visitRootInstSet(DataQLParser.RootInstSetContext ctx) {
        this.instStack.push(new RootBlockSet());
        List<DataQLParser.HintInstContext> optionList = ctx.hintInst();
        List<DataQLParser.ImportInstContext> importList = ctx.importInst();
        List<DataQLParser.BlockSetContext> blockSetList = ctx.blockSet();
        if (optionList != null) {
            for (DataQLParser.HintInstContext hintInstContext : optionList) {
                hintInstContext.accept(this);
            }
        }
        if (importList != null) {
            for (DataQLParser.ImportInstContext importInstContext : importList) {
                importInstContext.accept(this);
            }
        }
        if (blockSetList != null) {
            for (DataQLParser.BlockSetContext blockSetContext : blockSetList) {
                blockSetContext.accept(this);
                InstSet instSet = (InstSet)this.instStack.pop();
                RootBlockSet rootBlockSet = (RootBlockSet)this.instStack.peek();
                rootBlockSet.addInstSet(instSet);
            }
        }
        return (T)this.instStack.pop();
    }

    @Override
    public T visitHintInst(DataQLParser.HintInstContext ctx) {
        this.instStack.push(this.fixIdentifier(ctx.IDENTIFIER()));
        this.visitChildren((RuleNode)ctx);
        PrimitiveVariable optValue = (PrimitiveVariable)this.instStack.pop();
        String optKey = (String)this.instStack.pop();
        HintInst hintInst = new HintInst(optKey, optValue);
        ((InstSet)this.instStack.peek()).addOptionInst(hintInst);
        return null;
    }

    @Override
    public T visitImportInst(DataQLParser.ImportInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        ImportInst.ImportType importType = ImportInst.ImportType.ClassType;
        String importResource = this.fixString(ctx.STRING());
        String asName = this.fixIdentifier(ctx.IDENTIFIER());
        TerminalNode rouNode = ctx.ROU();
        if (rouNode != null) {
            if ("@".equals(rouNode.getText())) {
                importType = ImportInst.ImportType.Resource;
            } else {
                throw this.newParseException(rouNode.getSymbol(), "parser failed -> visitImportInst.");
            }
        }
        ImportInst importInst = new ImportInst(importType, importResource, asName);
        ((RootBlockSet)this.instStack.peek()).addImportInst(importInst);
        return null;
    }

    @Override
    public T visitMultipleInst(DataQLParser.MultipleInstContext ctx) {
        this.instStack.push(new InstSet());
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public T visitSingleInst(DataQLParser.SingleInstContext ctx) {
        this.instStack.push(new InstSet());
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public T visitVarInst(DataQLParser.VarInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        VarInst varInst = new VarInst(this.fixIdentifier(ctx.IDENTIFIER()), (Variable)this.instStack.pop());
        ((InstSet)this.instStack.peek()).addInst(varInst);
        return null;
    }

    @Override
    public T visitRunInst(DataQLParser.RunInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        RunInst varInst = new RunInst((Variable)this.instStack.pop());
        ((InstSet)this.instStack.peek()).addInst(varInst);
        return null;
    }

    @Override
    public T visitAnyObject(DataQLParser.AnyObjectContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitIfInst(DataQLParser.IfInstContext ctx) {
        List<DataQLParser.ExprContext> exprList = ctx.expr();
        List<DataQLParser.BlockSetContext> ifBlocks = ctx.blockSet();
        SwitchInst switchInst = new SwitchInst();
        for (int i = 0; i < ifBlocks.size(); ++i) {
            InstSet instSet;
            if (i < exprList.size()) {
                exprList.get(i).accept(this);
                ifBlocks.get(i).accept(this);
                instSet = (InstSet)this.instStack.pop();
                Variable expr = (Variable)this.instStack.pop();
                if (expr instanceof Expression) {
                    switchInst.addElseif((Expression)expr, instSet);
                    continue;
                }
                switchInst.addElseif(new AtomExpression(expr), instSet);
                continue;
            }
            ifBlocks.get(i).accept(this);
            instSet = (InstSet)this.instStack.pop();
            switchInst.setElseBlockSet(instSet);
            break;
        }
        ((InstSet)this.instStack.peek()).addInst(switchInst);
        return null;
    }

    @Override
    public T visitBreakInst(DataQLParser.BreakInstContext ctx) {
        TerminalNode breakCodeNode = ctx.INTEGER_NUM();
        int breakCode = 0;
        if (breakCodeNode != null) {
            breakCode = Integer.parseInt(breakCodeNode.getText());
        }
        DataQLParser.AnyObjectContext anyObject = ctx.anyObject();
        anyObject.accept(this);
        Variable variable = (Variable)this.instStack.pop();
        if (ctx.EXIT() != null) {
            ((InstSet)this.instStack.peek()).addInst(new ExitInst(breakCode, variable));
            return null;
        }
        if (ctx.THROW() != null) {
            ((InstSet)this.instStack.peek()).addInst(new ThrowInst(breakCode, variable));
            return null;
        }
        if (ctx.RETURN() != null) {
            ((InstSet)this.instStack.peek()).addInst(new ReturnInst(breakCode, variable));
            return null;
        }
        throw this.newParseException(ctx.start, "missing exit statement.");
    }

    @Override
    public T visitLambdaDef(DataQLParser.LambdaDefContext ctx) {
        LambdaVariable lambdaVariable = new LambdaVariable();
        List<TerminalNode> identifierList = ctx.IDENTIFIER();
        if (identifierList != null) {
            for (TerminalNode terminalNode : identifierList) {
                lambdaVariable.addParam(this.fixIdentifier(terminalNode));
            }
        }
        this.instStack.push(lambdaVariable);
        ctx.blockSet().accept(this);
        InstSet instSet = (InstSet)this.instStack.pop();
        ((LambdaVariable)this.instStack.peek()).addInstSet(instSet);
        return null;
    }

    @Override
    public T visitObjectValue(DataQLParser.ObjectValueContext ctx) {
        ObjectVariable objectVariable = new ObjectVariable();
        this.instStack.push(objectVariable);
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitObjectKeyValue(DataQLParser.ObjectKeyValueContext ctx) {
        ObjectVariable objectVariable = (ObjectVariable)this.instStack.peek();
        String fieldKey = this.fixString(ctx.STRING());
        DataQLParser.AnyObjectContext polymericObject = ctx.anyObject();
        if (polymericObject != null) {
            polymericObject.accept(this);
            Variable valueExp = (Variable)this.instStack.pop();
            objectVariable.addField(fieldKey, valueExp);
        } else {
            EnterRouteVariable enterRoute = new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, null);
            NameRouteVariable nameRoute = new NameRouteVariable(enterRoute, fieldKey);
            objectVariable.addField(fieldKey, nameRoute);
        }
        return null;
    }

    @Override
    public T visitListValue(DataQLParser.ListValueContext ctx) {
        ListVariable listVariable = new ListVariable();
        List<DataQLParser.AnyObjectContext> polymericList = ctx.anyObject();
        if (polymericList != null) {
            for (DataQLParser.AnyObjectContext polymeric : polymericList) {
                polymeric.accept(this);
                Variable variable = (Variable)this.instStack.pop();
                listVariable.addItem(variable);
            }
        }
        this.instStack.push(listVariable);
        return null;
    }

    @Override
    public T visitStringValue(DataQLParser.StringValueContext ctx) {
        String text = this.fixString(ctx.STRING());
        this.instStack.push(new PrimitiveVariable(text, PrimitiveVariable.ValueType.String));
        return null;
    }

    @Override
    public T visitNullValue(DataQLParser.NullValueContext ctx) {
        this.instStack.push(new PrimitiveVariable(null, PrimitiveVariable.ValueType.Null));
        return null;
    }

    @Override
    public T visitBooleanValue(DataQLParser.BooleanValueContext ctx) {
        boolean boolValue = ctx.TRUE() != null;
        this.instStack.push(new PrimitiveVariable(boolValue, PrimitiveVariable.ValueType.Boolean));
        return null;
    }

    @Override
    public T visitNumberValue(DataQLParser.NumberValueContext ctx) {
        TerminalNode bitNode = ctx.BIT_NUM();
        TerminalNode octNode = ctx.OCT_NUM();
        TerminalNode intNode = ctx.INTEGER_NUM();
        TerminalNode hexNode = ctx.HEX_NUM();
        TerminalNode decimalNode = ctx.DECIMAL_NUM();
        int radix = 10;
        String radixNumber = null;
        if (bitNode != null) {
            radix = 2;
            radixNumber = bitNode.getText();
            String string = radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
        }
        if (octNode != null) {
            radix = 8;
            radixNumber = octNode.getText();
            String string = radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
        }
        if (intNode != null) {
            radix = 10;
            radixNumber = intNode.getText();
        }
        if (hexNode != null) {
            radix = 16;
            radixNumber = hexNode.getText();
            String string = radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
        }
        if (radixNumber != null) {
            BigInteger bigInt = new BigInteger(radixNumber, radix);
            int bitLength = bigInt.bitLength();
            if (bitLength < 8) {
                this.instStack.push(new PrimitiveVariable(bigInt.byteValue(), PrimitiveVariable.ValueType.Number, radix));
                return null;
            }
            if (bitLength < 16) {
                this.instStack.push(new PrimitiveVariable(bigInt.shortValue(), PrimitiveVariable.ValueType.Number, radix));
                return null;
            }
            if (bitLength < 32) {
                this.instStack.push(new PrimitiveVariable(bigInt.intValue(), PrimitiveVariable.ValueType.Number, radix));
                return null;
            }
            if (bitLength < 64) {
                this.instStack.push(new PrimitiveVariable(bigInt.longValue(), PrimitiveVariable.ValueType.Number, radix));
                return null;
            }
            this.instStack.push(new PrimitiveVariable(bigInt, PrimitiveVariable.ValueType.Number, radix));
            return null;
        }
        BigDecimal bigDec = new BigDecimal(decimalNode.getText());
        int precisionLength = bigDec.precision();
        if (precisionLength < 8 && !Float.isInfinite(bigDec.floatValue())) {
            this.instStack.push(new PrimitiveVariable(Float.valueOf(bigDec.floatValue()), PrimitiveVariable.ValueType.Number, radix));
            return null;
        }
        if (precisionLength < 16 && !Double.isInfinite(bigDec.doubleValue())) {
            this.instStack.push(new PrimitiveVariable(bigDec.doubleValue(), PrimitiveVariable.ValueType.Number, radix));
            return null;
        }
        this.instStack.push(new PrimitiveVariable(bigDec, PrimitiveVariable.ValueType.Number, radix));
        return null;
    }

    @Override
    public T visitFuncCall(DataQLParser.FuncCallContext ctx) {
        ctx.routeMapping().accept(this);
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        FunCallRouteVariable funCall = new FunCallRouteVariable(routeVariable);
        List<DataQLParser.AnyObjectContext> paramLists = ctx.anyObject();
        if (paramLists != null) {
            for (DataQLParser.AnyObjectContext param : paramLists) {
                param.accept(this);
                Variable paramVar = (Variable)this.instStack.pop();
                funCall.addParam(paramVar);
            }
        }
        this.instStack.push(funCall);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_route1(DataQLParser.FuncCallResult_route1Context ctx) {
        List<DataQLParser.RouteSubscriptContext> subscriptList = ctx.routeSubscript();
        if (subscriptList != null) {
            for (DataQLParser.RouteSubscriptContext context : subscriptList) {
                context.accept(this);
            }
        }
        ctx.routeNameSet().accept(this);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_route2(DataQLParser.FuncCallResult_route2Context ctx) {
        DataQLParser.FuncCallResultContext funcCallResult;
        List<DataQLParser.RouteSubscriptContext> subscriptList = ctx.routeSubscript();
        for (DataQLParser.RouteSubscriptContext context : subscriptList) {
            context.accept(this);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            ctx.routeNameSet().accept(this);
        }
        if ((funcCallResult = ctx.funcCallResult()) != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_convert(DataQLParser.FuncCallResult_convertContext ctx) {
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        DataQLParser.ListValueContext listValue = ctx.listValue();
        DataQLParser.ObjectValueContext objectValue = ctx.objectValue();
        if (listValue != null) {
            listValue.accept(this);
            ListVariable listVariable = (ListVariable)this.instStack.pop();
            this.instStack.push(new ListFormat(routeVariable, listVariable));
        } else {
            objectValue.accept(this);
            ObjectVariable objectVariable = (ObjectVariable)this.instStack.pop();
            this.instStack.push(new ObjectFormat(routeVariable, objectVariable));
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_call(DataQLParser.FuncCallResult_callContext ctx) {
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        FunCallRouteVariable funCall = new FunCallRouteVariable(routeVariable);
        List<DataQLParser.AnyObjectContext> paramLists = ctx.anyObject();
        if (paramLists != null) {
            for (DataQLParser.AnyObjectContext param : paramLists) {
                param.accept(this);
                Variable paramVar = (Variable)this.instStack.pop();
                funCall.addParam(paramVar);
            }
        }
        this.instStack.push(funCall);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitParamRoute(DataQLParser.ParamRouteContext ctx) {
        DataQLParser.RouteNameSetContext routeNameSet;
        EnterRouteVariable.SpecialType special = this.specialType(ctx.ROU(), EnterRouteVariable.SpecialType.Special_B);
        TerminalNode identifier = ctx.IDENTIFIER();
        TerminalNode string = ctx.STRING();
        String rouName = null;
        EnterRouteVariable enter = new EnterRouteVariable(EnterRouteVariable.RouteType.Params, special);
        rouName = identifier != null ? this.fixIdentifier(identifier) : string.getText();
        this.instStack.push(new NameRouteVariable(enter, rouName));
        DataQLParser.RouteSubscriptContext routeSubscript = ctx.routeSubscript();
        if (routeSubscript != null) {
            routeSubscript.accept(this);
        }
        if ((routeNameSet = ctx.routeNameSet()) != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitSubExprRoute(DataQLParser.SubExprRouteContext ctx) {
        EnterRouteVariable.SpecialType special = this.specialType(ctx.ROU(), EnterRouteVariable.SpecialType.Special_B);
        EnterRouteVariable enter = new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, special);
        this.instStack.push(enter);
        List<DataQLParser.RouteSubscriptContext> subscriptContexts = ctx.routeSubscript();
        for (DataQLParser.RouteSubscriptContext subContext : subscriptContexts) {
            subContext.accept(this);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitNameExprRoute(DataQLParser.NameExprRouteContext ctx) {
        EnterRouteVariable.SpecialType special = this.specialType(ctx.ROU(), EnterRouteVariable.SpecialType.Special_B);
        EnterRouteVariable enter = new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, special);
        if (ctx.DOT() != null) {
            this.instStack.push(new NameRouteVariable(enter, ""));
        } else {
            this.instStack.push(enter);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitExprRoute(DataQLParser.ExprRouteContext ctx) {
        EnterRouteVariable.SpecialType specialType = this.specialType(ctx.ROU(), EnterRouteVariable.SpecialType.Special_A);
        EnterRouteVariable enter = new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, specialType);
        this.instStack.push(enter);
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitExprFmtRoute(DataQLParser.ExprFmtRouteContext ctx) {
        ctx.routeMapping().accept(this);
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        DataQLParser.ListValueContext listValue = ctx.listValue();
        DataQLParser.ObjectValueContext objectValue = ctx.objectValue();
        if (listValue != null) {
            listValue.accept(this);
            ListVariable listVariable = (ListVariable)this.instStack.pop();
            this.instStack.push(new ListFormat(routeVariable, listVariable));
        } else {
            objectValue.accept(this);
            ObjectVariable objectVariable = (ObjectVariable)this.instStack.pop();
            this.instStack.push(new ObjectFormat(routeVariable, objectVariable));
        }
        return null;
    }

    @Override
    public T visitRouteNameSet(DataQLParser.RouteNameSetContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitRouteName(DataQLParser.RouteNameContext ctx) {
        Object peek = this.instStack.peek();
        RouteVariable parent = null;
        if (peek instanceof RouteVariable) {
            this.instStack.pop();
            parent = (RouteVariable)peek;
        }
        String itemName = this.fixIdentifier(ctx.IDENTIFIER());
        this.instStack.push(new NameRouteVariable(parent, itemName));
        List<DataQLParser.RouteSubscriptContext> subList = ctx.routeSubscript();
        if (subList != null) {
            for (DataQLParser.RouteSubscriptContext subItem : subList) {
                subItem.accept(this);
            }
        }
        return null;
    }

    @Override
    public T visitRouteSubscript(DataQLParser.RouteSubscriptContext ctx) {
        RouteVariable atNode = (RouteVariable)this.instStack.pop();
        TerminalNode intNode = ctx.INTEGER_NUM();
        TerminalNode stringNode = ctx.STRING();
        DataQLParser.ExprContext exprContext = ctx.expr();
        if (intNode != null) {
            this.instStack.push(new SubscriptRouteVariable(atNode, Integer.parseInt(intNode.getText())));
            return null;
        }
        if (stringNode != null) {
            this.instStack.push(new SubscriptRouteVariable(atNode, this.fixString(stringNode)));
            return null;
        }
        if (exprContext != null) {
            exprContext.accept(this);
            Expression expr = (Expression)this.instStack.pop();
            this.instStack.push(new SubscriptRouteVariable(atNode, expr));
            return null;
        }
        throw this.newParseException(ctx.start, "parser failed -> visitRouteSubscript.");
    }

    @Override
    public T visitPrivilegeExpr(DataQLParser.PrivilegeExprContext ctx) {
        DataQLParser.ExprContext expr = ctx.expr();
        expr.accept(this);
        this.instStack.push(new PrivilegeExpression((Expression)this.instStack.pop()));
        DataQLParser.DyadicExprContext dyadicExpr = ctx.dyadicExpr();
        DataQLParser.TernaryExprContext ternaryExpr = ctx.ternaryExpr();
        if (dyadicExpr != null) {
            dyadicExpr.accept(this);
            return null;
        }
        if (ternaryExpr != null) {
            ternaryExpr.accept(this);
            return null;
        }
        return null;
    }

    @Override
    public T visitUnaryExpr(DataQLParser.UnaryExprContext ctx) {
        TerminalNode unaryOper = null;
        unaryOper = this.operSwitch(unaryOper, ctx.NOT());
        unaryOper = this.operSwitch(unaryOper, ctx.MINUS());
        unaryOper = this.operSwitch(unaryOper, ctx.PLUS());
        ctx.expr().accept(this);
        Expression expr = (Expression)this.instStack.pop();
        this.instStack.push(new UnaryExpression(expr, unaryOper.getText()));
        return null;
    }

    @Override
    public T visitMultipleExpr(DataQLParser.MultipleExprContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitDyadicExpr(DataQLParser.DyadicExprContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.PLUS());
        dyadicOper = this.operSwitch(dyadicOper, ctx.MINUS());
        dyadicOper = this.operSwitch(dyadicOper, ctx.MUL());
        dyadicOper = this.operSwitch(dyadicOper, ctx.DIV());
        dyadicOper = this.operSwitch(dyadicOper, ctx.DIV2());
        dyadicOper = this.operSwitch(dyadicOper, ctx.MOD());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LBT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.RBT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.AND());
        dyadicOper = this.operSwitch(dyadicOper, ctx.OR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.NOT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.XOR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LSHIFT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.RSHIFT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.RSHIFT2());
        dyadicOper = this.operSwitch(dyadicOper, ctx.GT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.GE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.EQ());
        dyadicOper = this.operSwitch(dyadicOper, ctx.NE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.SC_OR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.SC_AND());
        ctx.expr().accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        this.instStack.push(new DyadicExpression(expr1, dyadicOper.getText(), expr2));
        return null;
    }

    @Override
    public T visitTernaryExpr(DataQLParser.TernaryExprContext ctx) {
        this.visitChildren((RuleNode)ctx);
        Expression expr3 = (Expression)this.instStack.pop();
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        this.instStack.push(new TernaryExpression(expr1, expr2, expr3));
        return null;
    }

    @Override
    public T visitAtomExpr(DataQLParser.AtomExprContext ctx) {
        this.visitChildren((RuleNode)ctx);
        if (this.instStack.peek() instanceof Expression) {
            return null;
        }
        Variable var = (Variable)this.instStack.pop();
        this.instStack.push(new AtomExpression(var));
        return null;
    }

    @Override
    public T visitExtBlock(DataQLParser.ExtBlockContext ctx) {
        String fragmentName = this.fixIdentifier(ctx.IDENTIFIER());
        StringBuilder fragmentString = new StringBuilder();
        List<TerminalNode> chars = ctx.CHAR();
        if (chars != null) {
            chars.forEach(terminalNode -> fragmentString.append(terminalNode.getText()));
        }
        boolean isBatch = ctx.LSBT() != null;
        FragmentVariable fragmentVariable = new FragmentVariable(fragmentName, fragmentString.toString(), isBatch);
        DataQLParser.ExtParamsContext paramsContext = ctx.extParams();
        if (paramsContext != null) {
            for (TerminalNode terminalNode2 : paramsContext.IDENTIFIER()) {
                fragmentVariable.getParamList().add(this.fixIdentifier(terminalNode2));
            }
        }
        this.instStack.push(fragmentVariable);
        return null;
    }

    @Override
    public T visitExtParams(DataQLParser.ExtParamsContext ctx) {
        return null;
    }

    private EnterRouteVariable.SpecialType specialType(TerminalNode rou, EnterRouteVariable.SpecialType defaultType) {
        if (rou == null) {
            return defaultType;
        }
        String rouType = rou.getText();
        if ("#".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_A;
        }
        if ("$".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_B;
        }
        if ("@".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_C;
        }
        throw this.newParseException(rou.getSymbol(), "rouType '" + rouType + "' is not supported");
    }

    private TerminalNode operSwitch(TerminalNode first, TerminalNode second) {
        return first != null ? first : second;
    }

    private ParseException newParseException(Token token, String errorMessage) {
        return new ParseException(token.getLine(), token.getStartIndex(), errorMessage);
    }

    private String fixIdentifier(TerminalNode identifierNode) {
        String string = identifierNode.getText();
        if (string.charAt(0) == '`') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String fixString(TerminalNode stringNode) {
        String nodeText = stringNode.getText();
        return nodeText.substring(1, nodeText.length() - 1);
    }
}

