/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;
import net.hasor.dataql.compiler.ast.value.PrimitiveVariable;
import net.hasor.utils.StringUtils;

public class ListVariable
implements Variable {
    private List<Variable> expressionList = new ArrayList<Variable>();

    public void addItem(Variable valueExp) {
        if (valueExp != null) {
            this.expressionList.add(valueExp);
        }
    }

    public List<Variable> getExpressionList() {
        return this.expressionList;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (Variable var : ListVariable.this.expressionList) {
                    var.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        if (this.expressionList.isEmpty()) {
            writer.write("[]");
            return;
        }
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        boolean innerLine = this.expressionList.stream().allMatch(variable -> variable instanceof PrimitiveVariable);
        fixedString = innerLine ? "" : "\n" + fixedString;
        writer.write("[" + fixedString);
        for (int i = 0; i < this.expressionList.size(); ++i) {
            Variable expr;
            if (i > 0) {
                writer.write("," + fixedString);
            }
            if ((expr = this.expressionList.get(i)) instanceof EnterRouteVariable) {
                writer.write(((EnterRouteVariable)expr).getSpecialType().getCode());
                continue;
            }
            expr.doFormat(depth + 1, formatOption, writer);
        }
        if (innerLine) {
            writer.write("]");
        } else {
            writer.write("\n" + StringUtils.fixedString((char)' ', (int)((depth - 1) * 4)) + "]");
        }
    }
}

