/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.inst.InstSet;
import net.hasor.utils.StringUtils;

public class LambdaVariable
extends InstSet
implements Variable {
    private List<String> paramList = new ArrayList<String>();

    public void addParam(String name) {
        if (this.paramList.contains(name)) {
            throw new IllegalStateException(name + " param existing.");
        }
        this.paramList.add(name);
    }

    public List<String> getParamList() {
        return this.paramList;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (Inst var : LambdaVariable.this) {
                    var.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            writer.write(this.paramList.get(i));
        }
        writer.write(") -> {\n");
        super.doFormat(depth + 1, formatOption, writer);
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        writer.write(fixedString + "}");
    }
}

