/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;

public class FragmentVariable
implements Inst,
Variable {
    private String fragmentName;
    private List<String> paramList = new ArrayList<String>();
    private String fragmentString;
    private boolean batchMode;

    public FragmentVariable(String fragmentName, String fragmentString, boolean batchMode) {
        this.fragmentName = fragmentName;
        this.fragmentString = fragmentString;
        this.batchMode = batchMode;
    }

    public String getFragmentName() {
        return this.fragmentName;
    }

    public String getFragmentString() {
        return this.fragmentString;
    }

    public List<String> getParamList() {
        return this.paramList;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("@@" + this.fragmentName);
        if (this.batchMode) {
            writer.write("[]");
        }
        writer.write("(");
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i == 0) {
                writer.write(this.paramList.get(i));
                continue;
            }
            writer.write("," + this.paramList.get(i));
        }
        writer.write(") <%" + this.fragmentString + "%>");
    }
}

