/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;

public class ImportInst
implements Inst {
    private ImportType importType = null;
    private String importName = null;
    private String asName = null;

    public ImportInst(ImportType importType, String importName, String asName) {
        this.importType = importType;
        this.importName = importName;
        this.asName = asName;
    }

    public ImportType getImportType() {
        return this.importType;
    }

    public String getImportName() {
        return this.importName;
    }

    public String getAsName() {
        return this.asName;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("import ");
        if (this.importType == ImportType.Resource) {
            writer.write("@");
        } else if (this.importType == ImportType.ClassType) {
            // empty if block
        }
        writer.write('\"' + this.importName + '\"');
        writer.write(" as " + this.asName + ";\n");
    }

    public static enum ImportType {
        Resource,
        ClassType;

    }
}

