/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.utils.StringUtils;

public class ExitInst
implements Inst {
    private int exitCode;
    private Variable exitData;

    public ExitInst(int exitCode, Variable exitData) {
        this.exitCode = exitCode;
        this.exitData = exitData;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Variable getExitData() {
        return this.exitData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                ExitInst.this.exitData.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        if (this.exitCode != 0) {
            writer.write(fixedString + String.format("exit %s, ", this.exitCode));
        } else {
            writer.write(fixedString + "exit ");
        }
        this.exitData.doFormat(depth + 1, formatOption, writer);
        writer.write(";\n");
    }
}

