/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.binder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Query;
import net.hasor.dataql.binder.AppContextFinder;
import net.hasor.dataql.compiler.QueryModel;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.runtime.CompilerVarQuery;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.QueryHelper;
import org.antlr.v4.runtime.CharStream;

class InnerDataQLImpl
extends HintsSet
implements DataQL {
    private Map<String, Supplier<?>> compilerVarMap = new HashMap();
    private AppContext appContext;
    private Supplier<? extends Finder> finderObject;

    InnerDataQLImpl() {
    }

    public void initConfig(AppContext appContext) {
        this.appContext = appContext;
        if (this.finderObject == null) {
            AppContextFinder contextFinder = new AppContextFinder(appContext);
            this.finderObject = () -> contextFinder;
        }
    }

    public void setFinder(Supplier<? extends Finder> finder) {
        this.finderObject = finder;
    }

    @Override
    public <T> DataQL addShareVar(String name, Class<? extends T> implementation) {
        this.compilerVarMap.put(name, () -> this.finderObject.get().findBean(implementation));
        return this;
    }

    @Override
    public <T> DataQL addShareVar(String name, Supplier<T> provider) {
        this.compilerVarMap.put(name, provider);
        return this;
    }

    @Override
    public Map<String, Supplier<?>> getShareVarMap() {
        return Collections.unmodifiableMap(this.compilerVarMap);
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, BindInfo<T> bindInfo) {
        if (this.finderObject.get() instanceof AppContextFinder) {
            return this.addFragmentProcess(name, this.appContext.getProvider(bindInfo));
        }
        throw new UnsupportedOperationException("custom Finder Unsupported. ");
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, Class<T> implementation) {
        if (this.finderObject.get() instanceof AppContextFinder) {
            return this.addFragmentProcess(name, this.appContext.getProvider(implementation));
        }
        throw new UnsupportedOperationException("custom Finder Unsupported. ");
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, Supplier<T> provider) {
        if (this.finderObject.get() instanceof AppContextFinder) {
            ((AppContextFinder)this.finderObject.get()).addFragmentProcess(name, provider);
            return this;
        }
        throw new UnsupportedOperationException("custom Finder Unsupported. ");
    }

    @Override
    public Finder getFinder() {
        return this.finderObject.get();
    }

    @Override
    public QueryModel parserQuery(CharStream charStream) {
        return QueryHelper.queryParser(charStream);
    }

    @Override
    public QIL compilerQuery(QueryModel queryModel) throws IOException {
        return QueryHelper.queryCompiler(queryModel, this.compilerVarMap.keySet(), this.getFinder());
    }

    @Override
    public Query createQuery(QIL compilerQIL) {
        Query query = QueryHelper.createQuery(compilerQIL, this.finderObject.get());
        if (query instanceof CompilerVarQuery) {
            CompilerVarQuery varQuery = (CompilerVarQuery)query;
            this.compilerVarMap.forEach(varQuery::setCompilerVar);
        }
        query.setHints(this);
        return query;
    }
}

