/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Supplier;
import net.hasor.core.BindInfo;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Query;
import net.hasor.dataql.compiler.QueryModel;
import net.hasor.dataql.compiler.qil.QIL;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;

public interface DataQL {
    default public DataQL addShareVarInstance(String name, Object instance) {
        return this.addShareVar(name, () -> instance);
    }

    public <T> DataQL addShareVar(String var1, Class<? extends T> var2);

    public <T> DataQL addShareVar(String var1, Supplier<T> var2);

    public Map<String, Supplier<?>> getShareVarMap();

    default public DataQL addFragmentProcess(String name, FragmentProcess instance) {
        return this.addShareVar(name, () -> instance);
    }

    public <T extends FragmentProcess> DataQL addFragmentProcess(String var1, BindInfo<T> var2);

    public <T extends FragmentProcess> DataQL addFragmentProcess(String var1, Class<T> var2);

    public <T extends FragmentProcess> DataQL addFragmentProcess(String var1, Supplier<T> var2);

    public Finder getFinder();

    default public QueryModel parserQuery(String queryString) throws IOException {
        return this.parserQuery(new StringReader(queryString));
    }

    default public QueryModel parserQuery(Reader queryReader) throws IOException {
        return this.parserQuery((CharStream)CharStreams.fromReader((Reader)queryReader));
    }

    default public QueryModel parserQuery(InputStream queryInput) throws IOException {
        return this.parserQuery(queryInput, StandardCharsets.UTF_8);
    }

    default public QueryModel parserQuery(InputStream inputStream, Charset charset) throws IOException {
        return this.parserQuery(CharStreams.fromStream((InputStream)inputStream, (Charset)charset));
    }

    public QueryModel parserQuery(CharStream var1);

    default public QIL compilerQuery(String queryString) throws IOException {
        return this.compilerQuery(this.parserQuery(queryString));
    }

    default public QIL compilerQuery(Reader queryReader) throws IOException {
        return this.compilerQuery(this.parserQuery(queryReader));
    }

    default public QIL compilerQuery(InputStream queryInput) throws IOException {
        return this.compilerQuery(this.parserQuery(queryInput, StandardCharsets.UTF_8));
    }

    default public QIL compilerQuery(InputStream queryInput, Charset charset) throws IOException {
        return this.compilerQuery(this.parserQuery(queryInput, charset));
    }

    public QIL compilerQuery(QueryModel var1) throws IOException;

    default public Query createQuery(String queryString) throws IOException {
        return this.createQuery(this.compilerQuery(queryString));
    }

    default public Query createQuery(Reader queryReader) throws IOException {
        return this.createQuery(this.compilerQuery(queryReader));
    }

    default public Query createQuery(InputStream queryInput) throws IOException {
        return this.createQuery(this.compilerQuery(queryInput));
    }

    default public Query createQuery(InputStream inputStream, Charset charset) throws IOException {
        return this.createQuery(this.compilerQuery(inputStream, charset));
    }

    public Query createQuery(QIL var1);
}

