/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.fx.basic.Inner_ListStateUdfSource;
import net.hasor.utils.ExceptionUtils;

@Singleton
public class CollectionUdfSource
implements UdfSourceAssembly {
    public static boolean isEmpty(Object target) {
        if (target instanceof List) {
            return ((List)target).isEmpty();
        }
        if (target instanceof ListModel) {
            return ((ListModel)target).size() == 0;
        }
        if (target instanceof Map) {
            return ((Map)target).isEmpty();
        }
        if (target instanceof ObjectModel) {
            return ((ObjectModel)target).size() == 0;
        }
        return false;
    }

    public static List<Object> merge(UdfSourceAssembly.UdfParams dataArrays) {
        if (dataArrays == null) {
            return null;
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (Object object : dataArrays.allParams()) {
            if (object instanceof ListModel) {
                dataList.addAll(CollectionUdfSource.foreach(((ListModel)object).asOri()));
                continue;
            }
            dataList.addAll(CollectionUdfSource.foreach(object));
        }
        return dataList;
    }

    public static Map<String, Object> mergeMap(UdfSourceAssembly.UdfParams dataArrays) {
        if (dataArrays == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        Object[] allParams = dataArrays.allParams();
        for (int i = 0; i < allParams.length; ++i) {
            Object object = allParams[i];
            if (object instanceof Map) {
                ((Map)object).forEach((o, o2) -> finalMap.put(o.toString(), o2));
            }
            if (!((object = DomainHelper.convertTo((Object)object)) instanceof ObjectModel)) {
                throw new IllegalArgumentException("all args must be Map.");
            }
            finalMap.putAll(((ObjectModel)object).unwrap());
        }
        return finalMap;
    }

    public static List<Object> filter(List<Object> valueList, Udf filter, Hints hints) {
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        if (filter == null) {
            return valueList;
        }
        AtomicReference<Predicate<Object>> refPredicate = new AtomicReference<Predicate<Object>>(o -> {
            try {
                return (Boolean)filter.call(hints, new Object[]{o});
            }
            catch (Throwable e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        });
        return valueList.stream().filter(refPredicate.get()).collect(Collectors.toList());
    }

    public static Map<String, Object> filterMap(Map<String, Object> mapData, Udf keyFilter, Hints hints) throws Throwable {
        if (keyFilter == null || mapData.isEmpty()) {
            return mapData;
        }
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        for (String key : mapData.keySet()) {
            if (!((Boolean)keyFilter.call(hints, new Object[]{key})).booleanValue()) continue;
            finalMap.put(key, mapData.get(key));
        }
        return finalMap;
    }

    protected static Collection<Object> foreach(Object collection) {
        Collection<Object> listData = null;
        if (collection == null) {
            listData = new ArrayList<Object>();
        } else if (!(collection instanceof Collection)) {
            if (collection.getClass().isArray()) {
                listData = new ArrayList();
                Collections.addAll(listData, (Object[])collection);
            } else {
                listData = Collections.singletonList(collection);
            }
        } else {
            listData = (Collection)collection;
        }
        return listData;
    }

    public static List<Object> limit(List<Object> collection, int startInt, int limitInt) {
        Collection<Object> objects = CollectionUdfSource.foreach(collection);
        if (objects.isEmpty()) {
            return null;
        }
        if (limitInt <= 0) {
            limitInt = Integer.MAX_VALUE;
        }
        int curIndex = 0;
        Iterator<Object> iterator = objects.iterator();
        ArrayList<Object> finalList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object curData = iterator.next();
            if (curIndex >= startInt && limitInt > 0) {
                finalList.add(curData);
                --limitInt;
            }
            ++curIndex;
        }
        return finalList;
    }

    public static Map<String, Udf> newList(Object mabeCollection) {
        ArrayList<Object> initData = new ArrayList<Object>();
        if (mabeCollection != null) {
            initData.addAll(CollectionUdfSource.foreach(mabeCollection));
        }
        return (Map)new Inner_ListStateUdfSource(initData).getUdfResource(Finder.DEFAULT).get();
    }

    public static List<Object> listSort(List<Object> listData, Udf sortUdf, Hints hints) {
        if (listData == null) {
            return Collections.emptyList();
        }
        if (sortUdf == null) {
            listData.sort((o1, o2) -> {
                int hc1 = o1 == null ? 0 : o1.hashCode();
                int hc2 = o2 == null ? 0 : o2.hashCode();
                return Integer.compare(hc1, hc2);
            });
            return listData;
        }
        listData.sort((o1, o2) -> {
            try {
                return (Integer)sortUdf.call(hints, new Object[]{o1, o2});
            }
            catch (Throwable e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        });
        return listData;
    }

    public static Map<String, Object> list2map(List<Object> valueList, Object key, Udf convert, Hints hints) throws Throwable {
        if (key == null) {
            throw new IllegalArgumentException("The key parameter cannot be null");
        }
        if (!(key instanceof String) && !(key instanceof Udf)) {
            throw new IllegalArgumentException("key arg must be Udf or String");
        }
        if (key instanceof String) {
            return CollectionUdfSource.list2map_string(valueList, key.toString(), convert, hints);
        }
        return CollectionUdfSource.list2map_udf(valueList, (Udf)key, convert, hints);
    }

    private static Map<String, Object> list2map_string(List<Object> valueList, String key, Udf convert, Hints hints) throws Throwable {
        return CollectionUdfSource.list2map_udf(valueList, (readOnly, params) -> {
            int rowNumber = (Integer)params[0];
            if (params[1] == null) {
                throw new NullPointerException("element " + rowNumber + " data is null");
            }
            DataModel rowData = DomainHelper.convertTo((Object)params[1]);
            if (!rowData.isObject()) {
                throw new NullPointerException("element " + rowNumber + " type is not Object");
            }
            DataModel keyValue = ((ObjectModel)rowData).get(key);
            if (keyValue == null) {
                throw new NullPointerException("element " + rowNumber + " key '" + key + "' is not exist");
            }
            if (!keyValue.isValue()) {
                throw new NullPointerException("element " + rowNumber + " key '" + key + "' type must primary");
            }
            return String.valueOf(keyValue.unwrap());
        }, convert, hints);
    }

    private static Map<String, Object> list2map_udf(List<Object> valueList, Udf extractKey, Udf convert, Hints hints) throws Throwable {
        LinkedHashMap<String, Object> mapData;
        block8: {
            int i;
            ListModel convertTo = (ListModel)DomainHelper.convertTo(valueList);
            if (convertTo == null || convertTo.size() == 0) {
                return Collections.emptyMap();
            }
            if (extractKey == null) {
                throw new IllegalArgumentException("extractKey Udf is null");
            }
            mapData = new LinkedHashMap<String, Object>();
            LinkedHashMap errorData = new LinkedHashMap();
            for (i = 0; i < convertTo.size(); ++i) {
                DataModel valueData = convertTo.get(i);
                try {
                    DataModel keyData = DomainHelper.convertTo((Object)extractKey.call(hints, new Object[]{i, valueData}));
                    if (!keyData.isValue()) {
                        throw new NullPointerException("element " + i + " key type must primary");
                    }
                    String unwrapKey = String.valueOf(keyData.unwrap());
                    if (convert != null) {
                        Object mapValue = convert.call(hints, new Object[]{i, valueData});
                        valueData = DomainHelper.convertTo((Object)mapValue);
                    }
                    mapData.put(unwrapKey, valueData);
                    continue;
                }
                catch (Exception e) {
                    LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
                    hashMap.put("errorMsg", e.getMessage());
                    hashMap.put("errorData", (String)valueData);
                    errorData.put("idx_" + i, hashMap);
                }
            }
            if (errorData.isEmpty()) break block8;
            i = 0;
            String mapKey = "errorData";
            while (mapData.containsKey(mapKey)) {
                mapKey = "errorData_" + ++i;
            }
            mapData.put(mapKey, errorData);
        }
        return mapData;
    }

    private static String evalJoinKey(Object data, String[] joinField) {
        ObjectModel objectModel = (ObjectModel)DomainHelper.convertTo((Object)data);
        StringBuilder joinKey = new StringBuilder("");
        Arrays.stream(joinField).forEach(s -> {
            Object unwrap = objectModel.get(s).unwrap();
            unwrap = unwrap == null ? "NULL" : "s" + unwrap.toString();
            joinKey.append(unwrap).append(",");
        });
        return joinKey.toString();
    }

    public static List<Map<String, Object>> mapJoin(List<Object> data1, List<Object> data2, Map<String, String> join) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(join);
        String[] joinKey1 = linkedHashMap.keySet().toArray(new String[0]);
        String[] joinKey2 = linkedHashMap.values().toArray(new String[0]);
        final HashMap<String, Object> joinMap = new HashMap<String, Object>();
        for (Object dat : data2) {
            joinMap.put(CollectionUdfSource.evalJoinKey(dat, joinKey2), dat);
        }
        ArrayList<Map<String, Object>> returnData = new ArrayList<Map<String, Object>>();
        for (final Object dat1 : data1) {
            final String joinKey = CollectionUdfSource.evalJoinKey(dat1, joinKey1);
            returnData.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("data1", dat1);
                    this.put("data2", joinMap.get(joinKey));
                }
            });
        }
        return returnData;
    }

    public static List<String> mapKeys(Map<String, Object> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(map.keySet());
    }

    public static List<Object> mapValues(Map<String, Object> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(map.values());
    }

    public static Map<String, Object> mapSort(Map<String, Object> mapData, Udf sortUdf, Hints hints) {
        if (mapData == null) {
            return Collections.emptyMap();
        }
        List<Object> keySort = CollectionUdfSource.listSort(new ArrayList<Object>(mapData.keySet()), sortUdf, hints);
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        for (Object key : keySort) {
            String keyStr = key.toString();
            newMap.put(keyStr, mapData.get(keyStr));
        }
        return newMap;
    }

    public static List<Object> map2list(Map<String, Object> mapValue, Udf convert, Hints hints) throws Throwable {
        if (mapValue == null || mapValue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> listData = new ArrayList<Object>();
        Set<Map.Entry<String, Object>> entrySet = mapValue.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (convert != null) {
                listData.add(convert.call(hints, new Object[]{entry.getKey(), entry.getValue()}));
                continue;
            }
            ObjectModel objectModel = DomainHelper.newObject();
            objectModel.put("key", (Object)entry.getKey());
            objectModel.put("value", entry.getValue());
            listData.add(objectModel);
        }
        return listData;
    }

    public static String map2string(Map<String, Object> mapValue, String joinStr, Udf convert, Hints hints) throws Throwable {
        if (mapValue == null || mapValue.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : mapValue.keySet()) {
            Object value = mapValue.get(key);
            stringBuilder.append(convert.call(hints, new Object[]{key, value}));
            stringBuilder.append(joinStr);
        }
        if (stringBuilder.length() > 0) {
            int joinLength = joinStr.length();
            return stringBuilder.substring(0, stringBuilder.length() - joinLength);
        }
        return stringBuilder.toString();
    }
}

