/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.service;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.web.application.PageHandle;
import net.contextfw.web.application.ResourceCleaner;
import net.contextfw.web.application.WebApplication;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.internal.page.PageScope;
import net.contextfw.web.application.internal.page.WebApplicationPage;
import net.contextfw.web.application.internal.service.DirectoryWatcher;
import net.contextfw.web.application.internal.service.UpdateInvocation;
import net.contextfw.web.application.lifecycle.LifecycleListener;
import net.contextfw.web.application.remote.ResourceResponse;
import net.contextfw.web.application.scope.Execution;
import net.contextfw.web.application.scope.PageScopedExecutor;
import net.contextfw.web.application.scope.ScopedWebApplicationExecution;
import net.contextfw.web.application.scope.WebApplicationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UpdateHandler {
    private static final String CONTEXTFW_REFRESH = "contextfw-refresh";
    private static final String CONTEXTFW_UPDATE = "contextfw-update";
    private static final String CONTEXTFW_REMOVE = "contextfw-remove";
    private ThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(10);
    private Logger logger = LoggerFactory.getLogger(UpdateHandler.class);
    private final LifecycleListener listeners;
    private final Gson gson;
    private final DirectoryWatcher watcher;
    private final ResourceCleaner cleaner;
    private PageScope pageScope;
    private final long maxInactivity;
    private final WebApplicationStorage storage;

    @Inject
    public UpdateHandler(LifecycleListener listeners, DirectoryWatcher watcher, ResourceCleaner cleaner, WebApplicationStorage storage, Configuration configuration, PageScope pageScope, Gson gson) {
        this.gson = gson;
        this.listeners = listeners;
        this.maxInactivity = configuration.get(Configuration.MAX_INACTIVITY);
        this.storage = storage;
        this.pageScope = pageScope;
        if (configuration.get(Configuration.DEVELOPMENT_MODE).booleanValue()) {
            this.cleaner = cleaner;
            this.watcher = watcher;
        } else {
            this.cleaner = null;
            this.watcher = null;
        }
    }

    private int getCommandStart(String[] splits) {
        int remaining = splits.length;
        for (int i = 0; i < splits.length; ++i) {
            String s = splits[i];
            if ((CONTEXTFW_REMOVE.equals(s) || CONTEXTFW_REFRESH.equals(s)) && --remaining >= 1) {
                return i;
            }
            if (!CONTEXTFW_UPDATE.equals(s) || remaining < 3) continue;
            return i;
        }
        return -1;
    }

    public final void handleRequest(final HttpServlet servlet, final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        String[] uriSplits;
        int commandStart;
        if (this.watcher != null && this.watcher.hasChanged()) {
            this.logger.info("Reloading resources");
            this.cleaner.clean();
        }
        if ((commandStart = this.getCommandStart(uriSplits = request.getRequestURI().split("/"))) != -1) {
            String command = uriSplits[commandStart];
            PageHandle handle = new PageHandle(uriSplits[commandStart + 1]);
            if (CONTEXTFW_REMOVE.equals(command)) {
                this.storage.remove(handle, request);
                response.setStatus(204);
            } else if (CONTEXTFW_REFRESH.equals(command)) {
                this.storage.refresh(handle, request, System.currentTimeMillis() + this.maxInactivity);
                response.setStatus(204);
            } else if (CONTEXTFW_UPDATE.equals(command)) {
                final UpdateInvocation[] invocation = new UpdateInvocation[]{UpdateInvocation.NOT_DELAYED};
                this.storage.update(handle, request, System.currentTimeMillis() + this.maxInactivity, new ScopedWebApplicationExecution(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(WebApplication application) {
                        if (application == null) {
                            try {
                                response.sendError(404);
                            }
                            catch (IOException e) {
                                throw new WebApplicationException(e);
                            }
                        }
                        WebApplicationPage page = (WebApplicationPage)application;
                        UpdateHandler.this.pageScope.activatePage(page, servlet, request, response);
                        try {
                            invocation[0] = page.getWebApplication().updateState(uriSplits[commandStart + 2], uriSplits[commandStart + 3]);
                            if (invocation[0].isDelayed()) {
                                UpdateHandler.this.pageScope.deactivateCurrentPage();
                                return;
                            }
                            if (!invocation[0].isResource() && !invocation[0].isCancelled()) {
                                UpdateHandler.this.listeners.beforeRender();
                                UpdateHandler.this.setHeaders(response);
                                response.setContentType("text/xml; charset=UTF-8");
                                page.getWebApplication().sendResponse();
                                UpdateHandler.this.listeners.afterRender();
                            }
                        }
                        catch (Exception e) {
                            UpdateHandler.this.listeners.onException(e);
                        }
                        finally {
                            UpdateHandler.this.pageScope.deactivateCurrentPage();
                        }
                    }
                });
                HashSet<Execution> afterRun = new HashSet<Execution>();
                Object retVal = null;
                retVal = invocation[0].isResource() ? this.handleResource(request, response, invocation[0]) : invocation[0].getRetVal();
                if (retVal instanceof Execution) {
                    afterRun.add((Execution)retVal);
                } else if (retVal instanceof Iterable) {
                    for (Object i : (Iterable)retVal) {
                        afterRun.add((Execution)i);
                    }
                } else if (retVal instanceof Execution[]) {
                    for (Execution i : (Execution[])retVal) {
                        afterRun.add(i);
                    }
                }
                if (!afterRun.isEmpty()) {
                    this.runAfterRun(handle, afterRun);
                }
            }
        } else {
            response.sendError(400);
        }
    }

    private void runAfterRun(final PageHandle handle, Set<Execution> afterRun) throws IOException {
        final PageScopedExecutor pageScopedExecutor = new PageScopedExecutor(){

            @Override
            public void execute(final Runnable execution) {
                UpdateHandler.this.storage.execute(handle, new ScopedWebApplicationExecution(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(WebApplication application) {
                        if (application != null) {
                            WebApplicationPage page = (WebApplicationPage)application;
                            UpdateHandler.this.pageScope.activatePage(page, null, null, null);
                            try {
                                execution.run();
                            }
                            finally {
                                UpdateHandler.this.pageScope.deactivateCurrentPage();
                            }
                        }
                    }
                });
            }
        };
        for (final Execution exec : afterRun) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        exec.execute(pageScopedExecutor);
                    }
                    catch (RuntimeException e) {
                        UpdateHandler.this.logger.error("Error during running Execution", (Throwable)e);
                    }
                }
            });
        }
    }

    private Execution handleResource(HttpServletRequest request, HttpServletResponse response, UpdateInvocation invocation) throws IOException {
        if (invocation.getRetVal() == null) {
            response.getWriter().close();
            return null;
        }
        if (invocation.getRetVal() instanceof ResourceResponse) {
            return ((ResourceResponse)invocation.getRetVal()).serve(request, response);
        }
        this.setHeaders(response);
        response.setContentType("application/json; charset=UTF-8");
        this.gson.toJson(invocation.getRetVal(), (Appendable)response.getWriter());
        response.getWriter().close();
        return null;
    }

    public void setHeaders(HttpServletResponse response) {
        response.addHeader("Expires", "Sun, 19 Nov 1978 05:00:00 GMT");
        response.addHeader("Last-Modified", new Date().toString());
        response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Connection", "Keep-Alive");
    }

    @Inject
    public void setPageScope(PageScope pageScope) {
        this.pageScope = pageScope;
    }
}

