/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.web.application.ResourceCleaner;
import net.contextfw.web.application.WebApplication;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.internal.component.MetaComponentException;
import net.contextfw.web.application.internal.development.InternalDevelopmentTools;
import net.contextfw.web.application.internal.page.PageScope;
import net.contextfw.web.application.internal.page.WebApplicationPage;
import net.contextfw.web.application.internal.service.DirectoryWatcher;
import net.contextfw.web.application.internal.servlet.UriMapping;
import net.contextfw.web.application.lifecycle.LifecycleListener;
import net.contextfw.web.application.remote.ErrorResolution;
import net.contextfw.web.application.scope.ScopedWebApplicationExecution;
import net.contextfw.web.application.scope.WebApplicationStorage;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitHandler {
    private Logger logger = LoggerFactory.getLogger(InitHandler.class);
    private static final long HOUR = 216000000L;
    @Inject
    private Provider<net.contextfw.web.application.internal.service.WebApplication> webApplicationProvider;
    @Inject
    private LifecycleListener listeners;
    private PageScope pageScope;
    @Inject
    private WebApplicationStorage storage;
    private final long initialMaxInactivity;
    private DirectoryWatcher watcher;
    private ResourceCleaner cleaner;
    private final boolean developmentMode;
    private final InternalDevelopmentTools internalDevelopmentTools;

    public InitHandler(Configuration properties, PageScope pageScope, InternalDevelopmentTools internalDevelopmentTools) {
        this.initialMaxInactivity = properties.get(Configuration.INITIAL_MAX_INACTIVITY);
        this.developmentMode = properties.get(Configuration.DEVELOPMENT_MODE);
        this.pageScope = pageScope;
        this.internalDevelopmentTools = internalDevelopmentTools;
    }

    public final void handleRequest(final UriMapping mapping, final List<Class<? extends Component>> chain, HttpServlet servlet, HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if (this.watcher != null && this.watcher.hasChanged()) {
            this.logger.debug("Reloading resources");
            this.cleaner.clean();
            this.internalDevelopmentTools.reloadResources();
        }
        response.addHeader("Expires", "Sun, 19 Nov 1978 05:00:00 GMT");
        response.addHeader("Last-Modified", new Date().toString());
        response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.addHeader("Pragma", "no-cache");
        if (chain == null) {
            response.sendError(404);
        } else {
            WebApplicationPage page = this.pageScope.createPage(servlet, request, response);
            final MutableBoolean expired = new MutableBoolean(false);
            this.storage.initialize(page, request, System.currentTimeMillis() + 216000000L, new ScopedWebApplicationExecution(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(WebApplication application) {
                    try {
                        WebApplicationPage page = (WebApplicationPage)application;
                        net.contextfw.web.application.internal.service.WebApplication app = (net.contextfw.web.application.internal.service.WebApplication)InitHandler.this.webApplicationProvider.get();
                        app.setInitializerChain(chain);
                        page.setWebApplication(app);
                        InitHandler.this.listeners.beforeInitialize();
                        page.getWebApplication().initState(mapping);
                        InitHandler.this.listeners.afterInitialize();
                        InitHandler.this.listeners.beforeRender();
                        expired.setValue(page.getWebApplication().sendResponse());
                        InitHandler.this.listeners.afterRender();
                    }
                    catch (Exception e) {
                        if (e instanceof MetaComponentException) {
                            ErrorResolution resolution = ((MetaComponentException)e).getResolution();
                            try {
                                if (resolution == ErrorResolution.SEND_NOT_FOUND_ERROR) {
                                    response.sendError(404);
                                } else if (resolution == ErrorResolution.SEND_BAD_REQUEST_ERROR) {
                                    response.sendError(400);
                                }
                            }
                            catch (IOException e1) {
                                throw new WebApplicationException(e1);
                            }
                        }
                        InitHandler.this.listeners.onException(e);
                    }
                    finally {
                        InitHandler.this.pageScope.deactivateCurrentPage();
                    }
                }
            });
            if (expired.booleanValue()) {
                this.storage.remove(page.getHandle(), request);
            } else {
                this.storage.refresh(page.getHandle(), request, System.currentTimeMillis() + this.initialMaxInactivity);
            }
        }
    }

    @Inject
    public void setWatcher(DirectoryWatcher watcher) {
        if (this.developmentMode) {
            this.watcher = watcher;
        }
    }

    @Inject
    public void setCleaner(ResourceCleaner cleaner) {
        if (this.developmentMode) {
            this.cleaner = cleaner;
        }
    }

    public void setPageScope(PageScope pageScope) {
        this.pageScope = pageScope;
    }
}

