/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.page;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.web.application.PageContext;
import net.contextfw.web.application.internal.page.WebApplicationPage;
import net.contextfw.web.application.internal.page.WebApplicationPageImpl;
import net.contextfw.web.application.lifecycle.LifecycleListener;

public class PageScope
implements Scope {
    private LifecycleListener listener;
    private final ThreadLocal<WebApplicationPage> currentPage = new ThreadLocal();

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                WebApplicationPage page = (WebApplicationPage)PageScope.this.currentPage.get();
                if (page != null) {
                    Object bean = page.getBean(key);
                    if (bean != null) {
                        return bean;
                    }
                    return page.setBean(key, unscoped.get());
                }
                throw new OutOfScopeException("PageScope does not exist!");
            }
        };
    }

    public void deactivateCurrentPage() {
        WebApplicationPage page = this.currentPage.get();
        if (page != null) {
            this.listener.beforePageScopeDeactivation();
            PageContext context = (PageContext)page.getBean(Key.get(PageContext.class));
            context.setServlet(null);
            context.setRequest(null);
            context.setResponse(null);
            this.currentPage.remove();
        }
    }

    public void activatePage(WebApplicationPage page, HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        PageContext context = (PageContext)page.getBean(Key.get(PageContext.class));
        context.setServlet(servlet);
        context.setRequest(request);
        context.setResponse(response);
        this.currentPage.set(page);
        this.listener.afterPageScopeActivation();
    }

    public synchronized WebApplicationPage createPage(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        WebApplicationPageImpl page = new WebApplicationPageImpl();
        page.setBean(Key.get(PageContext.class), new PageContext(servlet, request, response));
        this.currentPage.set(page);
        return page;
    }

    @Inject
    public void setListener(LifecycleListener listener) {
        this.listener = listener;
    }
}

