/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.initializer;

import com.google.inject.Injector;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.component.ComponentBuilder;
import net.contextfw.web.application.internal.component.MetaComponent;
import net.contextfw.web.application.internal.servlet.UriMapping;
import net.contextfw.web.application.lifecycle.ViewComponent;
import net.contextfw.web.application.lifecycle.ViewContext;

public class InitializerContextImpl
implements ViewContext {
    private final transient List<Class<? extends Component>> chain;
    private final transient Injector injector;
    private int currentIndex = 0;
    private transient Component leaf;
    private final transient ComponentBuilder componentBuilder;
    private final transient UriMapping mapping;
    private final transient String uri;
    private final transient HttpServletRequest request;

    public InitializerContextImpl(ComponentBuilder componentBuilder, UriMapping mapping, String uri, Injector injector, HttpServletRequest request, List<Class<? extends Component>> chain) {
        this.chain = chain;
        this.injector = injector;
        this.componentBuilder = componentBuilder;
        this.mapping = mapping;
        this.uri = uri;
        this.request = request;
    }

    @Override
    public Class<? extends Component> getChildClass() {
        if (this.currentIndex == this.chain.size()) {
            return null;
        }
        return this.chain.get(this.currentIndex);
    }

    @Override
    public Component initChild() {
        Class<? extends Component> cl = this.getChildClass();
        if (cl == null) {
            throw new WebApplicationException("Error getting a child initializer. Initializer " + this.chain.get(this.currentIndex - 1).getName() + " does not have any children");
        }
        Component component = (Component)this.injector.getInstance(cl);
        MetaComponent meta = this.componentBuilder.getMetaComponent(cl);
        meta.applyPathParams(component, this.mapping, this.uri);
        meta.applyRequestParams(component, this.request);
        this.leaf = component;
        if (ViewComponent.class.isAssignableFrom(cl)) {
            ++this.currentIndex;
            ((ViewComponent)((Object)component)).initialize(this);
        }
        return component;
    }

    public Component getLeaf() {
        return this.leaf;
    }
}

