/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.development;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.contextfw.web.application.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class ReloadingClassLoaderConf {
    private final Set<Pattern> reloadablePackages = new HashSet<Pattern>();
    private final Set<String> reloadablePackageNames = new HashSet<String>();
    private final Set<Class<?>> excludedClasses = new HashSet();

    public ReloadingClassLoaderConf(Configuration conf) {
        for (Object obj : conf.get(Configuration.RELOADABLE_CLASSES)) {
            if (obj instanceof Set) {
                for (Object value : (Set)obj) {
                    if (!(value instanceof Class)) continue;
                    this.excludedClasses.add((Class)value);
                }
                continue;
            }
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            this.addReloadablePackage(str);
        }
        for (String viewPackage : (Set)conf.get(Configuration.VIEW_COMPONENT_ROOT_PACKAGE)) {
            this.addReloadablePackage(viewPackage + ":true");
        }
    }

    private void addReloadablePackage(String str) {
        String name = StringUtils.substringBefore((String)str, (String)":");
        boolean recursive = Boolean.parseBoolean(StringUtils.substringAfter((String)str, (String)":"));
        String postfix = recursive ? "\\..+" : "\\.[^\\.]+";
        this.reloadablePackageNames.add(name);
        this.reloadablePackages.add(Pattern.compile("^" + name.replaceAll("\\.", "\\.") + postfix));
    }

    public Set<Class<?>> getExcludedClasses() {
        return this.excludedClasses;
    }

    public boolean isInReloadablePackage(String className) {
        for (Pattern pattern : this.reloadablePackages) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public Set<String> getReloadablePackageNames() {
        return this.reloadablePackageNames;
    }
}

