/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.development;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.contextfw.web.application.internal.development.ReloadingClassLoader;
import net.contextfw.web.application.internal.development.ReloadingClassLoaderConf;

public class ClassLoaderProvider {
    private final ReloadingClassLoaderConf conf;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ClassLoaderProvider(ReloadingClassLoaderConf conf) {
        this.conf = conf;
    }

    public boolean isReloadable() {
        return this.conf != null;
    }

    public ClassLoader get() {
        return this.classLoader;
    }

    public ClassLoader reload() {
        if (this.isReloadable() && this.conf != null) {
            this.classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new ReloadingClassLoader(ClassLoaderProvider.this.conf);
                }
            });
        }
        return this.classLoader;
    }
}

