/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.configuration;

import net.contextfw.web.application.configuration.TemporalProperty;

public class TemporalPropertyImpl
implements TemporalProperty {
    private final String key;
    private final long value;

    public TemporalPropertyImpl(String key) {
        this.key = key;
        this.value = 0L;
    }

    private TemporalPropertyImpl(String key, long value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public TemporalPropertyImpl inHoursAndMins(long hours, long mins) {
        return new TemporalPropertyImpl(this.key, (hours * 60L + mins) * 60L * 1000L);
    }

    @Override
    public TemporalPropertyImpl inMinsAndSecs(long minutes, long seconds) {
        return new TemporalPropertyImpl(this.key, (seconds + minutes * 60L) * 1000L);
    }

    @Override
    public TemporalPropertyImpl inSeconds(long seconds) {
        return this.inMillis(seconds * 1000L);
    }

    @Override
    public TemporalPropertyImpl inMinutes(long minutes) {
        return this.inSeconds(minutes * 60L);
    }

    @Override
    public TemporalPropertyImpl inMillis(long millis) {
        return new TemporalPropertyImpl(this.key, millis);
    }

    @Override
    public Long validate(Long value) {
        if (value == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Property cannot be negative < 0");
        }
        return value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }
}

