/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.configuration;

import net.contextfw.web.application.internal.configuration.BasicSettableProperty;

public class RangedIntegerPropertyImpl
extends BasicSettableProperty<Integer> {
    private final int min;
    private final int max;

    public RangedIntegerPropertyImpl(String key, int min, int max) {
        super(key);
        this.min = min;
        this.max = max;
    }

    @Override
    public Integer validate(Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("Property '" + this.getKey() + "' cannot be null");
        }
        if (value < this.min) {
            throw new IllegalArgumentException("Property '" + this.getKey() + "' was too small: " + value + " < " + this.min);
        }
        if (value > this.max) {
            throw new IllegalArgumentException("Property '" + this.getKey() + "' was too big: " + value + " > " + this.max);
        }
        return value;
    }
}

