/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.component;

import java.util.HashMap;
import java.util.Map;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.component.ComponentRegister;
import net.contextfw.web.application.lifecycle.PageScoped;

@PageScoped
public class InternalComponentRegister
implements ComponentRegister {
    private int idCounter = 0;
    private Map<String, Component> components = new HashMap<String, Component>();

    private String getNextId() {
        return "c" + this.idCounter++;
    }

    public void register(Component component) {
        if (component.getId() == null) {
            component.setId(this.getNextId());
        }
        this.components.put(component.getId(), component);
    }

    public void unregister(Component component) {
        this.components.remove(component.getId());
    }

    public Component findComponent(String id) {
        return this.components.get(id);
    }

    @Override
    public <C extends Component> C findComponent(Class<C> cl, String id) {
        return (C)this.findComponent(id);
    }
}

