/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import net.contextfw.web.application.PropertyProvider;
import net.contextfw.web.application.ResourceCleaner;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.internal.development.InternalDevelopmentTools;
import net.contextfw.web.application.internal.development.ReloadingClassLoaderConf;
import net.contextfw.web.application.internal.initializer.InitializerProvider;
import net.contextfw.web.application.internal.page.PageScope;
import net.contextfw.web.application.internal.service.DirectoryWatcher;
import net.contextfw.web.application.internal.service.InitHandler;
import net.contextfw.web.application.internal.service.UpdateHandler;
import net.contextfw.web.application.internal.servlet.CSSServlet;
import net.contextfw.web.application.internal.servlet.DevelopmentFilter;
import net.contextfw.web.application.internal.servlet.InitServlet;
import net.contextfw.web.application.internal.servlet.RegexUriMapping;
import net.contextfw.web.application.internal.servlet.ScriptServlet;
import net.contextfw.web.application.internal.servlet.UpdateServlet;
import net.contextfw.web.application.internal.servlet.UriMapping;
import net.contextfw.web.application.internal.servlet.UriMappingFactory;
import net.contextfw.web.application.internal.util.ClassScanner;
import net.contextfw.web.application.lifecycle.LifecycleListener;
import net.contextfw.web.application.lifecycle.RequestInvocationFilter;
import net.contextfw.web.application.scope.WebApplicationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationServletModule
extends ServletModule {
    private Logger logger = LoggerFactory.getLogger(WebApplicationServletModule.class);
    private final Pattern classPattern = Pattern.compile(".+\\.class");
    private final PropertyProvider properties;
    private final String resourcePrefix;
    private final Set<String> rootPackages;
    private final Configuration configuration;
    private final Map<String, InitServlet> servlets = new HashMap<String, InitServlet>();
    private InitializerProvider initializerProvider;
    private ReloadingClassLoaderConf reloadConf;
    private final RequestInvocationFilter filter;
    private InitHandler initHandler;
    private PageScope pageScope;
    private InternalDevelopmentTools internalDevelopmentTools;

    public WebApplicationServletModule(Configuration configuration, PropertyProvider propertyProvider, PageScope pageScope, InternalDevelopmentTools internalDevelopmentTools) {
        this.resourcePrefix = configuration.get(Configuration.RESOURCES_PREFIX);
        this.configuration = configuration;
        this.properties = propertyProvider;
        this.pageScope = pageScope;
        this.internalDevelopmentTools = internalDevelopmentTools;
        this.rootPackages = (Set)configuration.get(Configuration.VIEW_COMPONENT_ROOT_PACKAGE);
        boolean reloadEnabled = configuration.get(Configuration.CLASS_RELOADING_ENABLED);
        if (reloadEnabled && configuration.get(Configuration.DEVELOPMENT_MODE).booleanValue()) {
            this.reloadConf = new ReloadingClassLoaderConf(configuration);
        }
        this.filter = configuration.get(Configuration.REQUEST_INVOCATION_FILTER);
    }

    protected void configureServlets() {
        this.requestInjection(this.filter);
        this.initHandler = new InitHandler(this.configuration, this.pageScope, this.internalDevelopmentTools);
        this.requestInjection(this.initHandler);
        this.initializerProvider = new InitializerProvider();
        this.serve(this.resourcePrefix + ".js", new String[0]).with(ScriptServlet.class);
        this.serve(this.resourcePrefix + ".css", new String[0]).with(CSSServlet.class);
        this.serveRegex(".*/contextfw-update/.*", new String[0]).with(UpdateServlet.class);
        this.serveRegex(".*/contextfw-refresh/.*", new String[0]).with(UpdateServlet.class);
        this.serveRegex(".*/contextfw-remove/.*", new String[0]).with(UpdateServlet.class);
        this.requestInjection((Object)this);
        if (this.configuration.get(Configuration.DEVELOPMENT_MODE).booleanValue()) {
            this.serveDevelopmentMode();
        } else {
            this.serveProductionMode();
        }
    }

    private void serveDevelopmentMode() {
        this.logger.info("Serving view components in DEVELOPMENT mode");
        DirectoryWatcher classWatcher = this.reloadConf == null ? new DirectoryWatcher((Collection)this.configuration.get(Configuration.VIEW_COMPONENT_ROOT_PACKAGE), this.classPattern) : new DirectoryWatcher(this.reloadConf.getReloadablePackageNames(), this.classPattern);
        DevelopmentFilter developmentFilter = new DevelopmentFilter(this.rootPackages, this.initHandler, this.initializerProvider, this.internalDevelopmentTools, classWatcher, this.properties, this.filter);
        this.filter("/*", new String[0]).through((Filter)developmentFilter);
        this.requestInjection(developmentFilter);
    }

    private void serveProductionMode() {
        this.logger.info("Serving view components in PRODUCTION mode");
        List<Class<?>> classes = ClassScanner.getClasses(this.rootPackages);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        UriMappingFactory fact = new UriMappingFactory();
        SortedSet<UriMapping> mappings = fact.createMappings(classes, classLoader, this.initializerProvider, this.initHandler, this.properties, this.filter);
        this.serveMappings(mappings);
    }

    private void serveMappings(SortedSet<UriMapping> mappings) {
        for (UriMapping mapping : mappings) {
            this.servlets.put(mapping.getViewClass().getCanonicalName(), mapping.getInitServlet());
            if (mapping instanceof RegexUriMapping) {
                this.logger.info("  Serving url: " + mapping.getViewClass().getName() + " => {} (regex)", (Object)mapping.getPath());
                this.serveRegex(mapping.getPath(), new String[0]).with((HttpServlet)mapping.getInitServlet());
                continue;
            }
            this.logger.info("  Serving url: " + mapping.getViewClass().getName() + " => {}", (Object)mapping.getPath());
            this.serve(mapping.getPath(), new String[0]).with((HttpServlet)mapping.getInitServlet());
        }
    }

    @Provides
    @Singleton
    public UpdateHandler provideUpdateHandler(LifecycleListener listeners, DirectoryWatcher watcher, ResourceCleaner cleaner, WebApplicationStorage storage, Gson gson) {
        return new UpdateHandler(listeners, watcher, cleaner, storage, this.configuration, this.pageScope, gson);
    }
}

