/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal;

import java.io.StringReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.internal.TransformersThreadLocal;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;

public class Transformers {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private boolean initialized = false;
    private TransformersThreadLocal transformers;

    public void initialize(Document xsltDocument) {
        try {
            this.transformers = new TransformersThreadLocal(FACTORY.newTemplates(new StreamSource(new StringReader(xsltDocument.asXML()))));
            this.initialized = true;
        }
        catch (TransformerConfigurationException e) {
            throw new WebApplicationException("Could not get transformer", e);
        }
    }

    public void invalidate() {
        this.initialized = false;
        this.transformers = null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Document transform(Document document) {
        if (this.initialized) {
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            Transformer tr = (Transformer)this.transformers.get();
            String lang = document.getRootElement().attributeValue("xml:lang");
            if (lang != null) {
                tr.setParameter("xml:lang", lang);
            }
            try {
                tr.transform((Source)source, (Result)result);
            }
            catch (TransformerException e) {
                throw new WebApplicationException(e);
            }
            return result.getDocument();
        }
        throw new WebApplicationException("Transformers are not initialized");
    }
}

