/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class MethodConstant
implements StackManipulation {
    private static final String CLASS_TYPE_INTERNAL_NAME = "java/lang/Class";
    protected final MethodDescription.InDefinedShape methodDescription;

    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        this.methodDescription = methodDescription;
    }

    public static CanCache forMethod(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(methodDescription);
    }

    private static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        ArrayList<StackManipulation> typeConstants = new ArrayList<StackManipulation>(parameterTypes.size());
        for (TypeDescription parameterType : parameterTypes) {
            typeConstants.add(ClassConstant.of(parameterType));
        }
        return typeConstants;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(this.preparation(), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply(methodVisitor, implementationContext);
    }

    protected abstract StackManipulation preparation();

    protected abstract MethodDescription accessorMethod();

    public StackManipulation cached() {
        return this.methodDescription.isConstructor() ? new CachedConstructor(this) : new CachedMethod(this);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((MethodConstant)other).methodDescription);
    }

    public int hashCode() {
        return this.methodDescription.hashCode();
    }

    protected static class CachedConstructor
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = new TypeDescription.ForLoadedType(Constructor.class);
        private final StackManipulation constructorConstant;

        protected CachedConstructor(StackManipulation constructorConstant) {
            this.constructorConstant = constructorConstant;
        }

        @Override
        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.constructorConstant.equals(((CachedConstructor)other).constructorConstant);
        }

        public int hashCode() {
            return 31 * this.constructorConstant.hashCode();
        }

        public String toString() {
            return "MethodConstant.CachedConstructor{constructorConstant=" + this.constructorConstant + '}';
        }
    }

    protected static class CachedMethod
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = new TypeDescription.ForLoadedType(Method.class);
        private final StackManipulation methodConstant;

        protected CachedMethod(StackManipulation methodConstant) {
            this.methodConstant = methodConstant;
        }

        @Override
        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodConstant.equals(((CachedMethod)other).methodConstant);
        }

        public int hashCode() {
            return 31 * this.methodConstant.hashCode();
        }

        public String toString() {
            return "MethodConstant.CachedMethod{methodConstant=" + this.methodConstant + '}';
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_DECLARED_CONSTRUCTOR = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredConstructor").and(ElementMatchers.takesArguments(Class[].class)))).getOnly();

        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return ClassConstant.of(this.methodDescription.getDeclaringType());
        }

        @Override
        protected MethodDescription accessorMethod() {
            return GET_DECLARED_CONSTRUCTOR;
        }

        public String toString() {
            return "MethodConstant.ForConstructor{methodDescription=" + this.methodDescription + '}';
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_DECLARED_METHOD = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();

        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), new TextConstant(this.methodDescription.getInternalName()));
        }

        @Override
        protected MethodDescription accessorMethod() {
            return GET_DECLARED_METHOD;
        }

        public String toString() {
            return "MethodConstant.ForMethod{methodDescription=" + this.methodDescription + '}';
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    protected static enum CanCacheIllegal implements CanCache
    {
        INSTANCE;


        @Override
        public StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }

        public String toString() {
            return "MethodConstant.CanCacheIllegal." + this.name();
        }
    }
}

