/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Default;
import net.bytebuddy.implementation.bind.annotation.DefaultCall;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.IgnoreForBinding;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.StubValue;
import net.bytebuddy.implementation.bind.annotation.Super;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;

public class TargetMethodAnnotationDrivenBinder
implements MethodDelegationBinder {
    private final DelegationProcessor delegationProcessor;
    private final DefaultsProvider defaultsProvider;
    private final TerminationHandler terminationHandler;
    private final Assigner assigner;
    private final MethodDelegationBinder.MethodInvoker methodInvoker;

    public TargetMethodAnnotationDrivenBinder(List<ParameterBinder<?>> parameterBinders, DefaultsProvider defaultsProvider, TerminationHandler terminationHandler, Assigner assigner, MethodDelegationBinder.MethodInvoker methodInvoker) {
        this.delegationProcessor = DelegationProcessor.of(parameterBinders);
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.methodInvoker = methodInvoker;
    }

    @Override
    public MethodDelegationBinder.MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, MethodDescription target) {
        if (IgnoreForBinding.Verifier.check(target)) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        StackManipulation methodTermination = this.terminationHandler.resolve(this.assigner, source, target);
        if (!methodTermination.isValid()) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        MethodDelegationBinder.MethodBinding.Builder methodDelegationBindingBuilder = new MethodDelegationBinder.MethodBinding.Builder(this.methodInvoker, target);
        Iterator<AnnotationDescription> defaults = this.defaultsProvider.makeIterator(implementationTarget, source, target);
        for (ParameterDescription parameterDescription : target.getParameters()) {
            MethodDelegationBinder.ParameterBinding<?> parameterBinding = this.delegationProcessor.handler(parameterDescription.getDeclaredAnnotations(), defaults).bind(source, parameterDescription, implementationTarget, this.assigner);
            if (parameterBinding.isValid() && methodDelegationBindingBuilder.append(parameterBinding)) continue;
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        return methodDelegationBindingBuilder.build(methodTermination);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetMethodAnnotationDrivenBinder that = (TargetMethodAnnotationDrivenBinder)other;
        return this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals((Object)that.terminationHandler) && this.delegationProcessor.equals(that.delegationProcessor) && this.methodInvoker.equals(that.methodInvoker);
    }

    public int hashCode() {
        int result = this.delegationProcessor.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.methodInvoker.hashCode();
        return result;
    }

    public String toString() {
        return "TargetMethodAnnotationDrivenBinder{delegationProcessor=" + this.delegationProcessor + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + ", assigner=" + this.assigner + ", methodInvoker=" + this.methodInvoker + '}';
    }

    protected static class DelegationProcessor {
        private final Map<TypeDescription, ParameterBinder<?>> parameterBinders;

        protected DelegationProcessor(Map<TypeDescription, ParameterBinder<?>> parameterBinders) {
            this.parameterBinders = parameterBinders;
        }

        protected static DelegationProcessor of(List<ParameterBinder<?>> parameterBinders) {
            HashMap parameterBinderMap = new HashMap();
            for (ParameterBinder<?> parameterBinder : parameterBinders) {
                if (parameterBinderMap.put(new TypeDescription.ForLoadedType(parameterBinder.getHandledType()), parameterBinder) == null) continue;
                throw new IllegalArgumentException("Attempt to bind two handlers to " + parameterBinder.getHandledType());
            }
            return new DelegationProcessor(parameterBinderMap);
        }

        private Handler handler(List<AnnotationDescription> annotations, Iterator<AnnotationDescription> defaults) {
            Handler handler = null;
            for (AnnotationDescription annotation : annotations) {
                ParameterBinder<?> parameterBinder = this.parameterBinders.get(annotation.getAnnotationType());
                if (parameterBinder != null && handler != null) {
                    throw new IllegalStateException("Ambiguous binding for parameter annotated with two handled annotation types");
                }
                if (parameterBinder == null) continue;
                handler = this.makeHandler(parameterBinder, annotation);
            }
            if (handler == null) {
                if (defaults.hasNext()) {
                    AnnotationDescription defaultAnnotation = defaults.next();
                    ParameterBinder<?> parameterBinder = this.parameterBinders.get(defaultAnnotation.getAnnotationType());
                    if (parameterBinder == null) {
                        return Handler.Unbound.INSTANCE;
                    }
                    handler = this.makeHandler(parameterBinder, defaultAnnotation);
                } else {
                    return Handler.Unbound.INSTANCE;
                }
            }
            return handler;
        }

        private Handler makeHandler(ParameterBinder<?> parameterBinder, AnnotationDescription annotation) {
            return new Handler.Bound(parameterBinder, annotation.prepare(parameterBinder.getHandledType()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinders.equals(((DelegationProcessor)other).parameterBinders);
        }

        public int hashCode() {
            return this.parameterBinders.hashCode();
        }

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.DelegationProcessor{parameterBinders=" + this.parameterBinders + '}';
        }

        protected static interface Handler {
            public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription var1, ParameterDescription var2, Implementation.Target var3, Assigner var4);

            public static class Bound<T extends Annotation>
            implements Handler {
                private final ParameterBinder<T> parameterBinder;
                private final AnnotationDescription.Loadable<T> annotation;

                public Bound(ParameterBinder<T> parameterBinder, AnnotationDescription.Loadable<T> annotation) {
                    this.parameterBinder = parameterBinder;
                    this.annotation = annotation;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                    return this.parameterBinder.bind(this.annotation, source, target, implementationTarget, assigner);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinder.equals(((Bound)other).parameterBinder) && this.annotation.equals(((Bound)other).annotation);
                }

                public int hashCode() {
                    int result = this.parameterBinder.hashCode();
                    result = 31 * result + this.annotation.hashCode();
                    return result;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Bound{parameterBinder=" + this.parameterBinder + ", annotation=" + this.annotation + '}';
                }
            }

            public static enum Unbound implements Handler
            {
                INSTANCE;


                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Unbound." + this.name();
                }
            }
        }
    }

    public static enum TerminationHandler {
        RETURNING{

            @Override
            protected StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return new StackManipulation.Compound(assigner.assign(target.isConstructor() ? target.getDeclaringType().asGenericType() : target.getReturnType(), source.getReturnType(), RuntimeType.Verifier.check(target)), MethodReturn.of(source.getReturnType()));
            }
        }
        ,
        DROPPING{

            @Override
            protected StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return Removal.of(target.isConstructor() ? target.getDeclaringType() : target.getReturnType());
            }
        };


        protected abstract StackManipulation resolve(Assigner var1, MethodDescription var2, MethodDescription var3);

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.TerminationHandler." + this.name();
        }
    }

    public static interface DefaultsProvider {
        public Iterator<AnnotationDescription> makeIterator(Implementation.Target var1, MethodDescription var2, MethodDescription var3);

        public static enum Empty implements DefaultsProvider
        {
            INSTANCE;


            @Override
            public Iterator<AnnotationDescription> makeIterator(Implementation.Target implementationTarget, MethodDescription source, MethodDescription target) {
                return EmptyIterator.INSTANCE;
            }

            public String toString() {
                return "TargetMethodAnnotationDrivenBinder.DefaultsProvider.Empty." + this.name();
            }

            protected static enum EmptyIterator implements Iterator<AnnotationDescription>
            {
                INSTANCE;


                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public AnnotationDescription next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DefaultsProvider.Empty.EmptyIterator." + this.name();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface ParameterBinder<T extends Annotation> {
        public static final List<ParameterBinder<?>> DEFAULTS = Collections.unmodifiableList(Arrays.asList(Argument.Binder.INSTANCE, AllArguments.Binder.INSTANCE, Origin.Binder.INSTANCE, This.Binder.INSTANCE, Super.Binder.INSTANCE, Default.Binder.INSTANCE, SuperCall.Binder.INSTANCE, DefaultCall.Binder.INSTANCE, FieldValue.Binder.INSTANCE, StubValue.Binder.INSTANCE, Empty.Binder.INSTANCE));

        public Class<T> getHandledType();

        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<T> var1, MethodDescription var2, ParameterDescription var3, Implementation.Target var4, Assigner var5);

        public static abstract class ForFieldBinding<S extends Annotation>
        implements ParameterBinder<S> {
            protected static final String BEAN_PROPERTY = "";

            private static FieldLocator.Resolution resolveAccessor(FieldLocator fieldLocator, MethodDescription methodDescription) {
                String fieldName;
                if (ElementMatchers.isSetter().matches(methodDescription)) {
                    fieldName = methodDescription.getInternalName().substring(3);
                } else if (ElementMatchers.isGetter().matches(methodDescription)) {
                    fieldName = methodDescription.getInternalName().substring(methodDescription.getInternalName().startsWith("is") ? 2 : 3);
                } else {
                    return FieldLocator.Resolution.Illegal.INSTANCE;
                }
                return fieldLocator.locate(Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1));
            }

            @Override
            public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<S> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                if (!this.declaringType(annotation).represents(Void.TYPE)) {
                    if (this.declaringType(annotation).isPrimitive() || this.declaringType(annotation).isArray()) {
                        throw new IllegalStateException("A primitive type or array type cannot declare a field: " + source);
                    }
                    if (!implementationTarget.getInstrumentedType().isAssignableTo(this.declaringType(annotation))) {
                        return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                    }
                }
                FieldLocator.AbstractBase fieldLocator = this.declaringType(annotation).represents(Void.TYPE) ? new FieldLocator.ForClassHierarchy(implementationTarget.getInstrumentedType()) : new FieldLocator.ForExactType(this.declaringType(annotation), implementationTarget.getInstrumentedType());
                FieldLocator.Resolution resolution = this.fieldName(annotation).equals(BEAN_PROPERTY) ? ForFieldBinding.resolveAccessor(fieldLocator, source) : fieldLocator.locate(this.fieldName(annotation));
                return resolution.isResolved() && (!source.isStatic() || resolution.getField().isStatic()) ? this.bind(resolution.getField(), annotation, source, target, implementationTarget, assigner) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }

            protected abstract String fieldName(AnnotationDescription.Loadable<S> var1);

            protected abstract TypeDescription declaringType(AnnotationDescription.Loadable<S> var1);

            protected abstract MethodDelegationBinder.ParameterBinding<?> bind(FieldDescription var1, AnnotationDescription.Loadable<S> var2, MethodDescription var3, ParameterDescription var4, Implementation.Target var5, Assigner var6);
        }

        public static abstract class ForFixedValue<S extends Annotation>
        implements ParameterBinder<S> {
            @Override
            public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<S> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                TypeDescription suppliedType;
                StackManipulation stackManipulation;
                Object value = this.bind(annotation, source, target);
                if (value == null) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(DefaultValue.of(target.getType()));
                }
                if (value instanceof Boolean) {
                    stackManipulation = IntegerConstant.forValue((Boolean)value);
                    suppliedType = new TypeDescription.ForLoadedType(Boolean.TYPE);
                } else if (value instanceof Byte) {
                    stackManipulation = IntegerConstant.forValue(((Byte)value).byteValue());
                    suppliedType = new TypeDescription.ForLoadedType(Byte.TYPE);
                } else if (value instanceof Short) {
                    stackManipulation = IntegerConstant.forValue(((Short)value).shortValue());
                    suppliedType = new TypeDescription.ForLoadedType(Short.TYPE);
                } else if (value instanceof Character) {
                    stackManipulation = IntegerConstant.forValue(((Character)value).charValue());
                    suppliedType = new TypeDescription.ForLoadedType(Character.TYPE);
                } else if (value instanceof Integer) {
                    stackManipulation = IntegerConstant.forValue((Integer)value);
                    suppliedType = new TypeDescription.ForLoadedType(Integer.TYPE);
                } else if (value instanceof Long) {
                    stackManipulation = LongConstant.forValue((Long)value);
                    suppliedType = new TypeDescription.ForLoadedType(Long.TYPE);
                } else if (value instanceof Float) {
                    stackManipulation = FloatConstant.forValue(((Float)value).floatValue());
                    suppliedType = new TypeDescription.ForLoadedType(Float.TYPE);
                } else if (value instanceof Double) {
                    stackManipulation = DoubleConstant.forValue((Double)value);
                    suppliedType = new TypeDescription.ForLoadedType(Double.TYPE);
                } else if (value instanceof String) {
                    stackManipulation = new TextConstant((String)value);
                    suppliedType = TypeDescription.STRING;
                } else if (value instanceof Class) {
                    stackManipulation = ClassConstant.of(new TypeDescription.ForLoadedType((Class)value));
                    suppliedType = TypeDescription.CLASS;
                } else if (value instanceof TypeDescription) {
                    stackManipulation = ClassConstant.of((TypeDescription)value);
                    suppliedType = TypeDescription.CLASS;
                } else if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                    stackManipulation = JavaConstant.MethodHandle.ofLoaded(value).asStackManipulation();
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (value instanceof JavaConstant.MethodHandle) {
                    stackManipulation = new JavaConstantValue((JavaConstant.MethodHandle)value);
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                    stackManipulation = new JavaConstantValue(JavaConstant.MethodType.ofLoaded(value));
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (value instanceof JavaConstant.MethodType) {
                    stackManipulation = new JavaConstantValue((JavaConstant.MethodType)value);
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else {
                    throw new IllegalStateException("Not able to save in class's constant pool: " + value);
                }
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new StackManipulation.Compound(stackManipulation, assigner.assign(suppliedType.asGenericType(), target.getType(), Assigner.Typing.STATIC)));
            }

            protected abstract Object bind(AnnotationDescription.Loadable<S> var1, MethodDescription var2, ParameterDescription var3);

            public static class OfConstant<U extends Annotation>
            extends ForFixedValue<U> {
                private final Class<U> type;
                private final Object value;

                protected OfConstant(Class<U> type, Object value) {
                    this.type = type;
                    this.value = value;
                }

                public static <V extends Annotation> ParameterBinder<V> of(Class<V> type, Object value) {
                    return new OfConstant<V>(type, value);
                }

                @Override
                public Class<U> getHandledType() {
                    return this.type;
                }

                @Override
                protected Object bind(AnnotationDescription.Loadable<U> annotation, MethodDescription source, ParameterDescription target) {
                    return this.value;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    OfConstant that = (OfConstant)object;
                    return this.type.equals(that.type) && (this.value != null ? this.value.equals(that.value) : that.value == null);
                }

                public int hashCode() {
                    int result = this.type.hashCode();
                    result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                    return result;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.ParameterBinder.ForFixedValue.OfConstant{type=" + this.type + ", value=" + this.value + '}';
                }
            }
        }
    }
}

