/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.auxiliary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.Throw;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class TypeProxy
implements AuxiliaryType {
    public static final String REFLECTION_METHOD = "make";
    public static final String INSTANCE_FIELD = "target";
    private final TypeDescription proxiedType;
    private final Implementation.Target implementationTarget;
    private final InvocationFactory invocationFactory;
    private final boolean ignoreFinalizer;
    private final boolean serializableProxy;

    public TypeProxy(TypeDescription proxiedType, Implementation.Target implementationTarget, InvocationFactory invocationFactory, boolean ignoreFinalizer, boolean serializableProxy) {
        this.proxiedType = proxiedType;
        this.implementationTarget = implementationTarget;
        this.invocationFactory = invocationFactory;
        this.ignoreFinalizer = ignoreFinalizer;
        this.serializableProxy = serializableProxy;
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        Type[] typeArray;
        DynamicType.Builder builder = new ByteBuddy(classFileVersion).ignore(this.ignoreFinalizer ? ElementMatchers.isFinalizer() : ElementMatchers.none()).subclass(this.proxiedType).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER);
        if (this.serializableProxy) {
            Class[] classArray = new Class[1];
            typeArray = classArray;
            classArray[0] = Serializable.class;
        } else {
            typeArray = new Class[]{};
        }
        return builder.implement(typeArray).method(ElementMatchers.any()).intercept(new MethodCall(methodAccessorFactory)).defineMethod(REFLECTION_METHOD, (Type)((Object)TargetType.class), Ownership.STATIC).intercept(SilentConstruction.INSTANCE).make();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypeProxy typeProxy = (TypeProxy)other;
        return this.ignoreFinalizer == typeProxy.ignoreFinalizer && this.serializableProxy == typeProxy.serializableProxy && this.implementationTarget.equals(typeProxy.implementationTarget) && this.invocationFactory.equals(typeProxy.invocationFactory) && this.proxiedType.equals(typeProxy.proxiedType);
    }

    public int hashCode() {
        int result = this.proxiedType.hashCode();
        result = 31 * result + this.implementationTarget.hashCode();
        result = 31 * result + this.invocationFactory.hashCode();
        result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
        result = 31 * result + (this.serializableProxy ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TypeProxy{proxiedType=" + this.proxiedType + ", implementationTarget=" + this.implementationTarget + ", invocationFactory=" + this.invocationFactory + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
    }

    protected class MethodCall
    implements Implementation {
        private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;

        protected MethodCall(AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
            this.methodAccessorFactory = methodAccessorFactory;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(TypeProxy.INSTANCE_FIELD, 4096, TypeProxy.this.implementationTarget.getInstrumentedType().asGenericType()));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        private TypeProxy getTypeProxy() {
            return TypeProxy.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodAccessorFactory.equals(((MethodCall)other).methodAccessorFactory) && TypeProxy.this.equals(((MethodCall)other).getTypeProxy());
        }

        public int hashCode() {
            return 31 * TypeProxy.this.hashCode() + this.methodAccessorFactory.hashCode();
        }

        public String toString() {
            return "TypeProxy.MethodCall{typeProxy=" + TypeProxy.this + "methodAccessorFactory=" + this.methodAccessorFactory + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final StackManipulation fieldLoadingInstruction;

            protected Appender(TypeDescription instrumentedType) {
                this.fieldLoadingInstruction = FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).read();
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                Implementation.SpecialMethodInvocation specialMethodInvocation = TypeProxy.this.invocationFactory.invoke(TypeProxy.this.implementationTarget, TypeProxy.this.proxiedType, instrumentedMethod);
                StackManipulation.Size size = (specialMethodInvocation.isValid() ? new AccessorMethodInvocation(instrumentedMethod, specialMethodInvocation) : AbstractMethodErrorThrow.INSTANCE).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldLoadingInstruction.equals(((Appender)other).fieldLoadingInstruction) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.fieldLoadingInstruction.hashCode();
            }

            public String toString() {
                return "TypeProxy.MethodCall.Appender{methodCall=" + MethodCall.this + "fieldLoadingInstruction=" + this.fieldLoadingInstruction + '}';
            }

            protected class AccessorMethodInvocation
            implements StackManipulation {
                private final MethodDescription instrumentedMethod;
                private final Implementation.SpecialMethodInvocation specialMethodInvocation;

                protected AccessorMethodInvocation(MethodDescription instrumentedMethod, Implementation.SpecialMethodInvocation specialMethodInvocation) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.specialMethodInvocation = specialMethodInvocation;
                }

                @Override
                public boolean isValid() {
                    return this.specialMethodInvocation.isValid();
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    MethodDescription.InDefinedShape proxyMethod = MethodCall.this.methodAccessorFactory.registerAccessorFor(this.specialMethodInvocation);
                    return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(0), Appender.this.fieldLoadingInstruction, MethodVariableAccess.allArgumentsOf(this.instrumentedMethod).asBridgeOf(proxyMethod), MethodInvocation.invoke(proxyMethod), MethodReturn.of(this.instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
                }

                private Appender getAppender() {
                    return Appender.this;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    AccessorMethodInvocation that = (AccessorMethodInvocation)other;
                    return Appender.this.equals(that.getAppender()) && this.instrumentedMethod.equals(that.instrumentedMethod) && this.specialMethodInvocation.equals(that.specialMethodInvocation);
                }

                public int hashCode() {
                    int result = Appender.this.hashCode();
                    result = 31 * result + this.instrumentedMethod.hashCode();
                    result = 31 * result + this.specialMethodInvocation.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypeProxy.MethodCall.Appender.AccessorMethodInvocation{appender=" + Appender.this + ", instrumentedMethod=" + this.instrumentedMethod + ", specialMethodInvocation=" + this.specialMethodInvocation + '}';
                }
            }
        }
    }

    public static class ForDefaultMethod
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Implementation.Target implementationTarget;
        private final boolean serializableProxy;

        public ForDefaultMethod(TypeDescription proxiedType, Implementation.Target implementationTarget, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.implementationTarget = implementationTarget;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription proxyType = implementationContext.register(new TypeProxy(this.proxiedType, this.implementationTarget, InvocationFactory.Default.DEFAULT_METHOD, true, this.serializableProxy));
            return new StackManipulation.Compound(TypeCreation.of(proxyType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), Duplication.SINGLE, MethodVariableAccess.of(this.implementationTarget.getInstrumentedType()).loadFrom(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).write()).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForDefaultMethod that = (ForDefaultMethod)other;
            return this.serializableProxy == that.serializableProxy && this.implementationTarget.equals(that.implementationTarget) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForDefaultMethod{proxiedType=" + this.proxiedType + ", implementationTarget=" + this.implementationTarget + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static class ForSuperMethodByReflectionFactory
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Implementation.Target implementationTarget;
        private final boolean ignoreFinalizer;
        private final boolean serializableProxy;

        public ForSuperMethodByReflectionFactory(TypeDescription proxiedType, Implementation.Target implementationTarget, boolean ignoreFinalizer, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.implementationTarget = implementationTarget;
            this.ignoreFinalizer = ignoreFinalizer;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription proxyType = implementationContext.register(new TypeProxy(this.proxiedType, this.implementationTarget, InvocationFactory.Default.SUPER_METHOD, this.ignoreFinalizer, this.serializableProxy));
            return new StackManipulation.Compound(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.named(TypeProxy.REFLECTION_METHOD).and(ElementMatchers.takesArguments(0)))).getOnly()), Duplication.SINGLE, MethodVariableAccess.of(this.implementationTarget.getInstrumentedType()).loadFrom(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).write()).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForSuperMethodByReflectionFactory that = (ForSuperMethodByReflectionFactory)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.implementationTarget.equals(that.implementationTarget) && this.proxiedType.equals(that.proxiedType) && this.serializableProxy == that.serializableProxy;
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForSuperMethodByReflectionFactory{proxiedType=" + this.proxiedType + ", implementationTarget=" + this.implementationTarget + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static class ForSuperMethodByConstructor
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Implementation.Target implementationTarget;
        private final List<TypeDescription> constructorParameters;
        private final boolean ignoreFinalizer;
        private final boolean serializableProxy;

        public ForSuperMethodByConstructor(TypeDescription proxiedType, Implementation.Target implementationTarget, List<TypeDescription> constructorParameters, boolean ignoreFinalizer, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.implementationTarget = implementationTarget;
            this.constructorParameters = constructorParameters;
            this.ignoreFinalizer = ignoreFinalizer;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription proxyType = implementationContext.register(new TypeProxy(this.proxiedType, this.implementationTarget, InvocationFactory.Default.SUPER_METHOD, this.ignoreFinalizer, this.serializableProxy));
            StackManipulation[] constructorValue = new StackManipulation[this.constructorParameters.size()];
            int index = 0;
            for (TypeDescription parameterType : this.constructorParameters) {
                constructorValue[index++] = DefaultValue.of(parameterType);
            }
            return new StackManipulation.Compound(TypeCreation.of(proxyType), Duplication.SINGLE, new StackManipulation.Compound(constructorValue), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(this.constructorParameters)))).getOnly()), Duplication.SINGLE, MethodVariableAccess.of(this.implementationTarget.getInstrumentedType()).loadFrom(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).write()).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForSuperMethodByConstructor that = (ForSuperMethodByConstructor)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.serializableProxy == that.serializableProxy && this.constructorParameters.equals(that.constructorParameters) && this.implementationTarget.equals(that.implementationTarget) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + this.constructorParameters.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForSuperMethodByConstructor{proxiedType=" + this.proxiedType + ", implementationTarget=" + this.implementationTarget + ", constructorParameters=" + this.constructorParameters + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static interface InvocationFactory {
        public Implementation.SpecialMethodInvocation invoke(Implementation.Target var1, TypeDescription var2, MethodDescription var3);

        public static enum Default implements InvocationFactory
        {
            SUPER_METHOD{

                @Override
                public Implementation.SpecialMethodInvocation invoke(Implementation.Target implementationTarget, TypeDescription proxiedType, MethodDescription instrumentedMethod) {
                    return implementationTarget.invokeDominant(instrumentedMethod.asSignatureToken());
                }
            }
            ,
            DEFAULT_METHOD{

                @Override
                public Implementation.SpecialMethodInvocation invoke(Implementation.Target implementationTarget, TypeDescription proxiedType, MethodDescription instrumentedMethod) {
                    return implementationTarget.invokeDefault(proxiedType, instrumentedMethod.asSignatureToken());
                }
            };


            public String toString() {
                return "TypeProxy.InvocationFactory.Default." + this.name();
            }
        }
    }

    protected static enum SilentConstruction implements Implementation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        public String toString() {
            return "TypeProxy.SilentConstruction." + this.name();
        }

        protected static class Appender
        implements ByteCodeAppender {
            public static final String REFLECTION_FACTORY_INTERNAL_NAME = "sun/reflect/ReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_NAME = "getReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR = "()Lsun/reflect/ReflectionFactory;";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME = "newConstructorForSerialization";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR = "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;)Ljava/lang/reflect/Constructor;";
            public static final String JAVA_LANG_OBJECT_DESCRIPTOR = "Ljava/lang/Object;";
            public static final String JAVA_LANG_OBJECT_INTERNAL_NAME = "java/lang/Object";
            public static final String JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME = "java/lang/reflect/Constructor";
            public static final String NEW_INSTANCE_METHOD_NAME = "newInstance";
            public static final String NEW_INSTANCE_METHOD_DESCRIPTOR = "([Ljava/lang/Object;)Ljava/lang/Object;";
            public static final String JAVA_LANG_CLASS_INTERNAL_NAME = "java/lang/Class";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_NAME = "getDeclaredConstructor";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR = "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;";
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitMethodInsn(184, REFLECTION_FACTORY_INTERNAL_NAME, GET_REFLECTION_FACTORY_METHOD_NAME, GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR, false);
                methodVisitor.visitLdcInsn(net.bytebuddy.jar.asm.Type.getType(this.instrumentedType.getDescriptor()));
                methodVisitor.visitLdcInsn(net.bytebuddy.jar.asm.Type.getType(JAVA_LANG_OBJECT_DESCRIPTOR));
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_CLASS_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CLASS_INTERNAL_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR, false);
                methodVisitor.visitMethodInsn(182, REFLECTION_FACTORY_INTERNAL_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR, false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_OBJECT_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME, NEW_INSTANCE_METHOD_NAME, NEW_INSTANCE_METHOD_DESCRIPTOR, false);
                methodVisitor.visitTypeInsn(192, this.instrumentedType.getInternalName());
                methodVisitor.visitInsn(176);
                return new ByteCodeAppender.Size(4, 0);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "TypeProxy.SilentConstruction.Appender{instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum AbstractMethodErrorThrow implements StackManipulation
    {
        INSTANCE;

        private final StackManipulation implementation;

        @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"}, justification="Fields of enumerations are never serialized")
        private AbstractMethodErrorThrow() {
            TypeDescription.ForLoadedType abstractMethodError = new TypeDescription.ForLoadedType(AbstractMethodError.class);
            MethodDescription constructor = (MethodDescription)((MethodList)abstractMethodError.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly();
            this.implementation = new StackManipulation.Compound(TypeCreation.of(abstractMethodError), Duplication.SINGLE, MethodInvocation.invoke(constructor), Throw.INSTANCE);
        }

        @Override
        public boolean isValid() {
            return this.implementation.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return this.implementation.apply(methodVisitor, implementationContext);
        }

        public String toString() {
            return "TypeProxy.AbstractMethodErrorThrow." + this.name();
        }
    }
}

