/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface ByteCodeAppender {
    public Size apply(MethodVisitor var1, Implementation.Context var2, MethodDescription var3);

    public static class Simple
    implements ByteCodeAppender {
        private final StackManipulation stackManipulation;

        public Simple(StackManipulation ... stackManipulation) {
            this.stackManipulation = new StackManipulation.Compound(stackManipulation);
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return new Size(this.stackManipulation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.stackManipulation.equals(((Simple)other).stackManipulation);
        }

        public int hashCode() {
            return this.stackManipulation.hashCode();
        }

        public String toString() {
            return "ByteCodeAppender.Simple{stackManipulation=" + this.stackManipulation + '}';
        }
    }

    public static class Compound
    implements ByteCodeAppender {
        private final List<? extends ByteCodeAppender> byteCodeAppenders;

        public Compound(ByteCodeAppender ... byteCodeAppender) {
            this(Arrays.asList(byteCodeAppender));
        }

        public Compound(List<? extends ByteCodeAppender> byteCodeAppenders) {
            this.byteCodeAppenders = byteCodeAppenders;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Size size = new Size(0, instrumentedMethod.getStackSize());
            for (ByteCodeAppender byteCodeAppender : this.byteCodeAppenders) {
                size = size.merge(byteCodeAppender.apply(methodVisitor, implementationContext, instrumentedMethod));
            }
            return size;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppenders.equals(((Compound)other).byteCodeAppenders);
        }

        public int hashCode() {
            return this.byteCodeAppenders.hashCode();
        }

        public String toString() {
            return "ByteCodeAppender.Compound{byteCodeAppenders=" + this.byteCodeAppenders + '}';
        }
    }

    public static class Size {
        private final int operandStackSize;
        private final int localVariableSize;

        public Size(int operandStackSize, int localVariableSize) {
            this.operandStackSize = operandStackSize;
            this.localVariableSize = localVariableSize;
        }

        public int getOperandStackSize() {
            return this.operandStackSize;
        }

        public int getLocalVariableSize() {
            return this.localVariableSize;
        }

        public Size merge(Size other) {
            return new Size(Math.max(this.operandStackSize, other.operandStackSize), Math.max(this.localVariableSize, other.localVariableSize));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.localVariableSize == ((Size)other).localVariableSize && this.operandStackSize == ((Size)other).operandStackSize;
        }

        public int hashCode() {
            return 31 * this.operandStackSize + this.localVariableSize;
        }

        public String toString() {
            return "ByteCodeAppender.Size{operandStackSize=" + this.operandStackSize + ", localVariableSize=" + this.localVariableSize + '}';
        }
    }
}

