/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.TypeVariableSource;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.TypeVariableToken;
import net.bytebuddy.jar.asm.signature.SignatureWriter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;

public interface MethodDescription
extends TypeVariableSource,
NamedElement.WithGenericName,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final String CONSTRUCTOR_INTERNAL_NAME = "<init>";
    public static final String TYPE_INITIALIZER_INTERNAL_NAME = "<clinit>";
    public static final int TYPE_INITIALIZER_MODIFIER = 4106;
    public static final Object NO_DEFAULT_VALUE = null;
    public static final MethodDescription UNDEFINED = null;

    public TypeDescription.Generic getReturnType();

    public ParameterList<?> getParameters();

    public TypeList.Generic getExceptionTypes();

    public int getAdjustedModifiers(boolean var1);

    public boolean isConstructor();

    public boolean isMethod();

    public boolean isTypeInitializer();

    public boolean represents(Method var1);

    public boolean represents(Constructor<?> var1);

    public boolean isVirtual();

    public int getStackSize();

    public boolean isDefaultMethod();

    public boolean isSpecializableFor(TypeDescription var1);

    public Object getDefaultValue();

    public <T> T getDefaultValue(Class<T> var1);

    public boolean isInvokableOn(TypeDescription var1);

    public boolean isBootstrap();

    public boolean isBootstrap(List<?> var1);

    public boolean isDefaultValue();

    public boolean isDefaultValue(Object var1);

    public TypeDescription.Generic getReceiverType();

    public SignatureToken asSignatureToken();

    public TypeToken asTypeToken();

    public static class TypeToken {
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        public TypeToken(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TypeToken typeToken = (TypeToken)other;
            return this.returnType.equals(typeToken.returnType) && this.parameterTypes.equals(typeToken.parameterTypes);
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDescription.TypeToken{returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }
    }

    public static class SignatureToken {
        private final String name;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        public SignatureToken(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        public TypeToken asTypeToken() {
            return new TypeToken(this.returnType, this.parameterTypes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SignatureToken signatureToken = (SignatureToken)other;
            return this.name.equals(signatureToken.name) && this.returnType.equals(signatureToken.returnType) && this.parameterTypes.equals(signatureToken.parameterTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDescription.SignatureToken{name='" + this.name + "'" + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }
    }

    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String name;
        private final int modifiers;
        private final List<? extends TypeVariableToken> typeVariables;
        private final TypeDescription.Generic returnType;
        private final List<? extends ParameterDescription.Token> parameterTokens;
        private final List<? extends TypeDescription.Generic> exceptionTypes;
        private final List<? extends AnnotationDescription> annotations;
        private final Object defaultValue;

        public Token(int modifiers) {
            this(MethodDescription.CONSTRUCTOR_INTERNAL_NAME, modifiers, TypeDescription.Generic.VOID);
        }

        public Token(String name, int modifiers, TypeDescription.Generic returnType) {
            this(name, modifiers, returnType, Collections.emptyList());
        }

        public Token(String name, int modifiers, TypeDescription.Generic returnType, List<? extends TypeDescription.Generic> parameterTypes) {
            this(name, modifiers, Collections.emptyList(), returnType, new ParameterDescription.Token.TypeList(parameterTypes), Collections.emptyList(), Collections.emptyList(), NO_DEFAULT_VALUE);
        }

        public Token(String name, int modifiers, List<? extends TypeVariableToken> typeVariables, TypeDescription.Generic returnType, List<? extends ParameterDescription.Token> parameterTokens, List<? extends TypeDescription.Generic> exceptionTypes, List<? extends AnnotationDescription> annotations, Object defaultValue) {
            this.name = name;
            this.modifiers = modifiers;
            this.typeVariables = typeVariables;
            this.returnType = returnType;
            this.parameterTokens = parameterTokens;
            this.exceptionTypes = exceptionTypes;
            this.annotations = annotations;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public ByteCodeElement.Token.TokenList<TypeVariableToken> getTypeVariableTokens() {
            return new ByteCodeElement.Token.TokenList<TypeVariableToken>(this.typeVariables);
        }

        public TypeDescription.Generic getReturnType() {
            return this.returnType;
        }

        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> getParameterTokens() {
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(this.parameterTokens);
        }

        public TypeList.Generic getExceptionTypes() {
            return new TypeList.Generic.Explicit(this.exceptionTypes);
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            return new Token(this.name, this.modifiers, this.getTypeVariableTokens().accept(visitor), this.returnType.accept(visitor), this.getParameterTokens().accept(visitor), this.getExceptionTypes().accept(visitor), this.annotations, this.defaultValue);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Token token = (Token)other;
            return this.modifiers == token.modifiers && this.name.equals(token.name) && this.typeVariables.equals(token.typeVariables) && this.returnType.equals(token.returnType) && this.parameterTokens.equals(token.parameterTokens) && this.exceptionTypes.equals(token.exceptionTypes) && this.annotations.equals(token.annotations) && (this.defaultValue != null ? this.defaultValue.equals(token.defaultValue) : token.defaultValue == null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.modifiers;
            result = 31 * result + this.typeVariables.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTokens.hashCode();
            result = 31 * result + this.exceptionTypes.hashCode();
            result = 31 * result + this.annotations.hashCode();
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "MethodDescription.Token{name='" + this.name + '\'' + ", modifiers=" + this.modifiers + ", typeVariables=" + this.typeVariables + ", returnType=" + this.returnType + ", parameterTokens=" + this.parameterTokens + ", exceptionTypes=" + this.exceptionTypes + ", annotations=" + this.annotations + ", defaultValue=" + this.defaultValue + '}';
        }
    }

    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final TypeDescription.Generic declaringType;
        private final MethodDescription methodDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(TypeDescription.Generic declaringType, MethodDescription methodDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            this.declaringType = declaringType;
            this.methodDescription = methodDescription;
            this.visitor = visitor;
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return new TypeList.Generic.ForDetachedTypes(this.methodDescription.getTypeVariables(), this.visitor);
        }

        @Override
        public TypeDescription.Generic getReturnType() {
            return this.methodDescription.getReturnType().accept(this.visitor);
        }

        @Override
        public ParameterList<ParameterDescription.InGenericShape> getParameters() {
            return new ParameterList.TypeSubstituting(this, this.methodDescription.getParameters(), this.visitor);
        }

        @Override
        public TypeList.Generic getExceptionTypes() {
            return new TypeList.Generic.ForDetachedTypes(this.methodDescription.getExceptionTypes(), this.visitor);
        }

        @Override
        public Object getDefaultValue() {
            return this.methodDescription.getDefaultValue();
        }

        @Override
        public TypeDescription.Generic getReceiverType() {
            TypeDescription.Generic receiverType = this.methodDescription.getReceiverType();
            return receiverType == null ? TypeDescription.Generic.UNDEFINED : receiverType.accept(this.visitor);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.methodDescription.getDeclaredAnnotations();
        }

        @Override
        public TypeDescription.Generic getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.methodDescription.getModifiers();
        }

        @Override
        public String getInternalName() {
            return this.methodDescription.getInternalName();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.methodDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String internalName;
        private final int modifiers;
        private final List<? extends TypeVariableToken> typeVariables;
        private final TypeDescription.Generic returnType;
        private final List<? extends ParameterDescription.Token> parameterTokens;
        private final List<? extends TypeDescription.Generic> exceptionTypes;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        private final Object defaultValue;

        public Latent(TypeDescription declaringType, Token token) {
            this(declaringType, token.getName(), token.getModifiers(), token.getTypeVariableTokens(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), token.getDefaultValue());
        }

        public Latent(TypeDescription declaringType, String internalName, int modifiers, List<? extends TypeVariableToken> typeVariables, TypeDescription.Generic returnType, List<? extends ParameterDescription.Token> parameterTokens, List<? extends TypeDescription.Generic> exceptionTypes, List<? extends AnnotationDescription> declaredAnnotations, Object defaultValue) {
            this.declaringType = declaringType;
            this.internalName = internalName;
            this.modifiers = modifiers;
            this.typeVariables = typeVariables;
            this.returnType = returnType;
            this.parameterTokens = parameterTokens;
            this.exceptionTypes = exceptionTypes;
            this.declaredAnnotations = declaredAnnotations;
            this.defaultValue = defaultValue;
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return TypeList.Generic.ForDetachedTypes.attachVariables(this, this.typeVariables);
        }

        @Override
        public TypeDescription.Generic getReturnType() {
            return this.returnType.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return new ParameterList.ForTokens(this, this.parameterTokens);
        }

        @Override
        public TypeList.Generic getExceptionTypes() {
            return TypeList.Generic.ForDetachedTypes.attach(this, this.exceptionTypes);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public static class TypeInitializer
        extends InDefinedShape.AbstractBase {
            private final TypeDescription typeDescription;

            public TypeInitializer(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public TypeDescription.Generic getReturnType() {
                return TypeDescription.Generic.VOID;
            }

            @Override
            public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                return new ParameterList.Empty<ParameterDescription.InDefinedShape>();
            }

            @Override
            public TypeList.Generic getExceptionTypes() {
                return new TypeList.Generic.Empty();
            }

            @Override
            public Object getDefaultValue() {
                return NO_DEFAULT_VALUE;
            }

            @Override
            public TypeList.Generic getTypeVariables() {
                return new TypeList.Generic.Empty();
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Empty();
            }

            @Override
            public TypeDescription getDeclaringType() {
                return this.typeDescription;
            }

            @Override
            public int getModifiers() {
                return 4106;
            }

            @Override
            public String getInternalName() {
                return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME;
            }
        }
    }

    public static class ForLoadedMethod
    extends InDefinedShape.AbstractBase {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.method.getDeclaringClass());
        }

        @Override
        public TypeDescription.Generic getReturnType() {
            return new TypeDescription.Generic.LazyProjection.ForLoadedReturnType(this.method);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.method);
        }

        @Override
        public TypeList.Generic getExceptionTypes() {
            return new TypeList.Generic.OfMethodExceptionTypes(this.method);
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }

        @Override
        public boolean represents(Method method) {
            return this.method.equals(method) || this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.method.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return this.method.getName();
        }

        @Override
        public String getDescriptor() {
            return net.bytebuddy.jar.asm.Type.getMethodDescriptor(this.method);
        }

        public Method getLoadedMethod() {
            return this.method;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.method.getDeclaredAnnotations());
        }

        @Override
        public Object getDefaultValue() {
            Object value = this.method.getDefaultValue();
            return value == null ? NO_DEFAULT_VALUE : AnnotationDescription.ForLoadedAnnotation.describe(value, new TypeDescription.ForLoadedType(this.method.getReturnType()));
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return TypeList.Generic.ForLoadedTypes.OfTypeVariables.of(this.method);
        }

        @Override
        public TypeDescription.Generic getReceiverType() {
            TypeDescription.Generic receiverType = TypeDescription.Generic.AnnotationReader.DISPATCHER.resolveReceiverType(this.method);
            return receiverType == null ? super.getReceiverType() : receiverType;
        }
    }

    public static class ForLoadedConstructor
    extends InDefinedShape.AbstractBase {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.constructor.getDeclaringClass());
        }

        @Override
        public TypeDescription.Generic getReturnType() {
            return TypeDescription.Generic.VOID;
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.constructor);
        }

        @Override
        public TypeList.Generic getExceptionTypes() {
            return new TypeList.Generic.OfConstructorExceptionTypes(this.constructor);
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.constructor.equals(constructor) || this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.constructor.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME;
        }

        @Override
        public String getDescriptor() {
            return net.bytebuddy.jar.asm.Type.getConstructorDescriptor(this.constructor);
        }

        @Override
        public Object getDefaultValue() {
            return NO_DEFAULT_VALUE;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.constructor.getDeclaredAnnotations());
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return TypeList.Generic.ForLoadedTypes.OfTypeVariables.of(this.constructor);
        }

        @Override
        public TypeDescription.Generic getReceiverType() {
            TypeDescription.Generic receiverType = TypeDescription.Generic.AnnotationReader.DISPATCHER.resolveReceiverType(this.constructor);
            return receiverType == null ? super.getReceiverType() : receiverType;
        }
    }

    public static abstract class AbstractBase
    extends TypeVariableSource.AbstractBase
    implements MethodDescription {
        private static final int SOURCE_MODIFIERS = 1343;

        @Override
        public int getStackSize() {
            return this.getParameters().asTypeList().getStackSize() + (this.isStatic() ? 0 : 1);
        }

        @Override
        public boolean isMethod() {
            return !this.isConstructor() && !this.isTypeInitializer();
        }

        @Override
        public boolean isConstructor() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean isTypeInitializer() {
            return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean represents(Method method) {
            return this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.isMethod() ? this.getInternalName() : this.getDeclaringType().asErasure().getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.isMethod() ? this.getName() : "";
        }

        @Override
        public String getDescriptor() {
            StringBuilder descriptor = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameters().asTypeList().asErasures()) {
                descriptor.append(parameterType.getDescriptor());
            }
            return descriptor.append(")").append(this.getReturnType().asErasure().getDescriptor()).toString();
        }

        @Override
        public String getGenericSignature() {
            try {
                SignatureWriter signatureWriter = new SignatureWriter();
                boolean generic = false;
                for (TypeDescription.Generic typeVariable : this.getTypeVariables()) {
                    signatureWriter.visitFormalTypeParameter(typeVariable.getSymbol());
                    boolean classBound = true;
                    for (TypeDescription.Generic upperBound : typeVariable.getUpperBounds()) {
                        upperBound.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(classBound ? signatureWriter.visitClassBound() : signatureWriter.visitInterfaceBound()));
                        classBound = false;
                    }
                    generic = true;
                }
                for (TypeDescription.Generic parameterType : this.getParameters().asTypeList()) {
                    parameterType.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(signatureWriter.visitParameterType()));
                    generic = generic || !parameterType.getSort().isNonGeneric();
                }
                TypeDescription.Generic returnType = this.getReturnType();
                returnType.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(signatureWriter.visitReturnType()));
                generic = generic || !returnType.getSort().isNonGeneric();
                TypeList.Generic exceptionTypes = this.getExceptionTypes();
                if (!((TypeList.Generic)exceptionTypes.filter(ElementMatchers.not(ElementMatchers.ofSort(TypeDefinition.Sort.NON_GENERIC)))).isEmpty()) {
                    for (TypeDescription.Generic exceptionType : exceptionTypes) {
                        exceptionType.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(signatureWriter.visitExceptionType()));
                        generic = generic || !exceptionType.getSort().isNonGeneric();
                    }
                }
                return generic ? signatureWriter.toString() : NON_GENERIC_SIGNATURE;
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public int getAdjustedModifiers(boolean nonAbstract) {
            return nonAbstract ? this.getModifiers() & 0xFFFFFAFF : this.getModifiers() & 0xFFFFFEFF | 0x400;
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return (this.isVirtual() || this.getDeclaringType().asErasure().isVisibleTo(typeDescription)) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType().asErasure()));
        }

        @Override
        public boolean isVirtual() {
            return !this.isConstructor() && !this.isPrivate() && !this.isStatic() && !this.isTypeInitializer();
        }

        @Override
        public boolean isDefaultMethod() {
            return !this.isAbstract() && !this.isBridge() && this.getDeclaringType().asErasure().isInterface();
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            if (this.isStatic()) {
                return false;
            }
            if (this.isPrivate() || this.isConstructor()) {
                return this.getDeclaringType().equals(targetType);
            }
            return !this.isAbstract() && this.getDeclaringType().asErasure().isAssignableFrom(targetType);
        }

        @Override
        public <T> T getDefaultValue(Class<T> type) {
            return type.cast(this.getDefaultValue());
        }

        @Override
        public boolean isInvokableOn(TypeDescription typeDescription) {
            return !this.isStatic() && !this.isTypeInitializer() && this.isVisibleTo(typeDescription) && (this.isVirtual() ? this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) : this.getDeclaringType().asErasure().equals(typeDescription));
        }

        @Override
        public boolean isBootstrap() {
            TypeDescription returnType = this.getReturnType().asErasure();
            if (this.isMethod() && (!this.isStatic() || !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(returnType) && !JavaType.CALL_SITE.getTypeStub().isAssignableTo(returnType)) || this.isConstructor() && !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(this.getDeclaringType().asErasure())) {
                return false;
            }
            TypeList parameterTypes = this.getParameters().asTypeList().asErasures();
            switch (parameterTypes.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return ((TypeDescription)parameterTypes.getOnly()).represents((Type)((Object)Object[].class));
                }
                case 2: {
                    return JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) && ((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object[].class));
                }
                case 3: {
                    return !(!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object.class)) && !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)String.class)) || !((TypeDescription)parameterTypes.get(2)).represents((Type)((Object)Object[].class)) && !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2)));
                }
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object.class)) && !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)String.class)) || !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2))) {
                return false;
            }
            int parameterIndex = 4;
            for (TypeDescription parameterType : (TypeList)parameterTypes.subList(3, parameterTypes.size())) {
                if (!parameterType.represents((Type)((Object)Object.class)) && !parameterType.isConstantPool()) {
                    return parameterType.represents((Type)((Object)Object[].class)) && parameterIndex == parameterTypes.size();
                }
                ++parameterIndex;
            }
            return true;
        }

        @Override
        public boolean isBootstrap(List<?> arguments) {
            if (!this.isBootstrap()) {
                return false;
            }
            for (Object argument : arguments) {
                Class<?> argumentType = argument.getClass();
                if (argumentType == String.class || argumentType == Integer.class || argumentType == Long.class || argumentType == Float.class || argumentType == Double.class || TypeDescription.class.isAssignableFrom(argumentType) || JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || JavaInstance.MethodType.class.isAssignableFrom(argumentType)) continue;
                throw new IllegalArgumentException("Not a bootstrap argument: " + argument);
            }
            TypeList parameterTypes = this.getParameters().asTypeList().asErasures();
            if (parameterTypes.size() < 4) {
                return arguments.isEmpty() || ((TypeDescription)parameterTypes.get(parameterTypes.size() - 1)).represents((Type)((Object)Object[].class));
            }
            int index = 4;
            Iterator<?> argumentIterator = arguments.iterator();
            for (TypeDescription parameterType : (TypeList)parameterTypes.subList(3, parameterTypes.size())) {
                boolean finalParameterCheck;
                boolean bl = finalParameterCheck = !argumentIterator.hasNext();
                if (!finalParameterCheck) {
                    Class<?> argumentType = argumentIterator.next().getClass();
                    boolean bl2 = finalParameterCheck = !(parameterType.represents((Type)((Object)String.class)) && argumentType == String.class || parameterType.represents(Integer.TYPE) && argumentType == Integer.class || parameterType.represents(Long.TYPE) && argumentType == Long.class || parameterType.represents(Float.TYPE) && argumentType == Float.class || parameterType.represents(Double.TYPE) && argumentType == Double.class || parameterType.represents((Type)((Object)Class.class)) && TypeDescription.class.isAssignableFrom(argumentType) || parameterType.isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub()) && JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || parameterType.equals(JavaType.METHOD_TYPE.getTypeStub()) && JavaInstance.MethodType.class.isAssignableFrom(argumentType));
                }
                if (finalParameterCheck) {
                    return index == parameterTypes.size() && parameterType.represents((Type)((Object)Object[].class));
                }
                ++index;
            }
            return true;
        }

        @Override
        public boolean isDefaultValue() {
            return !this.isConstructor() && !this.isStatic() && this.getReturnType().asErasure().isAnnotationReturnType() && this.getParameters().isEmpty();
        }

        @Override
        public boolean isDefaultValue(Object value) {
            if (!this.isDefaultValue()) {
                return false;
            }
            TypeDescription returnType = this.getReturnType().asErasure();
            return returnType.represents(Boolean.TYPE) && value instanceof Boolean || returnType.represents(Byte.TYPE) && value instanceof Byte || returnType.represents(Character.TYPE) && value instanceof Character || returnType.represents(Short.TYPE) && value instanceof Short || returnType.represents(Integer.TYPE) && value instanceof Integer || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents(Float.TYPE) && value instanceof Float || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents((Type)((Object)String.class)) && value instanceof String || returnType.isAssignableTo(Enum.class) && value instanceof EnumerationDescription || returnType.isAssignableTo(Annotation.class) && value instanceof AnnotationDescription || returnType.represents((Type)((Object)Class.class)) && value instanceof TypeDescription;
        }

        @Override
        public TypeVariableSource getEnclosingSource() {
            return this.isStatic() ? TypeVariableSource.UNDEFINED : this.getDeclaringType().asErasure();
        }

        @Override
        public <T> T accept(TypeVariableSource.Visitor<T> visitor) {
            return visitor.onMethod((InDefinedShape)this.asDefined());
        }

        @Override
        public boolean isGenericDeclaration() {
            return !this.getTypeVariables().isEmpty();
        }

        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            return new Token(this.getInternalName(), this.getModifiers(), this.getTypeVariables().asTokenList(matcher), this.getReturnType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getParameters().asTokenList(matcher), this.getExceptionTypes().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getDeclaredAnnotations(), this.getDefaultValue());
        }

        @Override
        public SignatureToken asSignatureToken() {
            return new SignatureToken(this.getInternalName(), this.getReturnType().asErasure(), this.getParameters().asTypeList().asErasures());
        }

        @Override
        public TypeToken asTypeToken() {
            return new TypeToken(this.getReturnType().asErasure(), this.getParameters().asTypeList().asErasures());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof MethodDescription && this.getInternalName().equals(((MethodDescription)other).getInternalName()) && this.getDeclaringType().equals(((MethodDescription)other).getDeclaringType()) && this.getReturnType().asErasure().equals(((MethodDescription)other).getReturnType().asErasure()) && this.getParameters().asTypeList().asErasures().equals(((MethodDescription)other).getParameters().asTypeList().asErasures());
        }

        public int hashCode() {
            int hashCode = this.getDeclaringType().hashCode();
            hashCode = 31 * hashCode + this.getInternalName().hashCode();
            hashCode = 31 * hashCode + this.getReturnType().asErasure().hashCode();
            return 31 * hashCode + this.getParameters().asTypeList().asErasures().hashCode();
        }

        @Override
        public String toGenericString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (TypeDescription.Generic typeDescription : this.getParameters().asTypeList()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            TypeList.Generic exceptionTypes = this.getExceptionTypes();
            if (!exceptionTypes.isEmpty()) {
                stringBuilder.append(" throws ");
                first = true;
                for (TypeDescription.Generic typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getSourceCodeName());
                }
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().asErasure().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (TypeDescription typeDescription : this.getParameters().asTypeList().asErasures()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            TypeList exceptionTypes = this.getExceptionTypes().asErasures();
            if (!exceptionTypes.isEmpty()) {
                stringBuilder.append(" throws ");
                first = true;
                for (TypeDescription typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getSourceCodeName());
                }
            }
            return stringBuilder.toString();
        }
    }

    public static interface InDefinedShape
    extends MethodDescription {
        @Override
        public TypeDescription getDeclaringType();

        public ParameterList<ParameterDescription.InDefinedShape> getParameters();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.method.MethodDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }

            @Override
            public TypeDescription.Generic getReceiverType() {
                if (this.isStatic()) {
                    return TypeDescription.Generic.UNDEFINED;
                }
                if (this.isConstructor()) {
                    TypeDefinition declaringType = this.getDeclaringType();
                    TypeDescription enclosingDeclaringType = this.getDeclaringType().getEnclosingType();
                    return TypeDescription.Generic.OfParameterizedType.ForGenerifiedErasure.of((TypeDescription)(enclosingDeclaringType == null ? declaringType : enclosingDeclaringType));
                }
                return TypeDescription.Generic.OfParameterizedType.ForGenerifiedErasure.of((TypeDescription)this.getDeclaringType());
            }
        }
    }

    public static interface InGenericShape
    extends MethodDescription {
        @Override
        public TypeDescription.Generic getDeclaringType();

        public ParameterList<ParameterDescription.InGenericShape> getParameters();
    }
}

