/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;

class RequestToMethodMapper<T> {
    private final Map<HttpPart, Method> methodsByPart = new HashMap<HttpPart, Method>();

    RequestToMethodMapper(Class<T> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            RequestPart partAnnotation = method.getAnnotation(RequestPart.class);
            if (partAnnotation == null) continue;
            this.methodsByPart.put(partAnnotation.value(), method);
        }
    }

    void invoke(HttpServletRequest httpRequest, T controller) throws IOException {
        this.invokeAndReturn(httpRequest, controller);
    }

    Object invokeAndReturn(HttpServletRequest httpRequest, T controller) throws IOException {
        String partParameter = HttpParameter.PART.getParameterFrom(httpRequest);
        HttpPart httpPart = HttpPart.getByName(partParameter);
        Method method = this.methodsByPart.get((Object)httpPart);
        if (method == null) {
            throw new IllegalArgumentException("Unknown http part: " + partParameter);
        }
        try {
            Object[] parameterValues = this.getParameterValues(httpRequest, method);
            return method.invoke(controller, parameterValues);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IOException(targetException);
        }
    }

    private Object[] getParameterValues(HttpServletRequest request, Method method) {
        Annotation[][] parameters = method.getParameterAnnotations();
        Object[] values = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Annotation[] parameter = parameters[i];
            boolean found = false;
            for (Annotation annotation : parameter) {
                if (annotation.annotationType() == RequestParameter.class) {
                    HttpParameter requestParameter = ((RequestParameter)annotation).value();
                    values[i] = requestParameter.getParameterFrom(request);
                    found = true;
                    break;
                }
                if (annotation.annotationType() == RequestAttribute.class) {
                    String requestAttribute = ((RequestAttribute)annotation).value();
                    values[i] = request.getAttribute(requestAttribute);
                    found = true;
                    break;
                }
                if (annotation.annotationType() != RequestHeader.class) continue;
                String requestHeader = ((RequestHeader)annotation).value();
                values[i] = request.getHeader(requestHeader);
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalStateException("a parameter not annotated in method " + method.getName());
        }
        return values;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface RequestHeader {
        public String value();
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface RequestAttribute {
        public String value();
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface RequestParameter {
        public HttpParameter value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface RequestPart {
        public HttpPart value();
    }
}

