/*
 * Cantharella, Pharmacochemical database of natural substances - http://sourceforge.net/p/cantharella/ 
 * 
 * Copyright (C) 2009-2012 IRD (Institut de Recherche pour le Developpement) and by respective authors (see below)
 *
 * Cantharella is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * Cantharella is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
 * details.
 *
 * You should have received a copy of the GNU General Public License along with Cantharella.  If not, see 
 * <http://www.gnu.org/licenses/>.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.StringTransformer;

/**
 * MethodeTest normalizer
 * @author Adrien Cheype
 */
public final class MethodeTestBioNormalizer extends Normalizer<MethodeTestBio> {

	/** {@inheritDoc} */
	@Override
	protected MethodeTestBio normalize(MethodeTestBio methodeTest) {
		AssertTools.assertNotNull(methodeTest);
		// Unique field
		methodeTest.setNom(Normalizer.normalize(ConfigNameNormalizer.class, methodeTest.getNom()));
		methodeTest.setCible(Normalizer.normalize(ConfigNameNormalizer.class, methodeTest.getCible()));
		methodeTest.setDomaine(new StringTransformer(methodeTest.getDomaine()).trimToNull()
				.replaceConsecutiveWhitespaces().toString());
		methodeTest.setValeurMesuree(new StringTransformer(methodeTest.getValeurMesuree()).trimToNull()
				.replaceConsecutiveWhitespaces().toString());
		methodeTest.setUniteResultat(new StringTransformer(methodeTest.getUniteResultat()).trimToNull()
				.replaceConsecutiveWhitespaces().toString());
		methodeTest.setCritereActivite(new StringTransformer(methodeTest.getCritereActivite()).trimToNull()
				.replaceConsecutiveWhitespaces().toString());
		return methodeTest;
	}
}
