/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.io;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.io.SafelyCloseable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

@Deprecated
public class FileLinesByteArrayCollection
extends AbstractCollection<byte[]>
implements Size64 {
    private final String filename;
    private final boolean zipped;
    private final EnumSet<FastBufferedInputStream.LineTerminator> terminators;
    private long size = -1L;

    public FileLinesByteArrayCollection(CharSequence filename) {
        this(filename, false);
    }

    public FileLinesByteArrayCollection(CharSequence filename, boolean zipped) {
        this(filename, zipped, FastBufferedInputStream.ALL_TERMINATORS);
    }

    public FileLinesByteArrayCollection(CharSequence filename, boolean zipped, EnumSet<FastBufferedInputStream.LineTerminator> terminators) {
        this.zipped = zipped;
        this.filename = filename.toString();
        this.terminators = terminators;
    }

    public FileLinesIterator iterator() {
        return new FileLinesIterator(this.filename, this.zipped, this.terminators);
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    public synchronized long size64() {
        if (this.size == -1L) {
            FileLinesIterator i = this.iterator();
            this.size = 0L;
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
            i.close();
        }
        return this.size;
    }

    public ObjectBigList<byte[]> allLines() {
        ObjectBigArrayBigList result = new ObjectBigArrayBigList();
        FileLinesIterator i = this.iterator();
        while (i.hasNext()) {
            result.add((Object)((byte[])i.next()));
        }
        return result;
    }

    @Override
    @Deprecated
    public Object[] toArray() {
        throw new UnsupportedOperationException("Use allLines()");
    }

    @Override
    @Deprecated
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Use allLines()");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.filename + "," + this.zipped + ")";
    }

    @Deprecated
    public static final class FileLinesIterator
    implements Iterator<byte[]>,
    SafelyCloseable {
        private FastBufferedInputStream fbis;
        byte[] buffer = new byte[1024];
        boolean ready;
        int read;
        private final EnumSet<FastBufferedInputStream.LineTerminator> terminators;

        private FileLinesIterator(String filename, boolean zipped, EnumSet<FastBufferedInputStream.LineTerminator> terminators) {
            this.terminators = terminators;
            try {
                this.fbis = new FastBufferedInputStream(zipped ? new GZIPInputStream(new FileInputStream(filename)) : new FileInputStream(filename));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ready) {
                return true;
            }
            if (this.fbis == null) {
                return false;
            }
            this.ready = false;
            try {
                int len;
                this.read = 0;
                while ((len = this.fbis.readLine(this.buffer, this.read, this.buffer.length - this.read, this.terminators)) == this.buffer.length - this.read) {
                    this.ready = true;
                    this.read += len;
                    this.buffer = ByteArrays.grow((byte[])this.buffer, (int)(this.buffer.length + 1));
                }
                if (len != -1) {
                    this.ready = true;
                    this.read += len;
                }
                if (len == -1) {
                    this.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.ready;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.ready = false;
            return Arrays.copyOf(this.buffer, this.read);
        }

        @Override
        public synchronized void close() {
            if (this.fbis == null) {
                return;
            }
            try {
                this.fbis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fbis = null;
            }
        }

        protected synchronized void finalize() throws Throwable {
            try {
                if (this.fbis != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

