/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;

public class Strings {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final double[] timeFactors = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    private static final String[] timeUnites = new String[]{"ns", "ms", "s", "m", "h", "d"};
    private static final double[] memoryFactors = new double[]{1024.0, 1024.0, 1024.0, 1024.0};
    private static final String[] memoryUnites = new String[]{"o", "Ko", "Mo", "Go", "To"};
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String encodeSHA1(String toEncode) {
        try {
            MessageDigest sha1Md = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1Md.digest(toEncode.getBytes());
            return Strings.asHex(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Can't find SHA-1 message digest algorithm", ex);
        }
    }

    private static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static String convertTime(long value) {
        return Strings.convert(value, timeFactors, timeUnites);
    }

    public static String convertTime(long value, long value2) {
        return Strings.convertTime(value2 - value);
    }

    public static String convertMemory(long value) {
        return Strings.convert(value, memoryFactors, memoryUnites);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static String convertToConstantName(String name) {
        StringBuilder sb = new StringBuilder();
        int lastChar = 0;
        int j = name.length();
        for (int i = 0; i < j; ++i) {
            int c = name.charAt(i);
            if (Character.isDigit((char)c)) {
                sb.append((char)c);
                lastChar = c;
                continue;
            }
            if (!Character.isLetter((char)c)) {
                if (lastChar != 95) {
                    sb.append('_');
                }
                lastChar = 95;
                continue;
            }
            if (Character.isUpperCase((char)c)) {
                if (!Character.isUpperCase((char)lastChar) && lastChar != 95) {
                    sb.append('_');
                }
                sb.append((char)c);
            } else {
                sb.append(Character.toUpperCase((char)c));
            }
            lastChar = c;
        }
        String result = sb.toString();
        while (!result.isEmpty() && result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        while (!result.isEmpty() && result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }
}

