/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.I18nMojoSupport;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParseMojoConfiguration;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserTask;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.spi.GetterFile;
import org.nuiton.io.FileUpdater;
import org.nuiton.plugin.PluginHelper;

public abstract class I18nParseMojoSupport
extends I18nMojoSupport
implements I18nParseMojoConfiguration {
    @Parameter(property="i18n.strictMode", defaultValue="false")
    private boolean strictMode;
    @Parameter(property="i18n.treatDefaultEntry", defaultValue="true")
    private boolean treatDefaultEntry;
    @Parameter(property="i18n.entries")
    private I18nSourceEntry[] entries;
    @Parameter(property="i18n.showTouchedFiles", defaultValue="${maven.verbose}")
    private boolean showTouchedFiles;
    @Parameter(property="i18n.force", defaultValue="false")
    private boolean force;
    @Parameter(property="i18n.acceptKeyFormat")
    private String acceptKeyFormat;
    private GetterFile getterFile;
    private long t0;
    private Pattern acceptPattern;

    private static String getLogEntry(String msg, int nbFiles, long all) {
        long now = System.nanoTime();
        String s = msg;
        if (all > 0L) {
            s = s + String.format("(total time:%s)", PluginHelper.convertTime((long)(now - all)));
        }
        if (nbFiles > 0) {
            s = s + String.format(" ( ~ %s / file)", PluginHelper.convertTime((long)((now - all) / (long)nbFiles)));
        }
        return s;
    }

    protected abstract String getOutGetter();

    protected abstract String[] getDefaultIncludes();

    protected abstract String[] getDefaultExcludes();

    protected abstract File getDefaultBasedir();

    public abstract FileParser newFileParser(File var1, Pattern var2);

    public abstract FileUpdater newFileUpdater(SourceEntry var1);

    boolean isForce() {
        return this.force;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.t0 = System.nanoTime();
        this.getterFile = new GetterFile(this.gettersDirectory, this.getOutGetter());
        if (!(this.entries != null && this.entries.length != 0 || this.treatDefaultEntry)) {
            throw new IllegalStateException("No entry defined and treatDefaultEntry is false, will skip the goal.");
        }
        if (this.verbose && this.entries != null && this.entries.length > 0 && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("detected entries : " + this.entries.length));
            for (I18nSourceEntry e : this.entries) {
                this.getLog().info((CharSequence)String.format("%s, specific goal ? %s", e.toString(), e.getSpecificGoal()));
            }
        }
        if (this.acceptKeyFormat != null) {
            this.acceptPattern = Pattern.compile(this.acceptKeyFormat);
        }
    }

    protected void doAction() throws Exception {
        if (!this.silent && this.strictMode) {
            this.getLog().info((CharSequence)"config - strictMode is on (all files will be parsed).");
        }
        if (!this.silent && this.force) {
            this.getLog().info((CharSequence)"config - force is on (all files will be parsed).");
        }
        if (this.treatDefaultEntry) {
            this.addDefaultEntry();
        }
        ArrayList treatedFiles = new ArrayList();
        ArrayList touchedFiles = new ArrayList();
        for (I18nSourceEntry entry : this.entries) {
            boolean skip = entry.init(this);
            if (skip) {
                if (this.silent || !this.verbose) continue;
                this.getLog().info((CharSequence)String.format("skip [%s] - %s", entry, entry.getSkipMessage()));
                continue;
            }
            Set<File> files = entry.getFiles();
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("start entry %s", entry.toString()));
                this.getLog().info((CharSequence)String.format("%d file(s) to process (among %d files)", files.size(), entry.getFoudFiles()));
            }
            files.parallelStream().forEach(f -> {
                ParserTask parserTask = new ParserTask(this, this.newFileParser(entry.getBasedir(), this.acceptPattern), (File)f);
                parserTask.run();
                parserTask.registerResult(treatedFiles, touchedFiles, this.getGetterFile());
            });
        }
        if (treatedFiles.isEmpty()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)"Nothing was parsed - all files are up to date.");
            }
        } else {
            if (this.showTouchedFiles) {
                for (File f2 : touchedFiles) {
                    this.getLog().info((CharSequence)("touch " + f2));
                }
            }
            if (!this.silent) {
                int i = touchedFiles.size();
                int max = treatedFiles.size();
                this.getLog().info((CharSequence)I18nParseMojoSupport.getLogEntry(String.format("Parsing is done. [treated file(s) : %d/%d]", i, max), max, this.t0));
            }
            this.getterFile.store();
        }
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.showTouchedFiles;
    }

    @Override
    public GetterFile getGetterFile() {
        return this.getterFile;
    }

    boolean isStrictMode() {
        return this.strictMode;
    }

    private void addDefaultEntry() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"add default entry");
        }
        boolean hasEntries = this.entries != null && this.entries.length > 0;
        I18nSourceEntry[] tmp = new I18nSourceEntry[hasEntries ? this.entries.length + 1 : 1];
        if (hasEntries) {
            System.arraycopy(this.entries, 0, tmp, 0, this.entries.length);
        }
        tmp[tmp.length - 1] = new I18nSourceEntry();
        this.entries = tmp;
    }

    public Pattern getAcceptPattern() {
        return this.acceptPattern;
    }
}

