/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.i18n.plugin.bundle.I18nArtifact;
import org.nuiton.plugin.DependencyUtil;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="collect-i18n-artifacts", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CollectI18nArtifactsMojo
extends AbstractI18nBundleMojo {
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private DependencyGraphBuilder dependencyTreeBuilder;
    private I18nArtifact[] i18nArtifacts;

    @Override
    public void init() throws Exception {
        super.init();
        this.createDirectoryIfNecessary(this.collectDirectory);
    }

    protected void doAction() throws Exception {
        boolean upToDate = true;
        for (Locale locale : this.locales) {
            File bundleOut = this.getCollectOutputFile(locale, false);
            if (bundleOut.exists()) continue;
            upToDate = false;
            break;
        }
        if (upToDate) {
            File bundleOut = this.getCollectOutputFile(this.locales[0], false);
            int artifactsCount = PluginHelper.getLinesAsURL((File)bundleOut).length;
            this.getLog().info((CharSequence)String.format("skip - %d i18n artifact(s) already collected.", artifactsCount));
            return;
        }
        this.i18nArtifacts = this.detectI18nArtifacts();
        if (this.i18nArtifacts.length == 0) {
            this.getLog().warn((CharSequence)"no i18n artifact detected.");
            return;
        }
        for (Locale locale : this.locales) {
            URL[] urls;
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("generate collected i18n artifacts for locale %s", locale));
            }
            if ((urls = this.getCollectI18nResources(locale)).length == 0) {
                this.getLog().warn((CharSequence)String.format("no i18n bundles for locale %s", locale));
                return;
            }
            File bundleOut = this.getCollectOutputFile(locale, true);
            this.storeCollectI18nResources(bundleOut, urls);
            this.getLog().info((CharSequence)String.format("collected %d i18n artifacts for locale %s stored in %s", urls.length, locale, bundleOut));
        }
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (I18nArtifact artifact : this.i18nArtifacts) {
            I18nBundleEntry[] bundleEntries;
            for (I18nBundleEntry bundleEntry : bundleEntries = artifact.getBundleEntries(locale)) {
                URL path = bundleEntry.getPath();
                urls.add(path);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)String.format("For locale %s, Discover %s ", locale, path));
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void storeCollectI18nResources(File bundleOut, URL[] urls) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (URL path : urls) {
            buffer.append(path).append("\n");
            if (!this.verbose) continue;
            this.getLog().info((CharSequence)String.format("add %s to %s", path, bundleOut));
        }
        this.writeFile(bundleOut, buffer.toString(), this.encoding);
    }

    private I18nArtifact[] detectI18nArtifacts() throws IOException, DependencyGraphBuilderException {
        I18nArtifact i18nArtifact;
        HashMap<Artifact, I18nArtifact> dico = new HashMap<Artifact, I18nArtifact>();
        for (Object o : this.project.getArtifacts()) {
            i18nArtifact = new I18nArtifact((Artifact)o);
            this.detectBundles(i18nArtifact, null, dico);
        }
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile+runtime");
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest();
        buildingRequest.setLocalRepository(this.localRepository);
        buildingRequest.setProject(this.project);
        buildingRequest.setRepositorySession(this.mavenSession.getRepositorySession());
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, (ArtifactFilter)artifactFilter);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(dico.keySet());
        if (!artifacts.isEmpty()) {
            DependencyUtil.sortArtifacts((DependencyNode)rootNode, artifacts, (boolean)this.getLog().isDebugEnabled());
        }
        Artifact projectArtifact = this.project.getArtifact();
        i18nArtifact = new I18nArtifact(projectArtifact, this.sourceDirectory.getParentFile());
        this.detectBundles(i18nArtifact, artifacts, dico);
        I18nArtifact[] result = new I18nArtifact[artifacts.size()];
        int i = 0;
        for (Artifact artifact : artifacts) {
            result[i++] = (I18nArtifact)dico.get(artifact);
        }
        return result;
    }

    private void detectBundles(I18nArtifact i18nArtifact, List<Artifact> artifacts, Map<Artifact, I18nArtifact> dico) throws IOException {
        if (i18nArtifact.detectBundles()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("detected i18n artifact %s", i18nArtifact));
            }
            if (artifacts != null) {
                artifacts.add(i18nArtifact.getArtifact());
            }
            dico.put(i18nArtifact.getArtifact(), i18nArtifact);
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("reject artifact %s", i18nArtifact));
        }
    }
}

