/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PistacheServerCodegen
extends AbstractCppCodegen {
    protected String implFolder = "impl";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "pistache-server";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API server (based on Pistache)";
    }

    public PistacheServerCodegen() {
        this.apiPackage = "io.swagger.server.api";
        this.modelPackage = "io.swagger.server.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-impl-header.mustache", ".h");
        this.apiTemplateFiles.put("api-impl-source.mustache", ".cpp");
        this.apiTemplateFiles.put("main-api-server.mustache", ".cpp");
        this.templateDir = "pistache-server";
        this.embeddedTemplateDir = "pistache-server";
        this.cliOptions.clear();
        this.reservedWords = new HashSet();
        this.supportingFiles.add(new SupportingFile("modelbase-header.mustache", "model", "ModelBase.h"));
        this.supportingFiles.add(new SupportingFile("modelbase-source.mustache", "model", "ModelBase.cpp"));
        this.supportingFiles.add(new SupportingFile("cmake.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "std::string");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("Object", "#include \"Object.h\"");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        Schema schemaResponse;
        ApiResponse methodResponse;
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && (schemaResponse = this.getSchemaFromResponse(methodResponse)) != null) {
            CodegenProperty cm = this.fromProperty("response", schemaResponse);
            codegenOperation.vendorExtensions.put("x-codegen-response", cm);
            if (cm.datatype == "HttpContent") {
                codegenOperation.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        String pathForPistache = path.replaceAll("\\{(.*?)}", ":$1");
        codegenOperation.vendorExtensions.put("x-codegen-pistache-path", pathForPistache);
        return codegenOperation;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        String classname = (String)operations.get("classname");
        operations.put("classnameSnakeUpperCase", DefaultCodegen.underscore(classname).toUpperCase());
        operations.put("classnameSnakeLowerCase", DefaultCodegen.underscore(classname).toLowerCase());
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            boolean consumeJson = false;
            boolean isParsingSupported = true;
            if (op.bodyParam != null) {
                if (op.bodyParam.vendorExtensions == null) {
                    op.bodyParam.vendorExtensions = new HashMap<String, Object>();
                }
                op.bodyParam.vendorExtensions.put("x-codegen-pistache-isStringOrDate", ExtensionHelper.getBooleanValue(op.bodyParam, "x-is-string") || ExtensionHelper.getBooleanValue(op.bodyParam, "x-is-date"));
            }
            if (op.consumes != null) {
                for (Map<String, String> consume : op.consumes) {
                    if (consume.get("mediaType") == null || !consume.get("mediaType").equals("application/json")) continue;
                    consumeJson = true;
                }
            }
            op.httpMethod = op.httpMethod.substring(0, 1).toUpperCase() + op.httpMethod.substring(1).toLowerCase();
            for (CodegenParameter param : op.allParams) {
                if (ExtensionHelper.getBooleanValue(param, "x-is-form-param")) {
                    isParsingSupported = false;
                }
                if (ExtensionHelper.getBooleanValue(param, "x-is-file")) {
                    isParsingSupported = false;
                }
                if (ExtensionHelper.getBooleanValue(param, "x-is-cookie-param")) {
                    isParsingSupported = false;
                }
                if (ExtensionHelper.getBooleanValue(param, "x-is-header-param")) {
                    param.dataType = "Optional<Net::Http::Header::Raw>";
                    param.baseType = "Optional<Net::Http::Header::Raw>";
                    continue;
                }
                if (!ExtensionHelper.getBooleanValue(param, "x-is-query-param")) continue;
                if (ExtensionHelper.getBooleanValue(param, "x-is-primitive-type")) {
                    param.dataType = "Optional<" + param.dataType + ">";
                    continue;
                }
                param.dataType = "Optional<" + param.baseType + ">";
                param.baseType = "Optional<" + param.baseType + ">";
            }
            if (op.vendorExtensions == null) {
                op.vendorExtensions = new HashMap<String, Object>();
            }
            op.vendorExtensions.put("x-codegen-pistache-consumesJson", consumeJson);
            op.vendorExtensions.put("x-codegen-pistache-isParsingSupported", isParsingSupported);
        }
        return objs;
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("impl-header.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 2) + "Impl.h";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        } else if (templateName.endsWith("impl-source.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 4) + "Impl.cpp";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        } else if (templateName.endsWith("api-server.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 4) + "MainServer.cpp";
            result = result.replace(this.apiFileFolder(), this.outputFolder);
        }
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        String schemaType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s<%s>", schemaType, this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && PistacheServerCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s<std::string, %s>", schemaType, this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof StringSchema || propertySchema instanceof DateSchema || propertySchema instanceof DateTimeSchema || propertySchema instanceof FileSchema || this.languageSpecificPrimitives.contains(schemaType)) {
            return this.toModelName(schemaType);
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        if (propertySchema instanceof StringSchema) {
            return "\"\"";
        }
        if (propertySchema instanceof BooleanSchema) {
            return "false";
        }
        if (propertySchema instanceof DateSchema) {
            return "\"\"";
        }
        if (propertySchema instanceof DateTimeSchema) {
            return "\"\"";
        }
        if (propertySchema instanceof NumberSchema) {
            if ("float".equals(propertySchema.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (propertySchema instanceof IntegerSchema) {
            if ("int64".equals(propertySchema.getFormat())) {
                return "0L";
            }
            return "0";
        }
        if (propertySchema instanceof MapSchema && PistacheServerCodegen.hasSchemaProperties(propertySchema)) {
            String inner = this.getSchemaType((Schema)propertySchema.getAdditionalProperties());
            return "std::map<std::string, " + inner + ">()";
        }
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            String inner = this.getSchemaType(arraySchema.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + inner + ">";
            }
            return "std::vector<" + inner + ">()";
        }
        if (StringUtils.isNotBlank((CharSequence)propertySchema.get$ref())) {
            return "new " + this.toModelName(propertySchema.get$ref()) + "()";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type");
        boolean isListContainer = ExtensionHelper.getBooleanValue(parameter, "x-is-list-container");
        boolean isString = ExtensionHelper.getBooleanValue(parameter, "x-is-string");
        if (!(isPrimitiveType || isListContainer || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    private String implFileFolder() {
        return (this.outputFolder + "/" + this.implFolder).replace("/", File.separator);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String schemaType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toApiName(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

