/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class HaskellServantCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String sourceFolder = "src";
    protected String apiVersion = "0.0.1";
    private static final Pattern LEADING_UNDERSCORE = Pattern.compile("^_+");

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "haskell";
    }

    @Override
    public String getHelp() {
        return "Generates a Haskell server and client library.";
    }

    public HaskellServantCodegen() {
        this.specialCharReplacements.put("-", "Dash");
        this.specialCharReplacements.put(">", "GreaterThan");
        this.specialCharReplacements.put("<", "LessThan");
        this.specialCharReplacements.remove("\\");
        this.specialCharReplacements.remove("\"");
        this.specialCharReplacements.put("\\\\", "Back_Slash");
        this.specialCharReplacements.put("\\\"", "Double_Quote");
        this.outputFolder = "generated-code/haskell-servant";
        this.templateDir = "haskell-servant";
        this.embeddedTemplateDir = "haskell-servant";
        this.apiPackage = "API";
        this.modelPackage = "Types";
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "family", "default", "deriving", "do", "forall", "foreign", "hiding", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("stack.mustache", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("Setup.mustache", "", "Setup.hs"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "String", "Int", "Integer", "Float", "Char", "Double", "List", "FilePath"));
        this.typeMapping.clear();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "Text");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("DateTime", "Integer");
        this.typeMapping.put("file", "FilePath");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("any", "Value");
        this.typeMapping.put("UUID", "Text");
        this.typeMapping.put("ByteArray", "Text");
        this.importMapping.clear();
        this.importMapping.put("Map", "qualified Data.Map as Map");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    public String firstLetterToUpper(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toUpperCase();
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public String firstLetterToLower(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toLowerCase();
        }
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String title = openAPI.getInfo().getTitle();
        if (title == null) {
            title = "Swagger";
        } else if ((title = title.trim()).toUpperCase().endsWith("API")) {
            title = title.substring(0, title.length() - 3);
        }
        String[] words = title.split(" ");
        ArrayList<String> wordsLower = new ArrayList<String>();
        for (String word : words) {
            wordsLower.add(word.toLowerCase());
        }
        String cabalName = this.joinStrings("-", wordsLower);
        ArrayList<String> wordsCaps = new ArrayList<String>();
        for (String word : words) {
            wordsCaps.add(this.firstLetterToUpper(word));
        }
        String apiName = this.joinStrings("", wordsCaps);
        this.supportingFiles.add(new SupportingFile("haskell-servant-codegen.mustache", "", cabalName + ".cabal"));
        this.supportingFiles.add(new SupportingFile("API.mustache", "lib/" + apiName, "API.hs"));
        this.supportingFiles.add(new SupportingFile("Types.mustache", "lib/" + apiName, "Types.hs"));
        this.additionalProperties.put("title", apiName);
        this.additionalProperties.put("titleLower", this.firstLetterToLower(apiName));
        this.additionalProperties.put("package", cabalName);
        this.additionalProperties.put("contextStackLimit", openAPI.getPaths().size() * 2 + 300);
        ArrayList replacements = new ArrayList();
        Object[] replacementChars = this.specialCharReplacements.keySet().toArray();
        for (int i = 0; i < replacementChars.length; ++i) {
            String c = (String)replacementChars[i];
            HashMap<String, Object> o = new HashMap<String, Object>();
            o.put("char", c);
            o.put("replacement", "'" + (String)this.specialCharReplacements.get(c));
            o.put("hasMore", i != replacementChars.length - 1);
            replacements.add(o);
        }
        this.additionalProperties.put("specialCharReplacements", replacements);
        super.preprocessOpenAPI(openAPI);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("[%s]", this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && HaskellServantCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("Map.Map String ", this.getTypeDeclaration(inner));
        }
        return this.fixModelChars(super.getTypeDeclaration(propertySchema));
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType == "object" ? "Value" : (this.typeMapping.containsValue(swaggerType) ? swaggerType + "_" : swaggerType);
        }
        return this.toModelName(type);
    }

    @Override
    public String toInstantiationType(Schema propertySchema) {
        if (propertySchema instanceof MapSchema && HaskellServantCodegen.hasSchemaProperties(propertySchema)) {
            Schema additionalProperties2 = (Schema)propertySchema.getAdditionalProperties();
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n\tIn Property: " + propertySchema);
            }
            String inner = this.getSchemaType(additionalProperties2);
            return "(Map.Map Text " + inner + ")";
        }
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return inner;
        }
        return null;
    }

    private String joinStrings(String sep, List<String> ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private List<String> pathToServantRoute(String path, List<CodegenParameter> pathParams) {
        HashMap<String, String> captureTypes = new HashMap<String, String>();
        for (CodegenParameter param : pathParams) {
            captureTypes.put(param.baseName, param.dataType);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> pathComponents = new ArrayList<String>();
        for (String piece : path.split("/")) {
            if (piece.startsWith("{") && piece.endsWith("}")) {
                String name = piece.substring(1, piece.length() - 1);
                pathComponents.add("Capture \"" + name + "\" " + (String)captureTypes.get(name));
                continue;
            }
            pathComponents.add("\"" + piece + "\"");
        }
        return pathComponents;
    }

    private List<String> pathToClientType(String path, List<CodegenParameter> pathParams) {
        HashMap<String, String> captureTypes = new HashMap<String, String>();
        for (CodegenParameter param : pathParams) {
            captureTypes.put(param.baseName, param.dataType);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> type = new ArrayList<String>();
        for (String piece : path.split("/")) {
            if (!piece.startsWith("{") || !piece.endsWith("}")) continue;
            String name = piece.substring(1, piece.length() - 1);
            type.add((String)captureTypes.get(name));
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodegenOperation fromOperation(String resourcePath, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        void var10_19;
        void var10_17;
        CodegenOperation op = super.fromOperation(resourcePath, httpMethod, operation, schemas, openAPI);
        List<String> path = this.pathToServantRoute(op.path, op.pathParams);
        List<String> type = this.pathToClientType(op.path, op.pathParams);
        for (CodegenParameter codegenParameter : op.queryParams) {
            String paramType = codegenParameter.dataType;
            if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-list-container")) {
                paramType = this.makeQueryListType(paramType, codegenParameter.collectionFormat);
            }
            path.add("QueryParam \"" + codegenParameter.baseName + "\" " + paramType);
            type.add("Maybe " + codegenParameter.dataType);
        }
        String bodyType = null;
        if (op.getHasBodyParam()) {
            for (CodegenParameter param : op.bodyParams) {
                path.add("ReqBody '[JSON] " + param.dataType);
                bodyType = param.dataType;
            }
        } else if (op.getHasFormParams()) {
            String string;
            bodyType = string = "Form" + HaskellServantCodegen.camelize(op.operationId);
            path.add("ReqBody '[FormUrlEncoded] " + string);
        }
        if (bodyType != null) {
            type.add(bodyType);
        }
        for (CodegenParameter param : op.headerParams) {
            path.add("Header \"" + param.baseName + "\" " + param.dataType);
            String paramType = param.dataType;
            if (ExtensionHelper.getBooleanValue(param, "x-is-list-container")) {
                paramType = this.makeQueryListType(paramType, param.collectionFormat);
            }
            type.add("Maybe " + paramType);
        }
        String string = op.returnType;
        if (string == null || string.equals("null")) {
            String string2 = "()";
        }
        if (var10_17.indexOf(" ") >= 0) {
            String string3 = "(" + (String)var10_17 + ")";
        }
        path.add("Verb '" + op.httpMethod.toUpperCase() + " 200 '[JSON] " + (String)var10_19);
        type.add("m " + (String)var10_19);
        op.vendorExtensions.put("x-routeType", this.joinStrings(" :> ", path));
        op.vendorExtensions.put("x-clientType", this.joinStrings(" -> ", type));
        op.vendorExtensions.put("x-formName", "Form" + HaskellServantCodegen.camelize(op.operationId));
        for (CodegenParameter param : op.formParams) {
            param.vendorExtensions.put("x-formPrefix", HaskellServantCodegen.camelize(op.operationId, true));
        }
        return op;
    }

    private String makeQueryListType(String type, String collectionFormat) {
        type = type.substring(1, type.length() - 1);
        switch (collectionFormat) {
            case "csv": {
                return "(QueryList 'CommaSeparated (" + type + "))";
            }
            case "tsv": {
                return "(QueryList 'TabSeparated (" + type + "))";
            }
            case "ssv": {
                return "(QueryList 'SpaceSeparated (" + type + "))";
            }
            case "pipes": {
                return "(QueryList 'PipeSeparated (" + type + "))";
            }
            case "multi": {
                return "(QueryList 'MultiParamArray (" + type + "))";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String fixOperatorChars(String string) {
        StringBuilder sb = new StringBuilder();
        String name = string;
        if (string.startsWith("_")) {
            if (this.reservedWords.contains(string.substring(1, string.length()))) {
                name = string.substring(1, string.length());
            } else if (this.reservedWordsMappings.containsValue(string)) {
                name = LEADING_UNDERSCORE.matcher(string).replaceFirst("");
            }
        }
        for (char c : name.toCharArray()) {
            String cString = String.valueOf(c);
            if (this.specialCharReplacements.containsKey(cString)) {
                sb.append("'");
                sb.append((String)this.specialCharReplacements.get(cString));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String fixModelChars(String string) {
        return string.replace(".", "").replace("-", "");
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel model = super.fromModel(name, schema, allSchemas);
        model.classname = this.fixModelChars(model.classname);
        if (this.typeMapping.containsValue(model.classname)) {
            model.classname = model.classname + "_";
        }
        String prefix = HaskellServantCodegen.camelize(model.classname, true);
        for (CodegenProperty prop : model.vars) {
            prop.name = this.toVarName(prefix + HaskellServantCodegen.camelize(this.fixOperatorChars(prop.name)));
        }
        String dataOrNewtype = "data";
        String modelType = schema.getType();
        if (modelType != "object" && this.typeMapping.containsKey(modelType)) {
            String newtype = (String)this.typeMapping.get(modelType);
            model.vendorExtensions.put("x-customNewtype", newtype);
        }
        model.vendorExtensions.put("x-prefix", prefix);
        model.vendorExtensions.put("x-data", dataOrNewtype);
        return model;
    }

    @Override
    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter p = super.fromParameter(param, imports);
        p.vendorExtensions.put("x-formParamName", HaskellServantCodegen.camelize(p.baseName));
        p.dataType = this.fixModelChars(p.dataType);
        return p;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("{-", "{_-").replace("-}", "-_}");
    }
}

