/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenHelper;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenModelFactory;
import io.swagger.codegen.CodegenModelType;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.codegen.languages.helpers.HasHelper;
import io.swagger.codegen.languages.helpers.HasNotHelper;
import io.swagger.codegen.languages.helpers.IsHelper;
import io.swagger.codegen.languages.helpers.IsNotHelper;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen
implements CodegenConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String REQUEST_BODY_NAME = "body";
    protected String inputSpec;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String testPackage = "";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String embeddedTemplateDir;
    protected String commonTemplateDir = "_common";
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected boolean supportsInheritance;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected Map<String, String> specialCharReplacements = new HashMap<String, String>();
    protected Map<String, String> typeAliases = null;
    protected String ignoreFilePathOverride;

    @Override
    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        }
        if (this.additionalProperties.containsKey("ensureUniqueParams")) {
            this.setEnsureUniqueParams(Boolean.valueOf(this.additionalProperties.get("ensureUniqueParams").toString()));
        }
        if (this.additionalProperties.containsKey("allowUnicodeIdentifiers")) {
            this.setAllowUnicodeIdentifiers(Boolean.valueOf(this.additionalProperties.get("allowUnicodeIdentifiers").toString()));
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.setModelNamePrefix((String)this.additionalProperties.get("modelNamePrefix"));
        }
        if (this.additionalProperties.containsKey("modelNameSuffix")) {
            this.setModelNameSuffix((String)this.additionalProperties.get("modelNameSuffix"));
        }
        if (this.additionalProperties.containsKey("removeOperationIdPrefix")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("removeOperationIdPrefix").toString()));
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> processedModels) {
        if (this.supportsInheritance) {
            HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
            for (Map.Entry<String, Object> entry : processedModels.entrySet()) {
                String modelName = this.toModelName(entry.getKey());
                Map inner = (Map)entry.getValue();
                List models = (List)inner.get("models");
                for (Map mo : models) {
                    CodegenModel cm = (CodegenModel)mo.get("model");
                    allModels.put(modelName, cm);
                }
            }
            ModelUtils.processCodegenModels(allModels);
        }
        return processedModels;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        ModelUtils.processModelEnums(objs);
        return objs;
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        return ModelUtils.toEnumVarName(value);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    @Override
    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    @Override
    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    @Override
    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    @Override
    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    @Override
    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    @Override
    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    @Override
    public String testPackage() {
        return this.testPackage;
    }

    @Override
    public String modelPackage() {
        return this.modelPackage;
    }

    @Override
    public String apiPackage() {
        return this.apiPackage;
    }

    @Override
    public String fileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public String templateDir() {
        return this.templateDir;
    }

    @Override
    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    @Override
    public String getCommonTemplateDir() {
        return this.commonTemplateDir;
    }

    public void setCommonTemplateDir(String commonTemplateDir) {
        this.commonTemplateDir = commonTemplateDir;
    }

    @Override
    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    @Override
    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    @Override
    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    @Override
    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    @Override
    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    @Override
    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    @Override
    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', '/');
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    @Override
    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    @Override
    public String outputFolder() {
        return this.outputFolder;
    }

    @Override
    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    @Override
    public String getOutputDir() {
        return this.outputFolder();
    }

    @Override
    public String getInputSpec() {
        return this.inputSpec;
    }

    @Override
    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.initialCaps(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.initialCaps(name);
    }

    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name) + "Enum";
    }

    @Override
    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        this.defaultIncludes = CodegenHelper.getDefaultIncludes();
        this.typeMapping = CodegenHelper.getTypeMappings();
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = CodegenHelper.getImportMappings();
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        CodegenHelper.initalizeSpecialCharacterMapping(this.specialCharReplacements);
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    @Override
    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter queryParameter = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (queryParameter.getStyle() != null) {
                    paramPart.append(param.getName()).append("1");
                    if (Parameter.StyleEnum.FORM.equals((Object)queryParameter.getStyle())) {
                        if (queryParameter.getExplode() != null && queryParameter.getExplode().booleanValue()) {
                            paramPart.append(",");
                        } else {
                            paramPart.append("&").append(param.getName()).append("=");
                            paramPart.append(param.getName()).append("2");
                        }
                    } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)queryParameter.getStyle())) {
                        paramPart.append("|");
                    } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)queryParameter.getStyle())) {
                        paramPart.append("%20");
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Schema property) {
        if (property instanceof MapSchema || property.getAdditionalProperties() != null && property.getAdditionalProperties() instanceof Schema) {
            Schema additionalProperties = (Schema)property.getAdditionalProperties();
            String type = additionalProperties.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties + "\n\tIn Property: " + property);
            }
            String inner = this.getSchemaType(additionalProperties);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (property instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)property;
            String inner = this.getSchemaType(arraySchema.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter p) {
    }

    public String toExampleValue(Schema property) {
        return String.valueOf(property.getExample());
    }

    public String toDefaultValue(Schema property) {
        return String.valueOf(property.getDefault());
    }

    public String toDefaultValueWithParam(String name, Schema property) {
        return " = data." + name + ";";
    }

    public String getSchemaType(Schema property) {
        String datatype = null;
        if (StringUtils.isNotBlank((CharSequence)property.get$ref())) {
            try {
                datatype = property.get$ref();
                if (datatype.indexOf("#/components/schemas/") == 0) {
                    datatype = datatype.substring("#/components/schemas/".length());
                    return datatype;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error obtaining the datatype from ref:" + property + ". Datatype default to Object");
                datatype = "Object";
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        if (property instanceof StringSchema && "number".equals(property.getFormat())) {
            datatype = "BigDecimal";
        } else if (property instanceof ByteArraySchema) {
            datatype = "ByteArray";
        } else if (property instanceof BinarySchema) {
            datatype = "binary";
        } else if (property instanceof FileSchema) {
            datatype = "file";
        } else if (property instanceof BooleanSchema) {
            datatype = "boolean";
        } else if (property instanceof DateSchema) {
            datatype = "date";
        } else if (property instanceof DateTimeSchema) {
            datatype = "DateTime";
        } else if (property instanceof NumberSchema) {
            datatype = "float".equals(property.getFormat()) ? "float" : ("double".equals(property.getFormat()) ? "double" : "BigDecimal");
        } else if (property instanceof IntegerSchema) {
            datatype = "int64".equals(property.getFormat()) ? "long" : property.getType();
        } else if (property instanceof MapSchema) {
            datatype = "map";
        } else if (property instanceof UUIDSchema) {
            datatype = "UUID";
        } else if (property instanceof StringSchema) {
            datatype = "string";
        } else if (property != null) {
            datatype = "object".equals(property.getType()) && property.getAdditionalProperties() != null ? "map" : property.getType();
        }
        return datatype;
    }

    public String snakeCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    public String initialCaps(String name) {
        return StringUtils.capitalize((String)name);
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        String swaggerType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(swaggerType)) {
            return this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    public String getAlias(String name) {
        return name;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String toModelName(String name) {
        return this.initialCaps(this.modelNamePrefix + name + this.modelNameSuffix);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        return this.fromModel(name, schema, null);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        if (this.typeAliases == null) {
            this.typeAliases = DefaultCodegen.getAllAliases(allDefinitions);
        }
        CodegenModel codegenModel = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        codegenModel.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        codegenModel.title = this.escapeText(schema.getTitle());
        codegenModel.description = this.escapeText(schema.getDescription());
        codegenModel.unescapedDescription = schema.getDescription();
        codegenModel.classname = this.toModelName(name);
        codegenModel.classVarName = this.toVarName(name);
        codegenModel.classFilename = this.toModelFilename(name);
        codegenModel.modelJson = Json.pretty((Object)schema);
        codegenModel.externalDocumentation = schema.getExternalDocs();
        if (schema.getExtensions() != null && !schema.getExtensions().isEmpty()) {
            codegenModel.getVendorExtensions().putAll(schema.getExtensions());
        }
        codegenModel.getVendorExtensions().put("x-is-alias", this.typeAliases.containsKey(name));
        codegenModel.discriminator = schema.getDiscriminator();
        if (schema.getXml() != null) {
            codegenModel.xmlPrefix = schema.getXml().getPrefix();
            codegenModel.xmlNamespace = schema.getXml().getNamespace();
            codegenModel.xmlName = schema.getXml().getName();
        }
        if (schema instanceof ArraySchema) {
            codegenModel.getVendorExtensions().put("x-is-array-model", Boolean.TRUE);
            codegenModel.arrayModelType = this.fromProperty((String)name, (Schema)schema).complexType;
            this.addParentContainer(codegenModel, name, schema);
        } else if (schema instanceof ComposedSchema) {
            String parentName;
            ArrayList<String> allRequired;
            LinkedHashMap<String, Schema> allProperties;
            ComposedSchema composed = (ComposedSchema)schema;
            LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
            ArrayList<String> required = new ArrayList<String>();
            if (this.supportsInheritance || this.supportsMixins) {
                allProperties = new LinkedHashMap<String, Schema>();
                allRequired = new ArrayList<String>();
                codegenModel.allVars = new ArrayList<CodegenProperty>();
                int modelImplCnt = 0;
                for (Schema innerModel : composed.getAllOf()) {
                    if (codegenModel.discriminator == null) {
                        codegenModel.discriminator = schema.getDiscriminator();
                    }
                    if (innerModel.getXml() != null) {
                        codegenModel.xmlPrefix = innerModel.getXml().getPrefix();
                        codegenModel.xmlNamespace = innerModel.getXml().getNamespace();
                        codegenModel.xmlName = innerModel.getXml().getName();
                    }
                    if (modelImplCnt++ <= 1) continue;
                    LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                    break;
                }
            } else {
                allProperties = null;
                allRequired = null;
            }
            Schema parent = StringUtils.isBlank((CharSequence)(parentName = this.getParentName(composed, allDefinitions))) ? null : allDefinitions.get(parentName);
            List<Schema> interfaces = this.getInterfaces(composed);
            if (interfaces != null) {
                if (codegenModel.interfaces == null) {
                    codegenModel.interfaces = new ArrayList<String>();
                }
                for (Schema interfaceSchema : interfaces) {
                    if (StringUtils.isBlank((CharSequence)interfaceSchema.get$ref())) continue;
                    Schema refSchema = null;
                    String ref = this.getSimpleRef(interfaceSchema.get$ref());
                    if (allDefinitions != null) {
                        refSchema = allDefinitions.get(ref);
                    }
                    String modelName = this.toModelName(ref);
                    codegenModel.interfaces.add(modelName);
                    this.addImport(codegenModel, modelName);
                    if (allDefinitions == null || refSchema == null) continue;
                    if (!this.supportsMixins) {
                        this.addProperties(properties, required, refSchema, allDefinitions);
                    }
                    if (!this.supportsInheritance) continue;
                    this.addProperties(allProperties, allRequired, refSchema, allDefinitions);
                }
            }
            if (parent != null) {
                codegenModel.parentSchema = parentName;
                codegenModel.parent = StringUtils.capitalize((String)(this.modelNamePrefix + parentName + this.modelNameSuffix));
                this.addImport(codegenModel, codegenModel.parent);
                if (allDefinitions != null) {
                    if (this.supportsInheritance) {
                        this.addProperties(allProperties, allRequired, parent, allDefinitions);
                    } else {
                        this.addProperties(properties, required, parent, allDefinitions);
                    }
                }
            }
            this.addProperties(properties, required, (Schema)composed, allDefinitions);
            this.addVars(codegenModel, properties, required, allProperties, allRequired);
        } else {
            codegenModel.dataType = this.getSchemaType(schema);
            if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
                codegenModel.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                codegenModel.allowableValues = new HashMap<String, Object>();
                codegenModel.allowableValues.put("values", schema.getEnum());
            }
            if (schema.getAdditionalProperties() != null) {
                this.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
            }
            this.addVars(codegenModel, schema.getProperties(), schema.getRequired());
        }
        if (codegenModel.vars != null) {
            for (CodegenProperty prop : codegenModel.vars) {
                this.postProcessModelProperty(codegenModel, prop);
            }
        }
        return codegenModel;
    }

    private boolean isDiscriminatorInInterfaceTree(ComposedSchema composedSchema, Map<String, Schema> allSchema) {
        if (composedSchema == null || allSchema == null || allSchema.isEmpty()) {
            return false;
        }
        if (composedSchema.getDiscriminator() != null) {
            return true;
        }
        List<Schema> interfaces = this.getInterfaces(composedSchema);
        if (interfaces == null) {
            return false;
        }
        for (Schema interfaceSchema : interfaces) {
            if (interfaceSchema.getDiscriminator() == null) continue;
            return true;
        }
        return false;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        this.addParentContainer(codegenModel, codegenModel.name, schema);
    }

    protected void addProperties(Map<String, Schema> properties, List<String> required, Schema schema, Map<String, Schema> allSchemas) {
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (composedSchema.getAllOf() == null) {
                return;
            }
            for (Schema component : composedSchema.getAllOf()) {
                this.addProperties(properties, required, component, allSchemas);
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            Schema interfaceSchema = allSchemas.get(this.getSimpleRef(schema.get$ref()));
            this.addProperties(properties, required, interfaceSchema, allSchemas);
            return;
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
        if (schema.getRequired() != null) {
            required.addAll(schema.getRequired());
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return DefaultCodegen.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Schema propertySchema) {
        HashMap<String, Object> allowableValues;
        List _enum;
        if (propertySchema == null) {
            LOGGER.error("unexpected missing property for name " + name);
            return null;
        }
        CodegenProperty codegenProperty = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        codegenProperty.name = this.toVarName(name);
        codegenProperty.baseName = name;
        codegenProperty.nameInCamelCase = DefaultCodegen.camelize(codegenProperty.name, false);
        codegenProperty.description = this.escapeText(propertySchema.getDescription());
        codegenProperty.unescapedDescription = propertySchema.getDescription();
        codegenProperty.title = propertySchema.getTitle();
        codegenProperty.getter = this.toGetter(name);
        codegenProperty.setter = this.toSetter(name);
        String example = this.toExampleValue(propertySchema);
        if (!"null".equals(example)) {
            codegenProperty.example = example;
        }
        codegenProperty.defaultValue = this.toDefaultValue(propertySchema);
        codegenProperty.defaultValueWithParam = this.toDefaultValueWithParam(name, propertySchema);
        codegenProperty.jsonSchema = Json.pretty((Object)propertySchema);
        if (propertySchema.getReadOnly() != null) {
            codegenProperty.getVendorExtensions().put("x-is-read-only", propertySchema.getReadOnly());
        }
        if (propertySchema.getXml() != null) {
            if (propertySchema.getXml().getAttribute() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-attribute", propertySchema.getXml().getAttribute());
            }
            codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
            codegenProperty.xmlName = propertySchema.getXml().getName();
            codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
        }
        if (propertySchema.getExtensions() != null && !propertySchema.getExtensions().isEmpty()) {
            codegenProperty.getVendorExtensions().putAll(propertySchema.getExtensions());
        }
        String type = this.getSchemaType(propertySchema);
        if (propertySchema instanceof IntegerSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("int64".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-long", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
            }
            if (propertySchema.getMinimum() != null) {
                codegenProperty.minimum = String.valueOf(propertySchema.getMinimum().longValue());
            }
            if (propertySchema.getMaximum() != null) {
                codegenProperty.maximum = String.valueOf(propertySchema.getMaximum().longValue());
            }
            if (propertySchema.getExclusiveMinimum() != null) {
                codegenProperty.exclusiveMinimum = propertySchema.getExclusiveMinimum();
            }
            if (propertySchema.getExclusiveMaximum() != null) {
                codegenProperty.exclusiveMaximum = propertySchema.getExclusiveMaximum();
            }
            if (codegenProperty.minimum != null || codegenProperty.maximum != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (propertySchema.getMinimum() != null) {
                allowableValues2.put("min", propertySchema.getMinimum());
            }
            if (propertySchema.getMaximum() != null) {
                allowableValues2.put("max", propertySchema.getMaximum());
            }
            if (propertySchema.getEnum() != null) {
                List _enum2 = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList<String>();
                for (Integer i : _enum2) {
                    codegenProperty._enum.add(i.toString());
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues2.put("values", _enum2);
            }
            if (allowableValues2.size() > 0) {
                codegenProperty.allowableValues = allowableValues2;
            }
        }
        if (propertySchema instanceof StringSchema) {
            codegenProperty.maxLength = propertySchema.getMaxLength();
            codegenProperty.minLength = propertySchema.getMinLength();
            codegenProperty.pattern = this.toRegularExpression(propertySchema.getPattern());
            if (codegenProperty.pattern != null || codegenProperty.minLength != null || codegenProperty.maxLength != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
            if (propertySchema.getEnum() != null) {
                codegenProperty._enum = _enum = propertySchema.getEnum();
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof BooleanSchema) {
            codegenProperty.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
            codegenProperty.getter = this.toBooleanGetter(name);
        }
        if (propertySchema instanceof BinarySchema) {
            codegenProperty.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof FileSchema) {
            codegenProperty.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof EmailSchema) {
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof UUIDSchema) {
            codegenProperty.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof ByteArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        }
        if (propertySchema instanceof NumberSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("float".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-float", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-double", Boolean.TRUE);
            }
            if (propertySchema.getEnum() != null) {
                _enum = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    codegenProperty._enum.add(((Double)i).toString());
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof DateSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date", Boolean.TRUE);
            if (propertySchema.getEnum() != null) {
                _enum = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    codegenProperty._enum.add((String)i);
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof DateTimeSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
            if (propertySchema.getEnum() != null) {
                _enum = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    codegenProperty._enum.add((String)i);
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        codegenProperty.datatype = this.getTypeDeclaration(propertySchema);
        codegenProperty.dataFormat = propertySchema.getFormat();
        boolean isEnum = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-enum");
        if (isEnum) {
            codegenProperty.datatypeWithEnum = this.toEnumName(codegenProperty);
            codegenProperty.enumName = this.toEnumName(codegenProperty);
        } else {
            codegenProperty.datatypeWithEnum = codegenProperty.datatype;
        }
        codegenProperty.baseType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            codegenProperty.containerType = "array";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            if (propertySchema.getXml() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-wrapped", propertySchema.getXml().getWrapped() == null ? false : propertySchema.getXml().getWrapped());
                codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
                codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
                codegenProperty.xmlName = propertySchema.getXml().getName();
            }
            codegenProperty.maxItems = propertySchema.getMaxItems();
            codegenProperty.minItems = propertySchema.getMinItems();
            String itemName = null;
            if (propertySchema.getExtensions() != null && propertySchema.getExtensions().get("x-item-name") != null) {
                itemName = propertySchema.getExtensions().get("x-item-name").toString();
            }
            if (itemName == null) {
                itemName = codegenProperty.name;
            }
            Schema items = ((ArraySchema)propertySchema).getItems();
            CodegenProperty innerCodegenProperty = this.fromProperty(itemName, items);
            this.updatePropertyForArray(codegenProperty, innerCodegenProperty);
        } else if (propertySchema instanceof MapSchema || propertySchema.getAdditionalProperties() != null && propertySchema.getAdditionalProperties() instanceof Schema) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenProperty.containerType = "map";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            codegenProperty.minItems = propertySchema.getMinProperties();
            codegenProperty.maxItems = propertySchema.getMaxProperties();
            CodegenProperty cp = this.fromProperty("inner", (Schema)propertySchema.getAdditionalProperties());
            this.updatePropertyForMap(codegenProperty, cp);
        } else {
            if (StringUtils.isNotBlank((CharSequence)propertySchema.get$ref())) {
                codegenProperty.baseType = this.getSimpleRef(propertySchema.get$ref());
            }
            this.setNonArrayMapProperty(codegenProperty, type);
        }
        return codegenProperty;
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid array property " + Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        }
        property.items = innerProperty;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid map property " + Json.pretty((Object)property));
            return;
        }
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        }
        property.items = innerProperty;
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        boolean isMapContainer = ExtensionHelper.getBooleanValue(property, "x-is-map-container");
        boolean isListContainer = ExtensionHelper.getBooleanValue(property, "x-is-list-container");
        while (currentProperty != null && (isMapContainer || isListContainer)) {
            currentProperty = currentProperty.items;
        }
        boolean isEnum = ExtensionHelper.getBooleanValue(currentProperty, "x-is-enum");
        return currentProperty == null ? false : isEnum;
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        boolean isMapContainer = ExtensionHelper.getBooleanValue(property, "x-is-map-container");
        boolean isListContainer = ExtensionHelper.getBooleanValue(property, "x-is-list-container");
        while (currentProperty != null && (isMapContainer || isListContainer)) {
            currentProperty = currentProperty.items;
        }
        return currentProperty == null ? new HashMap() : currentProperty.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        boolean isMapContainer = ExtensionHelper.getBooleanValue(baseItem, "x-is-map-container");
        boolean isListContainer = ExtensionHelper.getBooleanValue(baseItem, "x-is-list-container");
        while (baseItem != null && (isMapContainer || isListContainer)) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            ModelUtils.updateCodegenPropertyEnum(property);
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        boolean isMapContainer = ExtensionHelper.getBooleanValue(baseItem, "x-is-map-container");
        boolean isListContainer = ExtensionHelper.getBooleanValue(baseItem, "x-is-list-container");
        while (baseItem != null && (isMapContainer || isListContainer)) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.getVendorExtensions().put("x-is-not-container", Boolean.TRUE);
        if (this.languageSpecificPrimitives().contains(type)) {
            property.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        } else {
            property.complexType = property.baseType;
        }
    }

    protected ApiResponse findMethodResponse(ApiResponses responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return (ApiResponse)responses.get(code);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas) {
        return this.fromOperation(path, httpMethod, operation, schemas, null);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        int offset;
        CodegenOperation codegenOperation = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        if (operation.getExtensions() != null && !operation.getExtensions().isEmpty()) {
            codegenOperation.vendorExtensions.putAll(operation.getExtensions());
        }
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (offset = operationId.indexOf(95)) > -1) {
            operationId = operationId.substring(offset + 1);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        codegenOperation.path = path;
        codegenOperation.operationId = this.toOperationId(operationId);
        codegenOperation.summary = this.escapeText(operation.getSummary());
        codegenOperation.unescapedNotes = operation.getDescription();
        codegenOperation.notes = this.escapeText(operation.getDescription());
        codegenOperation.getVendorExtensions().put("x-has-consumes", Boolean.FALSE);
        codegenOperation.getVendorExtensions().put("x-has-produces", Boolean.FALSE);
        if (operation.getDeprecated() != null) {
            codegenOperation.getVendorExtensions().put("x-is-deprecated", operation.getDeprecated());
        }
        this.addConsumesInfo(operation, codegenOperation);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            for (String key : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)key);
                this.addProducesInfo(response, codegenOperation);
                CodegenResponse codegenResponse = this.fromResponse(key, response);
                codegenResponse.getVendorExtensions().put("x-has-more", Boolean.TRUE);
                if (codegenResponse.baseType != null && !this.defaultIncludes.contains(codegenResponse.baseType) && !this.languageSpecificPrimitives.contains(codegenResponse.baseType)) {
                    imports.add(codegenResponse.baseType);
                }
                codegenResponse.getVendorExtensions().put("x-is-default", response == methodResponse);
                codegenOperation.responses.add(codegenResponse);
                if (ExtensionHelper.getBooleanValue(codegenResponse, "x-is-binary") && ExtensionHelper.getBooleanValue(codegenResponse, "x-is-default")) {
                    codegenOperation.getVendorExtensions().put("x-is-response-binary", Boolean.TRUE);
                }
                if (!ExtensionHelper.getBooleanValue(codegenResponse, "x-is-file") || !ExtensionHelper.getBooleanValue(codegenResponse, "x-is-default")) continue;
                codegenOperation.getVendorExtensions().put("x-is-response-file", Boolean.TRUE);
            }
            codegenOperation.responses.get(codegenOperation.responses.size() - 1).getVendorExtensions().put("x-has-more", Boolean.FALSE);
            if (methodResponse != null) {
                Schema responseSchema = this.getSchemaFromResponse(methodResponse);
                if (responseSchema != null) {
                    boolean isContainer;
                    Schema schemaDefinition;
                    CodegenProperty innerProperty;
                    CodegenProperty codegenProperty = this.fromProperty("response", responseSchema);
                    if (responseSchema instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)responseSchema;
                        innerProperty = this.fromProperty("response", arraySchema.getItems());
                        codegenOperation.returnBaseType = innerProperty.baseType;
                    } else if (responseSchema instanceof MapSchema) {
                        MapSchema mapSchema = (MapSchema)responseSchema;
                        innerProperty = this.fromProperty("response", (Schema)mapSchema.getAdditionalProperties());
                        codegenOperation.returnBaseType = innerProperty.baseType;
                    } else {
                        codegenOperation.returnBaseType = codegenProperty.complexType != null ? codegenProperty.complexType : codegenProperty.baseType;
                    }
                    codegenOperation.defaultResponse = this.toDefaultValue(responseSchema);
                    codegenOperation.returnType = codegenProperty.datatype;
                    boolean hasReference = schemas != null && schemas.containsKey(codegenOperation.returnBaseType);
                    codegenOperation.getVendorExtensions().put("x-has-reference", hasReference);
                    if (schemas != null && (schemaDefinition = schemas.get(codegenOperation.returnBaseType)) != null) {
                        CodegenModel cmod = this.fromModel(codegenOperation.returnBaseType, schemaDefinition, schemas);
                        codegenOperation.discriminator = cmod.discriminator;
                    }
                    if (isContainer = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-container")) {
                        codegenOperation.returnContainer = codegenProperty.containerType;
                        if ("map".equals(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
                        } else if ("list".equalsIgnoreCase(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                        } else if ("array".equalsIgnoreCase(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                        }
                    } else {
                        codegenOperation.returnSimpleType = true;
                    }
                    if (this.languageSpecificPrimitives().contains(codegenOperation.returnBaseType) || codegenOperation.returnBaseType == null) {
                        codegenOperation.returnTypeIsPrimitive = true;
                    }
                }
                this.addHeaders(methodResponse, codegenOperation.responseHeaders);
            }
        }
        List parameters = operation.getParameters();
        CodegenParameter bodyParam = null;
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        if (operation.getRequestBody() != null) {
            bodyParam = this.fromRequestBody(operation.getRequestBody(), schemas, imports);
            bodyParams.add(bodyParam);
            allParams.add(bodyParam);
        }
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (StringUtils.isNotBlank((CharSequence)param.get$ref())) {
                    param = this.getParameterFromRef(param.get$ref(), openAPI);
                }
                CodegenParameter codegenParameter = this.fromParameter(param, imports);
                if (this.ensureUniqueParams.booleanValue()) {
                    while (true) {
                        boolean exists = false;
                        for (CodegenParameter cp : allParams) {
                            if (!codegenParameter.paramName.equals(cp.paramName)) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) break;
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter);
                if (param instanceof QueryParameter) {
                    queryParams.add(codegenParameter.copy());
                } else if (param instanceof PathParameter) {
                    pathParams.add(codegenParameter.copy());
                } else if (param instanceof HeaderParameter) {
                    headerParams.add(codegenParameter.copy());
                } else if (param instanceof CookieParameter) {
                    cookieParams.add(codegenParameter.copy());
                }
                if (!codegenParameter.required) {
                    codegenOperation.getVendorExtensions().put("x-has-optional-params", Boolean.TRUE);
                    continue;
                }
                requiredParams.add(codegenParameter.copy());
            }
        }
        for (String i : imports) {
            if (!this.needToImport(i)) continue;
            codegenOperation.imports.add(i);
        }
        codegenOperation.bodyParam = bodyParam;
        codegenOperation.httpMethod = httpMethod.toUpperCase();
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        codegenOperation.allParams = DefaultCodegen.addHasMore(allParams);
        codegenOperation.bodyParams = DefaultCodegen.addHasMore(bodyParams);
        codegenOperation.pathParams = DefaultCodegen.addHasMore(pathParams);
        codegenOperation.queryParams = DefaultCodegen.addHasMore(queryParams);
        codegenOperation.headerParams = DefaultCodegen.addHasMore(headerParams);
        codegenOperation.formParams = DefaultCodegen.addHasMore(formParams);
        codegenOperation.requiredParams = DefaultCodegen.addHasMore(requiredParams);
        codegenOperation.externalDocs = operation.getExternalDocs();
        codegenOperation.nickname = codegenOperation.operationId;
        if (codegenOperation.allParams.size() > 0) {
            codegenOperation.getVendorExtensions().put("x-has-params", Boolean.TRUE);
        }
        boolean hasRequiredParams = codegenOperation.requiredParams.size() > 0;
        codegenOperation.getVendorExtensions().put("x-has-required-params", hasRequiredParams);
        codegenOperation.getVendorExtensions().put("x-is-restful-show", codegenOperation.isRestfulShow());
        codegenOperation.getVendorExtensions().put("x-is-restful-index", codegenOperation.isRestfulIndex());
        codegenOperation.getVendorExtensions().put("x-is-restful-create", codegenOperation.isRestfulCreate());
        codegenOperation.getVendorExtensions().put("x-is-restful-update", codegenOperation.isRestfulUpdate());
        codegenOperation.getVendorExtensions().put("x-is-restful-destroy", codegenOperation.isRestfulDestroy());
        codegenOperation.getVendorExtensions().put("x-is-restful", codegenOperation.isRestful());
        return codegenOperation;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse codegenResponse = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        codegenResponse.code = "default".equals(responseCode) ? "0" : responseCode;
        Schema responseSchema = this.getSchemaFromResponse(response);
        codegenResponse.schema = responseSchema;
        codegenResponse.message = this.escapeText(response.getDescription());
        codegenResponse.jsonSchema = Json.pretty((Object)response);
        if (response.getExtensions() != null && !response.getExtensions().isEmpty()) {
            codegenResponse.vendorExtensions.putAll(response.getExtensions());
        }
        this.addHeaders(response, codegenResponse.headers);
        codegenResponse.getVendorExtensions().put("x-has-headers", !codegenResponse.headers.isEmpty());
        if (responseSchema != null) {
            CodegenProperty codegenProperty = this.fromProperty("response", responseSchema);
            if (responseSchema instanceof ArraySchema) {
                ArraySchema arraySchema = (ArraySchema)responseSchema;
                CodegenProperty innerProperty = this.fromProperty("response", arraySchema.getItems());
                codegenResponse.baseType = innerProperty.baseType;
            } else {
                codegenResponse.baseType = codegenProperty.complexType != null ? codegenProperty.complexType : codegenProperty.baseType;
            }
            codegenResponse.dataType = codegenProperty.datatype;
            if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-string")) {
                codegenResponse.getVendorExtensions().put("x-is-string", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-boolean")) {
                codegenResponse.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-long")) {
                codegenResponse.getVendorExtensions().put("x-is-long", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-integer")) {
                codegenResponse.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-double")) {
                codegenResponse.getVendorExtensions().put("x-is-double", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-float")) {
                codegenResponse.getVendorExtensions().put("x-is-float", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-byte-array")) {
                codegenResponse.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-binary")) {
                codegenResponse.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-file")) {
                codegenResponse.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-date")) {
                codegenResponse.getVendorExtensions().put("x-is-date", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-date-time")) {
                codegenResponse.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-uuid")) {
                codegenResponse.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            } else {
                LOGGER.debug("Property type is not primitive: " + codegenProperty.datatype);
            }
            if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-container")) {
                codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.FALSE);
                codegenResponse.containerType = codegenProperty.containerType;
                codegenResponse.getVendorExtensions().put("x-is-map-container", "map".equals(codegenProperty.containerType));
                codegenResponse.getVendorExtensions().put("x-is-list-container", "list".equalsIgnoreCase(codegenProperty.containerType) || "array".equalsIgnoreCase(codegenProperty.containerType));
            } else {
                codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.TRUE);
            }
            codegenResponse.getVendorExtensions().put("x-is-primitive-type", codegenResponse.baseType == null || this.languageSpecificPrimitives().contains(codegenResponse.baseType));
        }
        if (codegenResponse.baseType == null) {
            codegenResponse.getVendorExtensions().put("x-is-map-container", Boolean.FALSE);
            codegenResponse.getVendorExtensions().put("x-is-list-container", Boolean.FALSE);
            codegenResponse.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
            codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.TRUE);
        }
        return codegenResponse;
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = parameter.getName();
        codegenParameter.description = this.escapeText(parameter.getDescription());
        codegenParameter.unescapedDescription = parameter.getDescription();
        if (parameter.getRequired() != null) {
            codegenParameter.required = parameter.getRequired();
        }
        codegenParameter.jsonSchema = Json.pretty((Object)parameter);
        if (System.getProperty("debugParser") != null) {
            LOGGER.info("working on Parameter " + parameter.getName());
        }
        if (parameter.getExtensions() != null && !parameter.getExtensions().isEmpty()) {
            codegenParameter.vendorExtensions.putAll(parameter.getExtensions());
        }
        if (parameter.getSchema() != null) {
            CodegenProperty codegenProperty;
            Schema parameterSchema = parameter.getSchema();
            String collectionFormat = null;
            if (parameterSchema instanceof ArraySchema) {
                CodegenProperty codegenProperty2;
                ArraySchema arraySchema = (ArraySchema)parameterSchema;
                Schema inner = arraySchema.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for array parameter \"" + parameter.getName() + "\", using String");
                    inner = new StringSchema().description("//TODO automatically added by swagger-codegen");
                    arraySchema.setItems(inner);
                }
                collectionFormat = this.getCollectionFormat(parameter);
                codegenParameter.items = codegenProperty2 = this.fromProperty("inner", inner);
                codegenParameter.baseType = codegenProperty2.datatype;
                codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                while (codegenProperty2 != null) {
                    imports.add(codegenProperty2.baseType);
                    codegenProperty2 = codegenProperty2.items;
                }
            } else if (parameterSchema instanceof MapSchema) {
                codegenParameter.items = codegenProperty = this.fromProperty("inner", (Schema)parameterSchema.getAdditionalProperties());
                codegenParameter.baseType = codegenProperty.datatype;
                codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
                collectionFormat = this.getCollectionFormat(parameter);
            }
            if (parameterSchema == null) {
                LOGGER.warn("warning!  Schema not found for parameter \"" + parameter.getName() + "\", using String");
                parameterSchema = new StringSchema().description("//TODO automatically added by swagger-codegen.");
            }
            codegenProperty = this.fromProperty(parameter.getName(), parameterSchema);
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            codegenParameter.dataType = codegenProperty.datatype;
            codegenParameter.dataFormat = codegenProperty.dataFormat;
            boolean isEnum = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-enum");
            if (isEnum) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
            }
            ModelUtils.updateCodegenPropertyEnum(codegenProperty);
            codegenParameter.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            codegenParameter.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            codegenParameter._enum = codegenProperty._enum;
            codegenParameter.allowableValues = codegenProperty.allowableValues;
            if (codegenProperty.items != null && ExtensionHelper.getBooleanValue(codegenProperty.items, "x-is-enum")) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
                codegenParameter.items = codegenProperty.items;
            }
            codegenParameter.collectionFormat = collectionFormat;
            if (collectionFormat != null && collectionFormat.equals("multi")) {
                codegenParameter.getVendorExtensions().put("x-is-collection-format-multi", Boolean.TRUE);
            }
            codegenParameter.paramName = this.toParamName(parameter.getName());
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            if (parameterSchema instanceof IntegerSchema) {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum().longValue());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum().longValue());
            } else {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum());
            }
            codegenParameter.exclusiveMaximum = parameterSchema.getExclusiveMaximum() == null ? false : parameterSchema.getExclusiveMaximum();
            codegenParameter.exclusiveMinimum = parameterSchema.getExclusiveMinimum() == null ? false : parameterSchema.getExclusiveMinimum();
            codegenParameter.maxLength = parameterSchema.getMaxLength();
            codegenParameter.minLength = parameterSchema.getMinLength();
            codegenParameter.pattern = this.toRegularExpression(parameterSchema.getPattern());
            codegenParameter.maxItems = parameterSchema.getMaxItems();
            codegenParameter.minItems = parameterSchema.getMinItems();
            codegenParameter.uniqueItems = parameterSchema.getUniqueItems() == null ? false : parameterSchema.getUniqueItems();
            codegenParameter.multipleOf = parameterSchema.getMultipleOf();
            if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null) {
                codegenParameter.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
        }
        if (parameter instanceof QueryParameter) {
            codegenParameter.getVendorExtensions().put("x-is-query-param", Boolean.TRUE);
        } else if (parameter instanceof PathParameter) {
            codegenParameter.required = true;
            codegenParameter.getVendorExtensions().put("x-is-path-param", Boolean.TRUE);
        } else if (parameter instanceof HeaderParameter) {
            codegenParameter.getVendorExtensions().put("x-is-header-param", Boolean.TRUE);
        } else if (parameter instanceof CookieParameter) {
            codegenParameter.getVendorExtensions().put("x-is-cookie-param", Boolean.TRUE);
        }
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-string")) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-boolean")) {
            codegenParameter.example = "true";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-long")) {
            codegenParameter.example = "789";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-integer")) {
            codegenParameter.example = "56";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-float")) {
            codegenParameter.example = "3.4";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-double")) {
            codegenParameter.example = "1.2";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-binary")) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-byte-array")) {
            codegenParameter.example = "B";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-file")) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-date")) {
            codegenParameter.example = "2013-10-20";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-date-time")) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (ExtensionHelper.getBooleanValue(codegenParameter, "x-is-uuid")) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        }
        this.setParameterExampleValue(codegenParameter);
        this.postProcessParameter(codegenParameter);
        return codegenParameter;
    }

    public CodegenParameter fromRequestBody(RequestBody body, Map<String, Schema> schemas, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = REQUEST_BODY_NAME;
        codegenParameter.paramName = REQUEST_BODY_NAME;
        codegenParameter.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
        codegenParameter.getVendorExtensions().put("x-is-body-param", Boolean.TRUE);
        String name = null;
        Schema schema = this.getSchemaFromBody(body);
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            name = this.getSimpleRef(schema.get$ref());
            schema = schemas.get(name);
        }
        if (("object".equals(schema.getType()) || schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty()) && !(schema instanceof MapSchema)) {
            CodegenModel codegenModel = null;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                schema.setName(name);
                codegenModel = this.fromModel(name, schema, schemas);
            }
            if (codegenModel != null && !codegenModel.emptyVars) {
                codegenParameter.paramName = codegenModel.classname.toLowerCase();
                codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
                imports.add(codegenParameter.dataType);
            } else {
                CodegenProperty codegenProperty = this.fromProperty("property", schema);
                if (codegenProperty != null) {
                    codegenParameter.baseType = codegenProperty.baseType;
                    codegenParameter.dataType = codegenProperty.datatype;
                    boolean isPrimitiveType = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-primitive-type");
                    boolean isBinary = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-binary");
                    boolean isFile = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-file");
                    codegenParameter.getVendorExtensions().put("x-is-primitive-type", isPrimitiveType);
                    codegenParameter.getVendorExtensions().put("x-is-binary", isBinary);
                    codegenParameter.getVendorExtensions().put("x-is-file", isFile);
                    if (codegenProperty.complexType != null) {
                        imports.add(codegenProperty.complexType);
                    }
                }
                this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            }
        } else if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                inner = new StringSchema().description("//TODO automatically added by swagger-codegen");
                arraySchema.setItems(inner);
            }
            CodegenProperty codegenProperty = this.fromProperty("inner", inner);
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            imports.add(codegenProperty.baseType);
            CodegenProperty innerCp = codegenProperty;
            while (innerCp != null) {
                if (innerCp.complexType != null) {
                    imports.add(innerCp.complexType);
                }
                innerCp = innerCp.items;
            }
            codegenParameter.items = codegenProperty;
            codegenParameter.dataType = codegenProperty.datatype;
            codegenParameter.baseType = codegenProperty.complexType;
            boolean isPrimitiveType = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-primitive-type");
            codegenParameter.getVendorExtensions().put("x-is-primitive-type", isPrimitiveType);
            codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenParameter.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            while (codegenProperty != null) {
                imports.add(codegenProperty.baseType);
                codegenProperty = codegenProperty.items;
            }
        }
        return codegenParameter;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().equals("file");
        }
        return false;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        if (securitySchemeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> securities = new ArrayList<CodegenSecurity>(securitySchemeMap.size());
        for (String key : securitySchemeMap.keySet()) {
            SecurityScheme schemeDefinition = securitySchemeMap.get(key);
            CodegenSecurity codegenSecurity = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
            codegenSecurity.name = key;
            codegenSecurity.type = schemeDefinition.getType().toString();
            if (SecurityScheme.Type.APIKEY.equals((Object)schemeDefinition.getType())) {
                codegenSecurity.keyParamName = schemeDefinition.getName();
                codegenSecurity.getVendorExtensions().put("x-is-api-key", Boolean.TRUE);
                boolean isKeyInHeader = schemeDefinition.getIn() == SecurityScheme.In.HEADER;
                codegenSecurity.getVendorExtensions().put("x-is-key-in-header", isKeyInHeader);
                codegenSecurity.getVendorExtensions().put("x-is-key-in-query", !isKeyInHeader);
            } else if (SecurityScheme.Type.HTTP.equals((Object)schemeDefinition.getType())) {
                codegenSecurity.getVendorExtensions().put("x-is-basic", Boolean.TRUE);
            } else if (SecurityScheme.Type.OAUTH2.equals((Object)schemeDefinition.getType())) {
                codegenSecurity.getVendorExtensions().put("x-is-oauth", Boolean.TRUE);
                OAuthFlows flows = schemeDefinition.getFlows();
                if (schemeDefinition.getFlows() == null) {
                    throw new RuntimeException("missing oauth flow in " + codegenSecurity.name);
                }
                if (flows.getPassword() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getPassword());
                    codegenSecurity.getVendorExtensions().put("x-is-password", Boolean.TRUE);
                    codegenSecurity.flow = "password";
                } else if (flows.getImplicit() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getImplicit());
                    codegenSecurity.getVendorExtensions().put("x-is-implicit", Boolean.TRUE);
                    codegenSecurity.flow = "implicit";
                } else if (flows.getClientCredentials() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getClientCredentials());
                    codegenSecurity.getVendorExtensions().put("x-is-application", Boolean.TRUE);
                    codegenSecurity.flow = "application";
                } else if (flows.getAuthorizationCode() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getAuthorizationCode());
                    codegenSecurity.getVendorExtensions().put("x-is-code", Boolean.TRUE);
                    codegenSecurity.flow = "accessCode";
                } else {
                    throw new RuntimeException("Could not identify any oauth2 flow in " + codegenSecurity.name);
                }
            }
            securities.add(codegenSecurity);
        }
        Collections.sort(securities, new Comparator<CodegenSecurity>(){

            @Override
            public int compare(CodegenSecurity one, CodegenSecurity another) {
                return ObjectUtils.compare((Comparable)((Object)one.name), (Comparable)((Object)another.name));
            }
        });
        Iterator it = securities.iterator();
        while (it.hasNext()) {
            CodegenSecurity security = (CodegenSecurity)it.next();
            security.getVendorExtensions().put("x-has-more", it.hasNext());
        }
        return securities;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase());
        }
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase());
    }

    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String part : parts) {
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = this.sanitizeName(builder.toString());
            LOGGER.warn("Empty operationId found for path: " + httpMethod + " " + path + ". Renamed to auto-generated operationId: " + operationId);
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(ApiResponse response, List<CodegenProperty> target) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                target.add(this.fromProperty((String)headers.getKey(), ((Header)headers.getValue()).getSchema()));
            }
        }
    }

    private static List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (i > 0) {
                    objs.get((int)i).secondaryParam = true;
                }
                if (i >= objs.size() - 1) continue;
                objs.get(i).getVendorExtensions().put("x-has-more", Boolean.TRUE);
            }
        }
        return objs;
    }

    private static Map<String, Object> addHasMore(Map<String, Object> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size() - 1; ++i) {
                if (i > 0) {
                    objs.put("secondaryParam", true);
                }
                if (i >= objs.size() - 1) continue;
                objs.put("hasMore", true);
            }
        }
        return objs;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!uniqueName.equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = uniqueName.toLowerCase();
        co.operationIdCamelCase = DefaultCodegen.camelize(uniqueName);
        co.operationIdSnakeCase = DefaultCodegen.underscore(uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    private void addParentContainer(CodegenModel codegenModel, String name, Schema property) {
        String mappedType;
        CodegenProperty codegenProperty = this.fromProperty(name, property);
        this.addImport(codegenModel, codegenProperty.complexType);
        codegenModel.parent = this.toInstantiationType(property);
        String containerType = codegenProperty.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(codegenModel, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(codegenModel, mappedType);
        }
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.replace(' ', '_');
        word = word.toLowerCase();
        return word;
    }

    protected String dashize(String word) {
        return DefaultCodegen.underscore(word).replaceAll("[_ ]", "-");
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    private void addVars(CodegenModel codegenModel, Map<String, Schema> properties, List<String> required) {
        this.addVars(codegenModel, properties, required, null, null);
    }

    private void addVars(CodegenModel codegenModel, Map<String, Schema> properties, List<String> required, Map<String, Schema> allProperties, List<String> allRequired) {
        codegenModel.getVendorExtensions().put("x-has-required", Boolean.FALSE);
        if (properties != null && !properties.isEmpty()) {
            codegenModel.getVendorExtensions().put("x-has-vars", true);
            codegenModel.getVendorExtensions().put("x-has-enums", false);
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(codegenModel, codegenModel.vars, properties, mandatory);
            codegenModel.mandatory = mandatory;
            codegenModel.allMandatory = codegenModel.mandatory;
        } else {
            codegenModel.emptyVars = true;
            codegenModel.getVendorExtensions().put("x-has-vars", false);
            codegenModel.getVendorExtensions().put("x-has-enums", false);
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(codegenModel, codegenModel.allVars, allProperties, allMandatory);
            codegenModel.allMandatory = allMandatory;
        }
    }

    private void addVars(CodegenModel codegenModel, List<CodegenProperty> vars, Map<String, Schema> properties, Set<String> mandatory) {
        ArrayList<Map.Entry<String, Schema>> propertyList = new ArrayList<Map.Entry<String, Schema>>(properties.entrySet());
        int totalCount = propertyList.size();
        for (int i = 0; i < totalCount; ++i) {
            Map.Entry entry = (Map.Entry)propertyList.get(i);
            String key = (String)entry.getKey();
            Schema propertySchema = (Schema)entry.getValue();
            if (propertySchema == null) {
                LOGGER.warn("null property for " + key);
                continue;
            }
            CodegenProperty cp = this.fromProperty(key, propertySchema);
            cp.required = mandatory.contains(key);
            boolean hasRequired = ExtensionHelper.getBooleanValue(codegenModel, "x-has-required") || cp.required;
            boolean hasOptional = ExtensionHelper.getBooleanValue(codegenModel, "x-has-optional") || !cp.required;
            codegenModel.getVendorExtensions().put("x-has-required", hasRequired);
            codegenModel.getVendorExtensions().put("x-has-optional", hasOptional);
            boolean isEnum = ExtensionHelper.getBooleanValue(cp, "x-is-enum");
            if (isEnum) {
                codegenModel.getVendorExtensions().put("x-has-enums", true);
            }
            if (!ExtensionHelper.getBooleanValue(cp, "x-is-read-only")) {
                codegenModel.getVendorExtensions().put("x-has-only-read-only", Boolean.FALSE);
            }
            if (i + 1 != totalCount) {
                cp.getVendorExtensions().put("x-has-more", Boolean.TRUE);
                if (!Boolean.TRUE.equals(((Schema)((Map.Entry)propertyList.get(i + 1)).getValue()).getReadOnly())) {
                    cp.getVendorExtensions().put("x-has-more-non-read-only", Boolean.TRUE);
                }
            }
            if (ExtensionHelper.getBooleanValue(cp, "x-is-container")) {
                this.addImport(codegenModel, this.typeMapping.get("array"));
            }
            this.addImport(codegenModel, cp.baseType);
            CodegenProperty innerCp = cp;
            while (innerCp != null) {
                this.addImport(codegenModel, innerCp.complexType);
                innerCp = innerCp.items;
            }
            vars.add(cp);
            if (Boolean.TRUE.equals(cp.required)) {
                codegenModel.requiredVars.add(cp);
            } else {
                codegenModel.optionalVars.add(cp);
            }
            if (ExtensionHelper.getBooleanValue(cp, "x-is-read-only")) {
                codegenModel.readOnlyVars.add(cp);
                continue;
            }
            codegenModel.readWriteVars.add(cp);
        }
    }

    private static Map<String, String> getAllAliases(Map<String, Schema> allSchemas) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        if (allSchemas == null || allSchemas.isEmpty()) {
            return aliases;
        }
        for (Map.Entry<String, Schema> entry : allSchemas.entrySet()) {
            String swaggerName = entry.getKey();
            Schema schema = entry.getValue();
            if (schema.getType() == null || schema.getType().equals("object") || schema.getEnum() != null) continue;
            aliases.put(swaggerName, schema.getType());
        }
        return aliases;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        String result = StringUtils.join((Iterable)Lists.transform((List)Lists.newArrayList((Object[])name.split(nonNameElementPattern)), (Function)new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return StringUtils.capitalize((String)input);
            }
        }), (String)"");
        if (result.length() > 0) {
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    public static String camelize(String word) {
        return DefaultCodegen.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            String upperCase;
            String original = m.group(2);
            word = original.equals(upperCase = original.toUpperCase()) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
            m = p.matcher(word);
        }
        p = Pattern.compile("(-)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        return word;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + '/' + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String apiDocFilename(String templateName, String tag) {
        String suffix = this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + '/' + this.toApiDocFilename(tag) + suffix;
    }

    @Override
    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + '/' + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    @Override
    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    @Override
    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    @Override
    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    @Override
    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    @Override
    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    @Override
    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    @Override
    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    @Override
    public String getGitUserId() {
        return this.gitUserId;
    }

    @Override
    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    @Override
    public String getGitRepoId() {
        return this.gitRepoId;
    }

    @Override
    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    @Override
    public String getReleaseNote() {
        return this.releaseNote;
    }

    @Override
    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    public String sanitizeName(String name) {
        if (name == null) {
            LOGGER.error("String to be sanitized is null. Default to " + Object.class.getSimpleName());
            return Object.class.getSimpleName();
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        name = this.allowUnicodeIdentifiers != false ? Pattern.compile("\\W", 256).matcher(name).replaceAll("") : name.replaceAll("\\W", "");
        return name;
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = DefaultCodegen.camelize(this.sanitizeName(tag))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    @Override
    public void addHandlebarHelpers(Handlebars handlebars) {
        handlebars.registerHelper("is", (Helper)new IsHelper());
        handlebars.registerHelper("has", (Helper)new HasHelper());
        handlebars.registerHelper("isNot", (Helper)new IsNotHelper());
        handlebars.registerHelper("hasNot", (Helper)new HasNotHelper());
    }

    public void writeOptional(String outputFolder, SupportingFile supportingFile) {
        String folder = "";
        if (outputFolder != null && !"".equals(outputFolder)) {
            folder = folder + outputFolder + File.separator;
        }
        if (!new File(folder = !"".equals(folder = folder + supportingFile.folder) ? folder + File.separator + supportingFile.destinationFilename : supportingFile.destinationFilename).exists()) {
            this.supportingFiles.add(supportingFile);
        } else {
            LOGGER.info("Skipped overwriting " + supportingFile.destinationFilename + " as the file already exists in " + folder);
        }
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        if (ExtensionHelper.getBooleanValue(property, "x-is-uuid") && ExtensionHelper.getBooleanValue(property, "x-is-string")) {
            parameter.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.FALSE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-byte-array")) {
            parameter.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-string")) {
            parameter.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-boolean")) {
            parameter.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-long")) {
            parameter.getVendorExtensions().put("x-is-long", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-integer")) {
            parameter.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-double")) {
            parameter.getVendorExtensions().put("x-is-double", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-float")) {
            parameter.getVendorExtensions().put("x-is-float", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-number")) {
            parameter.getVendorExtensions().put("x-is-number", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-binary")) {
            parameter.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-file")) {
            parameter.getVendorExtensions().put("x-is-file", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-date")) {
            parameter.getVendorExtensions().put("x-is-date", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue(property, "x-is-date-time")) {
            parameter.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
        } else {
            LOGGER.debug("Property type is not primitive: " + property.datatype);
            parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.FALSE);
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = this.convertPropertyToBoolean(propertyKey);
            this.writePropertyBack(propertyKey, booleanValue);
        }
        return booleanValue;
    }

    @Override
    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    @Override
    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected String getContentType(RequestBody requestBody) {
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return null;
        }
        return (String)new ArrayList(requestBody.getContent().keySet()).get(0);
    }

    protected Schema getSchemaFromBody(RequestBody requestBody) {
        String contentType = (String)new ArrayList(requestBody.getContent().keySet()).get(0);
        MediaType mediaType = (MediaType)requestBody.getContent().get((Object)contentType);
        return mediaType.getSchema();
    }

    protected Schema getSchemaFromResponse(ApiResponse response) {
        Schema schema;
        block1: {
            if (response.getContent() == null || response.getContent().isEmpty()) {
                return null;
            }
            schema = null;
            Iterator iterator = response.getContent().values().iterator();
            if (!iterator.hasNext()) break block1;
            MediaType mediaType = (MediaType)iterator.next();
            schema = mediaType.getSchema();
        }
        return schema;
    }

    protected Parameter getParameterFromRef(String ref, OpenAPI openAPI) {
        String parameterName = ref.substring(ref.lastIndexOf(47) + 1);
        Map parameterMap = openAPI.getComponents().getParameters();
        return (Parameter)parameterMap.get(parameterName);
    }

    private void setOauth2Info(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        codegenSecurity.authorizationUrl = flow.getAuthorizationUrl();
        codegenSecurity.tokenUrl = flow.getTokenUrl();
        codegenSecurity.scopes = flow.getScopes();
    }

    private List<Schema> getInterfaces(ComposedSchema composed) {
        if (composed.getAllOf() != null && composed.getAllOf().size() > 1) {
            return composed.getAllOf().subList(1, composed.getAllOf().size());
        }
        if (composed.getAnyOf() != null && !composed.getAnyOf().isEmpty()) {
            return composed.getAnyOf();
        }
        if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
            return composed.getOneOf();
        }
        return null;
    }

    protected void addConsumesInfo(Operation operation, CodegenOperation codegenOperation) {
        if (operation.getRequestBody() == null || operation.getRequestBody().getContent() == null || operation.getRequestBody().getContent().isEmpty()) {
            return;
        }
        Set consumes = operation.getRequestBody().getContent().keySet();
        ArrayList<Map<String, String>> mediaTypeList = new ArrayList<Map<String, String>>();
        int count = 0;
        for (String key : consumes) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            if ("*/*".equals(key)) {
                mediaType.put("mediaType", key);
            } else {
                mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
            }
            if (++count < consumes.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            mediaTypeList.add(mediaType);
        }
        codegenOperation.consumes = mediaTypeList;
        codegenOperation.getVendorExtensions().put("x-has-consumes", Boolean.TRUE);
    }

    public static Set<String> getConsumesInfo(Operation operation) {
        if (operation.getRequestBody() == null || operation.getRequestBody().getContent() == null || operation.getRequestBody().getContent().isEmpty()) {
            return null;
        }
        return operation.getRequestBody().getContent().keySet();
    }

    protected void addProducesInfo(ApiResponse response, CodegenOperation codegenOperation) {
        if (response == null || response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        Set produces = response.getContent().keySet();
        if (codegenOperation.produces == null) {
            codegenOperation.produces = new ArrayList<Map<String, String>>();
        }
        int count = 0;
        for (String key : produces) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            if ("*/*".equals(key)) {
                mediaType.put("mediaType", key);
            } else {
                mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
            }
            if (++count < produces.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            codegenOperation.produces.add(mediaType);
            codegenOperation.getVendorExtensions().put("x-has-produces", Boolean.TRUE);
        }
    }

    public static Set<String> getProducesInfo(Operation operation) {
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            return null;
        }
        return operation.getResponses().keySet();
    }

    protected Schema detectParent(ComposedSchema composedSchema, Map<String, Schema> allSchemas) {
        if (composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
            Schema schema = (Schema)composedSchema.getAllOf().get(0);
            String ref = schema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) {
                return null;
            }
            ref = this.getSimpleRef(ref);
            return allSchemas.get(ref);
        }
        return null;
    }

    protected String getParentName(ComposedSchema composedSchema, Map<String, Schema> allSchemas) {
        if (composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
            Schema schema = (Schema)composedSchema.getAllOf().get(0);
            String ref = schema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) {
                return null;
            }
            return this.getSimpleRef(ref);
        }
        return null;
    }

    protected String getSimpleRef(String ref) {
        if (ref.startsWith("#/components/schemas/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        }
        return ref;
    }

    protected String getCollectionFormat(Parameter parameter) {
        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
            if (parameter.getExplode() != null && parameter.getExplode().booleanValue()) {
                return "csv";
            }
            return "multi";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle())) {
            return "pipe";
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle())) {
            return "space";
        }
        return null;
    }

    protected static boolean hasSchemaProperties(Schema schema) {
        Object additionalProperties = schema.getAdditionalProperties();
        return additionalProperties != null && additionalProperties instanceof Schema;
    }

    @Override
    public CodegenType getTag() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getHelp() {
        return null;
    }
}

