/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeField;

@Component
public class ModelAttributeParameterExpander {
    private static final Logger LOG = LoggerFactory.getLogger(ModelAttributeParameterExpander.class);
    private final FieldProvider fieldProvider;
    @Autowired
    protected DocumentationPluginsManager pluginsManager;

    @Autowired
    public ModelAttributeParameterExpander(FieldProvider fields) {
        this.fieldProvider = fields;
    }

    public List<Parameter> expand(String parentName, ResolvedType paramType, DocumentationContext documentationContext) {
        ArrayList parameters = Lists.newArrayList();
        Set<String> beanPropNames = this.getBeanPropertyNames(paramType.getErasedType());
        FluentIterable fields = FluentIterable.from((Iterable)this.fieldProvider.in(paramType)).filter(this.onlyBeanProperties(beanPropNames));
        LOG.debug("Expanding parameter type: {}", (Object)paramType);
        AlternateTypeProvider alternateTypeProvider = documentationContext.getAlternateTypeProvider();
        FluentIterable modelAttributes = FluentIterable.from((Iterable)fields).transform(this.toModelAttributeField(alternateTypeProvider));
        FluentIterable expendables = modelAttributes.filter(Predicates.not(this.simpleType())).filter(Predicates.not(this.recursiveType(paramType)));
        for (Object each : expendables) {
            LOG.debug("Attempting to expand expandable field: {}", (Object)((ModelAttributeField)each).getField());
            parameters.addAll(this.expand(this.nestedParentName(parentName, ((ModelAttributeField)each).getField()), ((ModelAttributeField)each).getFieldType(), documentationContext));
        }
        FluentIterable collectionTypes = modelAttributes.filter(Predicates.and(this.isCollection(), (Predicate)Predicates.not(this.recursiveCollectionItemType(paramType))));
        for (ModelAttributeField each : collectionTypes) {
            LOG.debug("Attempting to expand collection/array field: {}", (Object)each.getField());
            ResolvedType itemType = Collections.collectionElementType((ResolvedType)each.getFieldType());
            if (Types.isBaseType((ResolvedType)itemType)) {
                parameters.add(this.simpleFields(parentName, documentationContext, each));
                continue;
            }
            parameters.addAll(this.expand(this.nestedParentName(parentName, each.getField()), itemType, documentationContext));
        }
        FluentIterable simpleFields = modelAttributes.filter(this.simpleType());
        for (ModelAttributeField each : simpleFields) {
            parameters.add(this.simpleFields(parentName, documentationContext, each));
        }
        return FluentIterable.from((Iterable)parameters).filter(Predicates.not(this.hiddenParameters())).toList();
    }

    private Predicate<ModelAttributeField> recursiveCollectionItemType(final ResolvedType paramType) {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Objects.equal((Object)Collections.collectionElementType((ResolvedType)input.getFieldType()), (Object)paramType);
            }
        };
    }

    private Predicate<Parameter> hiddenParameters() {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return input.isHidden();
            }
        };
    }

    private Parameter simpleFields(String parentName, DocumentationContext documentationContext, ModelAttributeField each) {
        LOG.debug("Attempting to expand field: {}", (Object)each);
        String dataTypeName = (String)Optional.fromNullable((Object)Types.typeNameFor((Type)each.getFieldType().getErasedType())).or((Object)each.getFieldType().getErasedType().getSimpleName());
        LOG.debug("Building parameter for field: {}, with type: ", (Object)each, (Object)each.getFieldType());
        ParameterExpansionContext parameterExpansionContext = new ParameterExpansionContext(dataTypeName, parentName, each.getField(), documentationContext.getDocumentationType(), new ParameterBuilder());
        return this.pluginsManager.expandParameter(parameterExpansionContext);
    }

    private Predicate<ModelAttributeField> recursiveType(final ResolvedType paramType) {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Objects.equal((Object)input.getFieldType(), (Object)paramType);
            }
        };
    }

    private Predicate<ModelAttributeField> simpleType() {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(this.isCollection()), Predicates.not(this.isMap()), Predicates.or((Predicate[])new Predicate[]{this.belongsToJavaPackage(), this.isBaseType(), this.isEnum()})});
    }

    private Predicate<ModelAttributeField> isCollection() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Collections.isContainerType((ResolvedType)input.getFieldType());
            }
        };
    }

    private Predicate<ModelAttributeField> isMap() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Maps.isMapType((ResolvedType)input.getFieldType());
            }
        };
    }

    private Predicate<ModelAttributeField> isEnum() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return input.getFieldType().getErasedType().isEnum();
            }
        };
    }

    private Predicate<ModelAttributeField> belongsToJavaPackage() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return ModelAttributeParameterExpander.this.packageName(input.getFieldType().getErasedType()).startsWith("java.lang");
            }
        };
    }

    private Predicate<ModelAttributeField> isBaseType() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Types.isBaseType((ResolvedType)input.getFieldType()) || input.getField().getType().isPrimitive();
            }
        };
    }

    private Function<ResolvedField, ModelAttributeField> toModelAttributeField(final AlternateTypeProvider alternateTypeProvider) {
        return new Function<ResolvedField, ModelAttributeField>(){

            public ModelAttributeField apply(ResolvedField input) {
                return new ModelAttributeField(ModelAttributeParameterExpander.this.fieldType(alternateTypeProvider, input), input);
            }
        };
    }

    private Predicate<ResolvedField> onlyBeanProperties(final Set<String> beanPropNames) {
        return new Predicate<ResolvedField>(){

            public boolean apply(ResolvedField input) {
                return beanPropNames.contains(input.getName());
            }
        };
    }

    private String nestedParentName(String parentName, ResolvedField field) {
        String name = field.getName();
        ResolvedType fieldType = field.getType();
        if (Collections.isContainerType((ResolvedType)fieldType) && !Types.isBaseType((ResolvedType)Collections.collectionElementType((ResolvedType)fieldType))) {
            name = name + "[0]";
        }
        if (Strings.isNullOrEmpty((String)parentName)) {
            return name;
        }
        return String.format("%s.%s", parentName, name);
    }

    private ResolvedType fieldType(AlternateTypeProvider alternateTypeProvider, ResolvedField field) {
        return alternateTypeProvider.alternateFor(field.getType());
    }

    private String packageName(Class<?> type) {
        return (String)Optional.fromNullable((Object)type.getPackage()).transform(this.toPackageName()).or((Object)"java");
    }

    private Function<Package, String> toPackageName() {
        return new Function<Package, String>(){

            public String apply(Package input) {
                return input.getName();
            }
        };
    }

    private Set<String> getBeanPropertyNames(Class<?> clazz) {
        try {
            PropertyDescriptor[] propDescriptors;
            HashSet<String> beanProps = new HashSet<String>();
            for (PropertyDescriptor propDescriptor : propDescriptors = this.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (propDescriptor.getReadMethod() == null || propDescriptor.getWriteMethod() == null) continue;
                beanProps.add(propDescriptor.getName());
            }
            return beanProps;
        }
        catch (IntrospectionException e) {
            LOG.warn(String.format("Failed to get bean properties on (%s)", clazz), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    @VisibleForTesting
    BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz);
    }
}

